local M = {}

local lastIgnitionLevel = 0
local soundVolume = 0
local soundNode = v.data.refNodes[0].ref
local soundObj = nil
local playOutside = false

local camPos
local vehPos
local camDistToCar
local isInCar

local function checkCamInside()
    camPos = obj:getCameraPosition()

    if camPos and vehPos then
        camDistToCar = camPos:distance(vehPos)
        isInCar = camDistToCar <= 0.6
        obj:setVolume(soundObj, isInCar and soundVolume or 0)
    end

    vehPos = obj:getPosition() + obj:getNodePosition(beamstate.nodeNameMap["fueltank"])
end

-- Debugging function to print node names
local function printNodeNames()
    print("Printing node names:")
    for k, v in pairs(beamstate.nodeNameMap) do
        print(k, v)
    end

    -- Ensure the node name is correct and exists
    local nodeName = beamstate.nodeNameMap[soundNode]
    print("Sound node value: ", soundNode) -- Added debug print
    if nodeName then
        vehPos = obj:getPosition() + obj:getNodePosition(nodeName)
        print("Fuel Tank Node Position:", obj:getNodePosition(nodeName))
    else
        print("Node name not found in nodeNameMap:", soundNode)
    end
end

local function updateGFX(dt)
    local ignitionLevel = electrics.values.ignitionLevel

    if not playOutside then checkCamInside() end
    if ignitionLevel == 2 and lastIgnitionLevel == 1 then
        obj:playSFX(soundObj)
    elseif ignitionLevel == 1 and lastIgnitionLevel == 2 then
        obj:stopSFX(soundObj)
        obj:cutSFX(soundObj)
    end

    lastIgnitionLevel = electrics.values.ignitionLevel
end

local function initSounds(jbeamData)
    soundObj = obj:createSFXSource2(jbeamData.sound, "AudioDefaultLoop3D", "", soundNode, 0)
    if playOutside then
        obj:setVolume(soundObj, soundVolume)
    end
    print("Sound object created with node:", soundNode)
end

local function init(jbeamData)
    soundNode = jbeamData.soundNode or soundNode
    soundVolume = jbeamData.soundVolume or soundVolume
    playOutside = jbeamData.playOutside or false
    print("Initialized with node:", soundNode)
end

M.updateGFX = updateGFX
M.initSounds = initSounds
M.init = init

return M
