-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

--round from http://lua-users.org/wiki/SimpleRound


local M = {}

local speed, rpm, gear, led_off1
local curWheel

local unitVel = 3.6
local unitVol = 1
local unitTemp = 1
local unitTemp1 = 0


local vehicleID = obj:getID()
local dashScreenName = "@rx7_race_screen"


local function round(num, idp)
	if num then
		local mult = 10^(idp or 0)
		return math.floor(num * mult + 0.5) / mult
	else
		return 0
	end
end



local function runFunc(func)
	obj:queueGameEngineLua("if be:getObjectByID("..vehicleID..") then be:getObjectByID("..vehicleID.."):queueJSUITexture('"..dashScreenName.."', '"..func.."') end")
end





local function onInit()
		obj:queueGameEngineLua("extensions.loadModule('ui/uinavi')")
		obj:queueGameEngineLua('be:getObjectByID('..vehicleID..'):createUITexture("'..dashScreenName..'", "local://local/vehicles/rx7/dash.html", 1024, 512, UI_TEXTURE_USAGE_AUTOMATIC, 30)')
end

local function updateGFX(dt)
		
		speed = math.floor(((electrics.values.wheelspeed or 0) * unitVel) + 0.5)
		rpm = math.floor(electrics.values.rpm + 0.5)
		gear = math.floor(electrics.values.gearIndex + 0.5)
		
		
		led_off1 = electrics.values["led_off1"]
		
		runFunc("updateSpeed("..speed..")")
		runFunc("updateGear("..gear..")")
		runFunc("updateRpm("..rpm..")")
	
end

-- public interface
M.onInit    = onInit
M.onReset   = onReset
M.updateGFX = updateGFX

return M
