# RLS Career Overhaul v2.5 (0.37.1)

Welcome to the **RLS Career Overhaul** mod for BeamNG.drive! This mod enhances various aspects of the game, including freeroam events, police interactions, the economy, deliveries, insurance, garage space, and dealerships. Dive into a more immersive and challenging career mode enriched with new features and improvements.

---

## Table of Contents

- [RLS Career Overhaul v2.5 (0.37.1)](#rls-career-overhaul-v25-0371)
  - [Table of Contents](#table-of-contents)
  - [Installation](#installation)
  - [Settings Manager](#settings-manager)
    - [Available Settings](#available-settings)
  - [Overview](#overview)
  - [Features](#features)
    - [Freeroam Events](#freeroam-events)
      - [Drag Events](#drag-events)
      - [Rally Events](#rally-events)
      - [Circuit Events](#circuit-events)
      - [Drift Events](#drift-events)
      - [Rock Crawl Events](#rock-crawl-events)
    - [Vehicle Rental](#vehicle-rental)
    - [Freeroam Repo Missions](#freeroam-repo-missions)
    - [Police](#police)
    - [Economy](#economy)
    - [Deliveries](#deliveries)
    - [Insurance](#insurance)
      - [Insurance Policies](#insurance-policies)
      - [Policy Score](#policy-score)
    - [Garage Space](#garage-space)
    - [Dealerships](#dealerships)
      - [Belasco Auto](#belasco-auto)
      - [Jefferson Motors](#jefferson-motors)
      - [Rich's Motor Company](#richs-motor-company)
      - [Quarryside Auto Sales](#quarryside-auto-sales)
      - [Smash Rollers](#smash-rollers)
      - [Online Brand Dealerships](#online-brand-dealerships)
      - [Commercial Vehicle Sales](#commercial-vehicle-sales)
      - [Trailer Dealer](#trailer-dealer)
      - [Service Dealership](#service-dealership)
      - [Private Sellers](#private-sellers)
      - [Gizamn's Rod Shop](#gizamns-rod-shop)
      - [Trusted Auto Sales](#trusted-auto-sales)
      - [Joe's Junk](#joes-junk)
      - [Fast Automotive](#fast-automotive)
      - [Police Dealership](#police-dealership)
    - [Car Meets](#car-meets)
      - [Meet Locations](#meet-locations)
      - [Meet Types](#meet-types)
      - [Features](#features-1)
    - [Time Management](#time-management)
      - [Preset Times](#preset-times)
      - [Time Control](#time-control)
    - [Police Certification](#police-certification)
      - [Process](#process)
      - [Details](#details)
    - [Vehicle Value System](#vehicle-value-system)
    - [Phone UI](#phone-ui)
    - [Taxi Work](#taxi-work)
    - [Marketplace](#marketplace)
    - [Hardcore Mode](#hardcore-mode)
    - [General Adjustments](#general-adjustments)
  - [Conclusion](#conclusion)
  - [Notes](#notes)

---

## Installation

1. **Download the Mod**:

   - Navigate to the [Releases](https://github.com/Raceless-RLS/rls_career_overhaul/releases) section of the mod's GitHub page.
   - Select the latest release.
   - Scroll to the bottom and download `rls_career_overhaul_v2.X.X.zip`.
   - Download `rls_no_police.zip` if you don't want the police to spawn in career mode.

2. **Move to Mods Folder**:

   - Locate your BeamNG.drive `mods` folder. The default path is:
     ```
     %AppData%\BeamNG.drive\"Latest"\mods
     ```
     *Note: Replace **************************************************`Latest`************************************************** with your current game version.*
   - Copy the downloaded ZIP file into the `mods` folder.

3. **Enable the Mod**:

   - Launch **BeamNG.drive**.
   - Go to **Mods Manager** in the game's settings.
   - Enable the **RLS Career Overhaul** mod.

---

## Settings Manager

The **RLS Career Overhaul** includes a convenient settings manager accessible from the main menu:

- **Access**: Look for the "Overhaul Manager" button in the main menu
- **Interface**: Clean, modern UI with toggle switches for easy configuration

### Available Settings

- **Map Dev Mode**:
  - **Purpose**: Enable developer mode for map editing and testing
  - **Important**: When disabled, this setting clears the levels folder for all associated maps unless it's enabled
  - **Use Case**: For modders and advanced users working with map modifications

- **No Police Mode**:
  - **Purpose**: Disable police enforcement in career mode
  - **Effect**: Prevents police from spawning and pursuing players
  - **Note**: Useful for peaceful gameplay sessions

- **No Parked Mode**:
  - **Purpose**: Remove parked vehicles from the world
  - **Effect**: Clears static parked cars from maps for better performance or cleaner environments

All settings are automatically saved and persist between game sessions. The settings are stored in `settings/RLS/careerOverhaul.json`.

---

## Overview

The **RLS Career Overhaul** mod significantly enhances the career mode experience in BeamNG.drive. It introduces a variety of freeroam events, dynamic police interactions, an improved economy, revamped deliveries, a sophisticated insurance system, expanded garage space, reworked dealerships, and more.

Now, the mod is also **compatible with Italy** (using the Italy Addon). The Italy Addon is available via the Silver Patreon Membership.

---

## Features

### Freeroam Events

Experience an array of new racing events designed to challenge and entertain you. Each event has unique requirements and rewards, offering something for every racing enthusiast.

#### Drag Events

- **No Prep Highway Drag**:

  - **Description**: A high-speed drag race along the highway. Test your vehicle's top speed and acceleration on an unprepped surface.
  - **Requirements**:
    - **Target Time**: **17 seconds**
    - **Reward**: **\$1,700**

- **Drag Strip**:

  - **Description**: A classic quarter-mile drag race at the official drag strip. Perfect for those who crave pure acceleration.
  - **Requirements**:
    - **Target Time**: **11 seconds**
    - **Reward**: **\$1,000**

- **Shallow Mud Drag**:

  - **Description**: A high-speed drag race along the mud track. Test your vehicle's capabilities in the shallow mud.
  - **Requirements**:
    - **Target Time**: **8 seconds**
    - **Reward**: **\$1,500**

- **Deep Mud Drag**:

  - **Description**: A high-speed drag race along the mud track. Test your vehicle's capabilities in the deep mud. Can you make it through?
  - **Requirements**:
    - **Target Time**: **12 seconds**
    - **Reward**: **\$2,700**

#### Rally Events

- **Rally Event #1**:

  - **Description**: A timed rally event with a mix of dirt and paved roads.
  - **Requirements**:
    - **Target Time**: **70 seconds**
    - **Reward**: **\$2,000**

- **Rally Event #2**:

  - **Description**: A timed rally event with a mix of dirt and paved roads.
  - **Requirements**:
    - **Target Time**: **120 seconds**
    - **Reward**: **\$2,500**

- **Rally Event #3**:

  - **Description**: A timed rally event with a mix of dirt and paved roads.
  - **Requirements**:
    - **Target Time**: **185 seconds**
    - **Reward**: **\$3,000**

- **Rally Event #4**:

  - **Description**: A timed rally event with a mix of dirt and paved roads.
  - **Requirements**:
    - **Target Time**: **90 seconds**
    - **Reward**: **\$2,000**

- **Commercial Rally**:

  - **Description**: Navigate through commercial areas in a timed rally event. Sharp turns and urban obstacles await.
  - **Requirements**:
    - **Target Time**: **90 seconds**
    - **Reward**: **\$2,000**

#### Circuit Events

- **Quarry Circuit**:

  - **Description**: A challenging circuit around the quarry with elevation changes and tight corners.
  - **Requirements**:
    - **Target Time**: **27 seconds**
    - **Reward**: **\$1,000**
  - **Note**: This circuit has been rebalanced ("Nerfed") to adjust difficulty and rewards.

- **Beach Circuit**:

  - **Description**: Race along the scenic beachside track under the bridge.
  - **Requirements**:
    - **Target Time**: **30 seconds**
    - **Reward**: **\$1,500**
  - **Note**: Updated in this release.

- **Dirt Circuit**:

  - **Description**: Conquer the dirt track with off-road vehicles.
  - **Requirements**:
    - **Target Time**: **65 seconds**
    - **Reward**: **\$2,000**

- **Dirt Oval**:

  - **Description**: A classic oval dirt track race, emphasizing consistent speed and smooth turns.
  - **Requirements**:
    - **Target Time**: **30 seconds**
    - **Reward**: **\$350**

- **Paved Oval**:

  - **Description**: Race on an oval asphalt track, focusing on high-speed cornering and vehicle stability.
  - **Requirements**:
    - **Target Time**: **30 seconds**
    - **Reward**: **\$350**

- **West Coast Circuit**:

  - **Description**: Race on the standard or short versions of the West Coast track. Ideal for testing your vehicle's handling and your driving skills.
  - **Requirements**:
    - **Standard Track**:
      - **Target Time**: **140 seconds**
      - **Reward**: **\$2,250**
    - **Short Track**:
      - **Target Time**: **100 seconds**
      - **Reward**: **\$1,750**

- **Rubberband Ridge**:

  - **Description**: A challenging circuit with elevation changes and tight corners.
  - **Requirements**:
    - **Standard Lap**:
      - **Target Time**: **60 seconds**
      - **Reward**: **\$1,250**
    - **Joker Lap**:
      - **Target Time**: **65 seconds**
      - **Reward**: **\$1,250**

- **King of the Hammer #1**:

  - **Description**: A timed rally event with a mix of dirt and paved roads.
  - **Requirements**:
    - **Target Time**: **120 seconds**
    - **Reward**: **\$2,000**
  - **Note**: Added back in this release (previously removed).

- **King of the Hammer #2**:

  - **Description**: A timed rally event with a mix of dirt and paved roads.
  - **Requirements**:
    - **Target Time**: **180 seconds**
    - **Reward**: **\$3,000**

#### Drift Events

- **Hotrolled Drift**:

  - **Description**: Slide through a series of challenging corners designed for drifting enthusiasts.
  - **Requirements**:
    - **Target Time**: **30 seconds**
    - **Drift Score**: **3,500**
    - **Reward**: **\$1,500**

- **Sealbrik Drift**:

  - **Description**: A drift event set in an industrial area with tight spaces and sharp turns.
  - **Requirements**:
    - **Target Time**: **30 seconds**
    - **Drift Score**: **4,500**
    - **Reward**: **\$1,500**

- **Island Touge Drift**:

  - **Description**: Navigate a winding mountain pass inspired by classic touge races on the Island. Ideal for skilled drivers.
  - **Requirements**:
    - **Target Time**: **25 seconds**
    - **Drift Score**: **3,500**
    - **Reward**: **\$3,000**

#### Rock Crawl Events

Rock crawls have been added as part of West Coast adjustments and additions to the map.

- **Small Rock Crawl**:

  - **Description**: A timed rock crawl event with a mix of dirt and rocks.
  - **Requirements**:
    - **Target Time**: **5 seconds**
    - **Reward**: **\$1,200**

- **Large Rock Crawl**:

  - **Description**: A timed rock crawl event with a mix of dirt and rocks.
  - **Requirements**:
    - **Target Time**: **12 seconds**
    - **Reward**: **\$1,500**

**Hot-lapping Reward Changes**:

- Removed the 2× reward bonus for best lap time.
- Introduced a new function for lap multipliers:
  - **Best Time Session Bonus**: Once you achieve a best time on a hot lap, you get a 20% bonus for all subsequent laps.
  - **Best Time Range Bonus**: If you finish within \~2.5% of your best time, you get a 5% bonus for that lap.
- Some track checkpoints have been moved or resized.

### Vehicle Rental

- **Movie Rental**:
  - Lens Flare Studio will pay you for renting your vehicle to them.
  - **Requirements**:
    - **Vehicle**: Any vehicle valued over \$100,000
    - **Location**: Lens Flare Studio (Next to Residential Area)
    - **Time**: 1 - 8 hours
    - **Reward**: Variable based on the vehicle value and time rented.

---

### Freeroam Repo Missions

- **Purchase Vehicle**: Purchase a vehicle that is capable of towing. (Tilt Decks work great.)
- **Assign Towing Vehicle**: Set the license plate of the towing vehicle to "repo".
- **Start Event**: Enter the vehicle. You will have a repo mission after a few seconds.
- **Pick Up Vehicle**: Drive to the vehicle location and pick it up.
- **Complete Event**: Tow the vehicle to the dealership.
- **Reward**: Based on vehicle value, distance, and time.

---

### Police

- **Dynamic Police Interactions**:

  - **Roaming Police**: Police patrol the roads and attempt to pull you over for traffic violations.
  - **Play as Police**: Purchase a police vehicle and enforce the law.
  - **Earn Money**: Evade police or apprehend suspects if you’re an officer.

- **Troubleshooting**:

  - If police are not spawning, disable the "Start traffic in freeroam" setting.

- **Role Notification**:

  - A message indicates your role if playing as police.

---

### Economy

- **Increased Traffic Violation Costs**:
  - **Higher Ticket Prices**: Speeding and red-light camera fines have been increased.
  - **Adjusted Speed Trap Pricing**: Speed trap fines scale by speed over the limit.
  - **Integration with Insurance**: Traffic violations affect your insurance rates.

---

### Deliveries

**Expanded Cargo and Adjustments**:

- Adjusted level requirements for delivery tiers.
- Timed deliveries now allow 25% more time.
- Rebalanced parcel deliveries.
- Restructured loaner vehicle levels.
- Balanced EXP.
- In Hardcore mode, the loaner vehicle cut is changed to be more punitive.

---

### Insurance

- **Dynamic Insurance System**:
  - **Variable Rates**: Premiums adjust based on claims and driving behavior.
  - **Deductible Changes**: Deductibles are a percentage of your vehicle's value.
  - **Repair Times**: Range from 2 minutes to 30 minutes.
  - **Renewal Discounts**: Longer policy periods are cheaper overall.
  - **Roadside Assistance Plans**: Select how many tows (0, 2, 5, 10) you want per renewal. Towing to a garage or retrieving a favorite uses up a tow, while a basic upright or flip is free.
- **Repair Impacts**:
  - Repairs replace parts, increasing private repair costs.
  - Insurance repairs reduce vehicle value.
  - Repair times increased.

#### Insurance Policies

Customize your insurance coverage with specific perks:

- **Paint Repair**:
  - **Options**: Yes / No
  - **Premium Influence**: Selecting 'Yes' increases the premium by 150%.
- **Repair Time**:
  - **Options**:
    - 2 minutes (120 sec) - Premium +300%
    - 5 minutes (300 sec) - Premium +100%
    - 10 minutes (600 sec) - Premium +25%
    - 30 minutes (1800 sec) - Premium +10%
- **Deductible**:
  - **Options**:
    - 5% - Premium +300%
    - 10% - Premium +200%
    - 15% - Premium +125%
    - 25% - Premium +50%
- **Renewal Term**:
  - **Options**:
    - 25,000 km - Premium x1
    - 50,000 km - Premium x1.5
    - 100,000 km - Premium x2
    - 150,000 km - Premium x2.5
- **Roadside Assistance**:
  - **Options**:
    -  0 Free Tows - Premium +\$0
    -  2 Free Tows - Premium +\$150
    -  5 Free Tows - Premium +\$450
    -  10 Free Tows - Premium +\$1500

#### Policy Score

Your **Policy Score** affects your insurance rates:

- **Dynamic Calculation**:
  - Based on total payout vs. an interval determined by your repair time.
- **Influencing Factors**:
  - **Lower Deductibles**: Higher claims, raising your score.
  - **Faster Repair Times**: Increases costs, raising your score.
- **Score Deduction**:
  - Reduced by 10% each renewal without accidents.
- **Minimum Score**: 0.5

---

### Garage Space

- **Discover and Purchase Garages**:

  - **Discover**: Drive to the garage and walk up to the computer.
  - **Purchase**: Tow to the garage to buy it.
  - Garages show up in taxi/towing menus once discovered.

- **Garage Pricing and Capacity**:

  - **Belasco Auto Garage**: (\$550,000, 8 Slots)
  - **Commercial Garage**: (\$1,000,000, 15 Slots)
  - **Drag Paddock**: (\$115,000, 2 Slots)
  - **Chinatown Garage**: (FREE, 2 Slots)
  - **Chinatown Overflow**: (\$75,000, 2 Slots)
  - **Cul-de-Sac Garage**: (\$425,000, 5 Slots)
  - **Sealbrick 1058 Garage**: (\$180,000, 3 Slots)
  - **Race Paddock Garage**: (\$155,000, 1 Slot)

---

### Dealerships

Experience a diverse range of dealerships, each with unique specialties and inventory.

#### Belasco Auto

- **Description**: New & quality used vehicle sales
- **Stock**: 20 vehicles
- **Specialization**: Cars (no trailers/ATVs/buggies)
- **Vehicle Requirements**:
  - Factory configurations only
  - Years 2002-2025
  - Various mileage tiers
  - Max value \$65,000
- **Dealer Fees**: \$749

#### Jefferson Motors

- **Description**: Custom American cars
- **Stock**: 16 vehicles
- **Specialization**: Custom configurations
- **Brands**: Bruckell, Burnside, Gavril, Soliad, and others
- **Vehicle Types**: High mileage (5.5-164 miles / 8.8-264 km)
- **Dealer Fees**: \$649

#### Rich's Motor Company

- **Description**: Prestige auto sales
- **Stock**: 15 vehicles
- **Specialization**: High-end vehicles (\$120,000+)
- **Vehicle Types**:
  - Years from 1950-present
  - Pristine/low mileage cars (1.5-82 miles / 2.5-132 km)
- **Dealer Fees**: \$1,250

#### Quarryside Auto Sales

- **Description**: Used trucks and vans
- **Stock**: 20 vehicles
- **Specialization**: Pickups and vans
- **Vehicle Types**:
  - Factory configurations
  - High mileage vehicles
- **Dealer Fees**: \$249

#### Smash Rollers

- **Description**: The perfect start to your build
- **Stock**: 7 vehicles
- **Specialization**: Frame configurations
- **Vehicle Types**: Very low mileage (10-100,000 miles)
- **Dealer Fees**: None

#### Online Brand Dealerships

Brand-specific new vehicle dealers:

- **Bruckell Online Dealership**:

  - Stock: 10 vehicles
  - New vehicles only
  - Factory configurations
  - Dealer Fees: \$2,500

- **Gavril-Car Online Dealership**:

  - Stock: 10 vehicles
  - New vehicles only (cars only)
  - Factory configurations
  - Dealer Fees: \$2,500

- **Gavril-Truck Online Dealership**:

  - Stock: 10 vehicles
  - New vehicles only (trucks and pickups)
  - Factory configurations
  - Dealer Fees: \$2,500

- **Soliad Online Dealership**:

  - Stock: 10 vehicles
  - New vehicles only
  - Factory configurations
  - Dealer Fees: \$2,500

All online dealerships feature:

- Mileage range: 3-10 miles / 4.8-16 km
- Brand-specific inventory
- Factory configurations only

#### Commercial Vehicle Sales

- **Description**: Tractors and Trailers dealership
- **Stock**: 20 vehicles
- **Specialization**:
  - Semi trucks
  - Tanker trucks
  - Flatbed trucks
  - Buses
  - Commercial vehicles
- **Vehicle Types**: High mileage (1,093-602,700 miles / 1,760-970,000 km)
- **Dealer Fees**: \$1,449

#### Trailer Dealer

- **Description**: Trailer Sales
- **Stock**: 10 vehicles
- **Specialization**: All types of trailers
- **Vehicle Types**: Mixed mileage
- **Dealer Fees**: \$449

#### Service Dealership

- **Description**: Purchase Service Vehicles here
- **Stock**: 7 vehicles
- **Specialization**: Service vehicles (non-commercial)
- **Dealer Fees**: \$500

#### Private Sellers

- **Stock**: 30 vehicles
- **Requirements**:
  - Mileage: 15,534-236,121 miles / 25,000-380,000 km
  - Minimum value: \$950
  - No trailers or semi trucks
- **Features**: No dealer fees

#### Gizamn's Rod Shop

- **Stock**: 5 vehicles
- **Specialization**: Gizamn custom configurations
- **Vehicle Types**: Low-medium mileage (6.8-10.9 miles / 11-17.6 km)
- **Dealer Fees**: \$750

#### Trusted Auto Sales

- **Description**: Discounted cars
- **Stock**: 25 vehicles
- **Vehicle Types**: Very high mileage (189,520-382,765 miles / 305,000-616,000 km)
- **Restrictions**: No ATVs, Buggies, Semi Trucks
- **Dealer Fees**: None

#### Joe's Junk

- **Requires Joe's Junk Mod Off Repo**
- **Description**: "You think you hate it now, wait till you drive it"
- **Stock**: 7 vehicles
- **Specialization**: Junk configurations
- **Vehicle Types**: Very high mileage (158,450-569,174 miles / 255,000-916,000 km)
- **Dealer Fees**: None

#### Fast Automotive

- **Description**: Fastest race cars available
- **Stock**: 20 vehicles
- **Specialization**: Race configurations, ATVs, Buggies, and specialty vehicles
- **Vehicle Types**: Low-medium mileage (6.8-10.9 miles / 11-17.6 km)
- **Dealer Fees**: \$2,000

#### Police Dealership

- **Description**: Purchase police vehicles here
- **Stock**: 8 vehicles
- **Specialization**: Police vehicles
- **Dealer Fees**: \$500

---

### Car Meets

Experience scheduled car meets across multiple locations, with RSVP and dynamic activities:

#### Meet Locations

- Diner
- Pier
- Gas Station
- Lighthouse
- Parking Garage
- Mountain Top

#### Meet Types

- **Showcase**: Park, show off, earn reputation that boosts vehicle value.
- **Street Cruise**: Short showcase then a group cruise along a routed path; traffic is reduced during the cruise, and AI vehicles follow the route.

#### Features

- **Scheduling & RSVP**: Receive meet offers at set times; RSVP and set attendance via the Car Meets app. Route guidance leads you to your spot.
- **Attendance Levels**: Low, Medium, High control how many vehicles spawn.
- **Reputation Rewards**: Dynamic reputation percentage (hardcore reduces it) increases vehicle value; saved per vehicle.
- **Performance Optimizations**: Vehicles spawn on-demand and toggle visibility based on line-of-sight.
- **Lifecycle & Cleanup**: Meets end with vehicles dispersing; distant vehicles are cleaned up automatically.

### Time Management

A new sleep function is available at computers:

#### Preset Times

- Sunrise
- Noon
- Sunset
- Midnight

#### Time Control

- Fine adjustments: ±10 minutes
- Coarse adjustments: ±1 hour
- Direct time control via slider
- Toggle Day/Night cycle
- Persistent time and cycle settings

---

### Police Certification

A new certification system for non-police vehicles:

#### Process

1. Drive to the police station
2. Park in designated spot #1
3. Access certification UI
4. Pay certification fee

#### Details

- **Cost**: \$10,000
- **Processing Time**: 4 hours
- **Location**: Police Station parking

---

### Vehicle Value System

Rewritten vehicle valuation system:

- **Modifications**: Greater impact on vehicle value
- **Parts Value**: Increased influence of total part value
- **Anti-Exploit**: Removed profitability from part stripping (Chop Shop)

---

### Phone UI

A brand-new **Phone UI** has been added:

- Cannot be opened while driving; auto-closes at higher speeds.
- **Current Apps**:
  - **Taxi App** for quick taxi jobs
  - **Car Meets App** to view meet schedules and manage RSVPs
  - **Marketplace App** for listing or checking offers on vehicles

---

### Taxi Work

Offers a new way to earn money with a deeper, modular taxi system:

- Pick up and drop off passengers using on-screen markers.
- Set yourself Available to receive periodic job offers (every 5–45s) via the Phone; Accept/Reject from the Phone.
- Passenger Types: dynamic pool with unique preferences and payouts. Types are modular and auto-loaded from `lua/ge/extensions/gameplay/taxiPassengers`.
- Capacity-aware: seat count is detected from your current vehicle configuration (supports buses and multi-seat setups).
- Fares use actual driving distance and scale with:
  - Vehicle value multiplier
  - Passenger count
  - Passenger-type fare tier/multiplier
  - Consecutive fare streak
  - Hardcore Mode (reduced rewards)
- Tips: type-specific tip breakdown (baseline speed bonus); shown after each fare.
- Driver Rating (1–5★): persists per save, influenced by smoothness and pace; affects which passenger types you can get.
- Phone prompts appear for new offers and upon completion to review earnings.
- Rewards grant money and BeamXP; dropped-off passenger counts are tracked.

---

### Marketplace

List and sell your vehicles in-game:

- Receive offers from 300+ different customers.
- Offers arrive every 2–10 minutes based on overall customer interest.
- Offline generation is slower (\~5× the normal time).
- **Pricing** influenced by:
  - Free-roam event performance
  - Consecutive laps
  - Power/Torque/Weight
  - Vehicle modifications
  - Community rep
  - Mileage/Age
  - Value
  - Accidents, arrests, tickets, evades
  - Suspects caught
  - Deliveries
  - Movie rentals
  - Taxi passengers dropped off
- **Notifications** can be enabled to alert you of new offers.
- Manage listings via a **Computer/Phone App**.

---

### Hardcore Mode

A new challenging gameplay setting:

- Start with **\$0** and one of 6 random hardcore starter vehicles.
- No initial garage; capacities halved (rounded up).
- All rewards are halved.
- Instant sell / trade-in yields \~50–66% of base value.
- Marketplace offers \~33% lower.
- Police fines tripled.
- No Police mod is disabled.
- No voucher rewards.
- A "Hardcore" banner is shown in menus.

---

### General Adjustments

- **Fuel Price** multiplied by 10×.

---

## Conclusion

The **RLS Career Overhaul** mod provides a comprehensive enhancement to BeamNG.drive's career mode, offering a richer and more engaging experience. Whether you're racing, evading police, managing finances, or expanding your vehicle collection, this mod adds depth and excitement to every aspect of the game.

Enjoy the new features and improvements, and happy driving!

---

## Notes

- **Manual Mod Installation Guides**:
  - Refer to the [BeamNG Documentation](https://documentation.beamng.com/tutorials/mods/installing-mods/) and the [Steam Community Guide](https://steamcommunity.com/sharedfiles/filedetails/?id=2918556246) for detailed instructions on installing mods.
- **Feedback and Support**:
  - If you encounter any issues or have suggestions, feel free to contribute to the mod's GitHub repository or reach out to the community.

---

**Disclaimer**: This mod is not affiliated with or endorsed by BeamNG GmbH. Use at your own risk.
