-- written by DaddelZeit
-- DO NOT USE WITHOUT PERMISSION

local M = {}

local pressureSmoother = newTemporalSmoothing(0.75,0.75)
local engine = nil
local oilPressure = 0
local oilPressureRaw = 0

-- change these if needed
local viscosity = 15000
local enableOilWarn = false

local function onInit()
	for _, e in pairs(powertrain.getDevicesByType("combustionEngine")) do
		engine = e
		if e.name == "mainEngine" then -- use mainEngine if given
			engine = e
		end
	end
end

local function updateGFX(dt)
    local temp = 200 - electrics.values.oiltemp
	oilPressureRaw = ((temp * (electrics.values.rpm / viscosity) / 120) + 1.1) * engine.oilVolume

    oilPressure = (oilPressureRaw * (clamp(electrics.values.rpm, 0, engine.idleAV / 0.104719755) / (engine.idleAV / 0.104719755)))

	electrics.values.oilpressure = pressureSmoother:get(oilPressure, dt) -- smooth end result and conv to psi

	if not enableOilWarn then return end
	if electrics.values.oilpressure < 1.5 and engine.ignitionCoef ~= 0 then
		electrics.values.oilwarn = 1
	else
		electrics.values.oilwarn = 0
	end
end

-- public interface
M.onInit = onInit
M.updateGFX = updateGFX

return M