// written by DaddelZeit
// DO NOT USE WITHOUT PERMISSION

//console.log("load gaugesScreen");
angular.module('gaugesScreen', [])

  .controller('GaugesScreenController', function ($scope, $element, $window) {
    "use strict";
    var vm = this;

    var svg;
    var navContainer = $element[0].children[0].children[0];
    var navDimensions = [];

    var displays = {};
    var rpmDisplay = {};
    var speedoDisplay = { gears:{} };
    var electrics = {lights:{} };
    var gauges = {fuel:{},temp:{}};

    var prevspeedAng = 0;
    var rpmRatio = 1;
    var speedRatio = 1;

    var speedoInitialised = true;
    var currentGear = 0;

    var ready = false;

    var units = {uiUnitConsumptionRate: "metric",
    uiUnitDate: "ger",
    uiUnitEnergy: "metric",
    uiUnitLength: "metric",
    uiUnitPower: "hp",
    uiUnitPressure: "bar",
    uiUnitTemperature: "c",
    uiUnitTorque: "metric",
    uiUnitVolume: "l",
    uiUnitWeight: "kg"};
    var unitspeedConv = 3.6;

    // Make sure SVG is loaded
    $scope.onSVGLoaded = function () {
      svg = $element[0].children[1].children[0];

      //text.root = hu('#text', svg)

      rpmDisplay.needle = hu('#rpm_needle', gauges.root);
      rpmDisplay.needle.css({transformOrigin: "53.7px 55.7px"})
      rpmDisplay.rpm_circle = hu('#rpm_circle', gauges.root);
      rpmDisplay.rpm_circle_background = hu('#rpm_circle_background', gauges.root);
      rpmDisplay.rpm_circle_redline = hu('#rpm_circle_redline', gauges.root);
      rpmDisplay.ticks = hu('#rpm_ticks', gauges.root);
      rpmDisplay.max_text = hu('#rpm_max', gauges.root);

      rpmDisplay.major_text = hu('#rpm_major', gauges.root);
      rpmDisplay.minor_text = hu('#rpm_minor', gauges.root);

      speedoDisplay.needle = hu('#speed_needle', gauges.root);
      speedoDisplay.needle.css({transformOrigin: "217.7px 55px"})
      speedoDisplay.rpm_circle = hu('#speed_circle', gauges.root);
      speedoDisplay.rpm_circle_background = hu('#speed_circle_background', gauges.root);
      speedoDisplay.rpm_circle_redline = hu('#speed_circle_redline', gauges.root);
      speedoDisplay.ticks = hu('#speed_ticks', gauges.root);
      speedoDisplay.unit = hu('#speed_unit', gauges.root);
      speedoDisplay.text = hu('#speed', gauges.root);
      speedoDisplay.max_text = hu('#speed_max', gauges.root);

      // gear display
      speedoDisplay.gears_root = hu('#layer1', svg);
      speedoDisplay.gears.P = hu('#p', speedoDisplay.gears_root);
      speedoDisplay.gears.R = hu('#r', speedoDisplay.gears_root);
      speedoDisplay.gears.N = hu('#n', speedoDisplay.gears_root);
      speedoDisplay.gears.D = hu('#d', speedoDisplay.gears_root);
      speedoDisplay.gears.M = hu('#m', speedoDisplay.gears_root);

      electrics.odometer = hu('#odometer', gauges.root)
      electrics.odometer_unit = hu('#odometer_unit', gauges.root)
      electrics.range_text = hu('#range_text', gauges.root)
      electrics.range_text_unit = hu('#range_text_unit', gauges.root)

      // watertemp
      displays.watertemp = {}
      displays.watertemp.data = [
        100.58542, 19.438896,
        7.5, 8.6,
        60, 133,
        0.055
      ],
      displays.watertemp.root = hu('#watertemp', gauges.root),
      displays.watertemp.objs = {
        needle: hu('#watertemp_needle', displays.watertemp.root),
        circle: hu('#watertemp_circle', displays.watertemp.root),
      }

      displays.oilpressure = {}
      displays.oilpressure.data = [
        100.58542, 19.438896,
        7.5, 8.6,
        0, 50,
        0.073
      ],
      displays.oilpressure.root = hu('#oilpressure', gauges.root),
      displays.oilpressure.objs = {
        needle: hu('#oilpressure_needle', displays.oilpressure.root),
        circle: hu('#oilpressure_circle', displays.oilpressure.root),
      }

      displays.fuel = {}
      displays.fuel.data = [
        100.58542, 19.438896,
        7.5, 8.6,
        0, 1,
        3.65
      ],
      displays.fuel.root = hu('#fuel', gauges.root),
      displays.fuel.objs = {
        needle: hu('#fuel_needle', displays.fuel.root),
        circle: hu('#fuel_circle', displays.fuel.root),
      }

      ready = true;
    }

    function limitVal(min, val,max){
      return Math.min(Math.max(min,val), max);
    }

    function updateGearIndicator(data) {
      if (currentGear !== data.electrics.gear) {
        currentGear = data.electrics.gear;
        var xct = -1;
        if (isNaN(data.electrics.gear)) { // auto gears only
          speedoDisplay.gears["P"].n.style.display = "inline"; //because why not at this point
          let isM = false;
          if (data.electrics.gear.length > 1) {
            isM = (data.electrics.gear[0]=="M")
          }
          for (var key in speedoDisplay.gears) {
            if (key === data.electrics.gear || (isM && key[0] === "M")) {
              xct += 2;
              speedoDisplay.gears[key].css({ fill: '#bc4316ff', "font-size": "11.9944px", "transform": "translate("+xct+"px, 1.2px)" });
              xct += 2;
            }
            else {
              speedoDisplay.gears[key].css({ fill: '#ffffffff', "font-size": "7.76111px", "transform": "translate("+xct+"px, 0px)"});
            }
          }
          if(isM == true) {
            speedoDisplay.gears["M"].text(currentGear);
          }
          else{
            speedoDisplay.gears["M"].text("M");
          }
        } else {

        }
      }
    }

    function updateOtherDisplays(data) {
      for (var key in displays) {
        let electrics = data.electrics[key]
        let displayData = displays[key].data
        let displayObjs = displays[key].objs

        electrics = limitVal(displayData[4], electrics, displayData[5])-displayData[4]

        //electrics = 50
        var ang = 196 + (electrics*displayData[6]);
        var startAngle= -196*Math.PI/180
        var rad = (electrics*displayData[6])+startAngle;
        var maxRad = (209*Math.PI/180) + startAngle;
        rad = Math.min(rad, maxRad);

        var centerX=displayData[0], centerY=displayData[1], radiusInt=displayData[2], radiusExt=displayData[3], largeArcFlag= ((rad-startAngle)>Math.PI)? 1 : 0;
        var sx2 = (centerX) + Math.cos(startAngle) * radiusInt;
        var sy2 = (centerY) + Math.sin(startAngle) * radiusInt;

        var sx1 = (centerX) + Math.cos(startAngle) * radiusExt;
        var sy1 = (centerY) + Math.sin(startAngle) * radiusExt;

        var ex2 = (centerX) + Math.cos(rad) * radiusExt;
        var ey2 = (centerY) + Math.sin(rad) * radiusExt;

        var ex1 = (centerX) + Math.cos(rad) * radiusInt;
        var ey1 = (centerY) + Math.sin(rad) * radiusInt;

        displayObjs.circle.attr({d: "M " + sx1 + "," + sy1 +
          " A" + radiusExt  + "," + radiusExt  + " 0 "+largeArcFlag+",1 " + ex2 + "," + ey2 +
          " L " + ex1 + "," + ey1 +
          " A" + radiusInt + "," + radiusInt + " 0 "+largeArcFlag+",0 " + sx2 + "," + sy2});

        displayObjs.needle.css({transform: `rotate(${(ang)}deg)` });
      }
    }

    function initTachoDisplays(redRPM, gaugesMax, maxRPM) {
      if (speedoInitialised) {
        var ratio = (gaugesMax*0.00068)/(maxRPM*0.00068);
        rpmRatio = ratio;
        var startAngle= -226*Math.PI/180, speedRad = (((maxRPM-(maxRPM-redRPM))*0.00068)*ratio)+startAngle;
        var maxRad = (275*Math.PI/180) + startAngle;
        speedRad = Math.min(speedRad, maxRad);

        var centerX=52.7, centerY=55, radiusInt=41, radiusExt=43, largeArcFlag= ((speedRad-startAngle)>Math.PI)? 1 : 0;
        var sx2 = (centerX) + Math.cos(startAngle) * radiusInt;
        var sy2 = (centerY) + Math.sin(startAngle) * radiusInt;

        var sx1 = (centerX) + Math.cos(startAngle) * radiusExt;
        var sy1 = (centerY) + Math.sin(startAngle) * radiusExt;

        var ex2 = (centerX) + Math.cos(speedRad) * radiusExt;
        var ey2 = (centerY) + Math.sin(speedRad) * radiusExt;

        var ex1 = (centerX) + Math.cos(speedRad) * radiusInt;
        var ey1 = (centerY) + Math.sin(speedRad) * radiusInt;

        rpmDisplay.rpm_circle_background.attr({d: "M " + sx1 + "," + sy1 +
          " A" + radiusExt  + "," + radiusExt  + " 0 "+largeArcFlag+",1 " + ex2 + "," + ey2 +
          " L " + ex1 + "," + ey1 +
          " A" + radiusInt + "," + radiusInt + " 0 "+largeArcFlag+",0 " + sx2 + "," + sy2});

        // redline
        var speedRad2 = (((maxRPM)*0.00068)*ratio)+startAngle
        radiusInt=41.1
        radiusExt=42.9

        var sx2 = (centerX) + Math.cos(startAngle) * radiusInt;
        var sy2 = (centerY) + Math.sin(startAngle) * radiusInt;

        var sx1 = (centerX) + Math.cos(startAngle) * radiusExt;
        var sy1 = (centerY) + Math.sin(startAngle) * radiusExt;

        var ex2 = (centerX) + Math.cos(speedRad2) * radiusExt;
        var ey2 = (centerY) + Math.sin(speedRad2) * radiusExt;

        var ex1 = (centerX) + Math.cos(speedRad2) * radiusInt;
        var ey1 = (centerY) + Math.sin(speedRad2) * radiusInt;

        rpmDisplay.rpm_circle_redline.attr({d: "M " + sx1 + "," + sy1 +
          " A" + radiusExt  + "," + radiusExt  + " 0 "+largeArcFlag+",1 " + ex2 + "," + ey2 +
          " L " + ex1 + "," + ey1 +
          " A" + radiusInt + "," + radiusInt + " 0 "+largeArcFlag+",0 " + sx2 + "," + sy2});

        rpmDisplay.max_text.text((maxRPM/1000).toFixed(0))
      }
    }

    function redrawTachoTicks(lim,bigSep,smallSep) {
      var startAngle= 45*Math.PI/180;
      var maxAngle = -270;
      var centerX=52.7, centerY=55, radiusInt=42, radiusExt=43, radiusIntBig=43;

      var tickD = "";
      for(var ib = 0; ib<= (lim/bigSep) ; ib++){
        for(var is = 0; is<= (bigSep/smallSep); is++){
          var curAng = (ib*maxAngle/(lim/bigSep)+maxAngle*(1/(lim/bigSep))*(is/(bigSep/smallSep))) *Math.PI/180;
          if(curAng < (maxAngle*Math.PI/180)){break;}
          //console.log( (ib*270/(lim/bigSep)+270*(1/(lim/bigSep))*(is/(bigSep/smallSep))) , curAng);
          //console.log( "b=", ib*270/(lim/bigSep) , "s=", 270*(1/(lim/bigSep))*(is/(bigSep/smallSep)))
          var sx2 = (centerX) + Math.cos(startAngle+curAng) * (is===0?radiusIntBig:radiusInt);
          var sy2 = (centerY) + Math.sin(startAngle+curAng) * (is===0?radiusIntBig:radiusInt);

          var sx1 = (centerX) + Math.cos(startAngle+curAng) * radiusExt;
          var sy1 = (centerY) + Math.sin(startAngle+curAng) * radiusExt;
          tickD += "M "+(sx1)+","+(sy1)+" "+(sx2)+","+(sy2)+" ";
        }
      }
      rpmDisplay.ticks.attr({d: tickD});
    }

    function initSpeedoDisplays(gaugesMax, maxSpeed) {
      if (speedoInitialised) {
        var ratio = (gaugesMax*0.00068)/(maxSpeed*0.00068);
        speedRatio = ratio;
        var startAngle= -226*Math.PI/180, speedRad = ((maxSpeed*0.00068)*ratio)+startAngle;
        var maxRad = (275*Math.PI/180) + startAngle;
        speedRad = Math.min(speedRad, maxRad);

        var centerX=217.7, centerY=55, radiusInt=41, radiusExt=43, largeArcFlag= ((speedRad-startAngle)>Math.PI)? 1 : 0;
        var sx2 = (centerX) + Math.cos(startAngle) * radiusInt;
        var sy2 = (centerY) + Math.sin(startAngle) * radiusInt;

        var sx1 = (centerX) + Math.cos(startAngle) * radiusExt;
        var sy1 = (centerY) + Math.sin(startAngle) * radiusExt;

        var ex2 = (centerX) + Math.cos(speedRad) * radiusExt;
        var ey2 = (centerY) + Math.sin(speedRad) * radiusExt;

        var ex1 = (centerX) + Math.cos(speedRad) * radiusInt;
        var ey1 = (centerY) + Math.sin(speedRad) * radiusInt;

        speedoDisplay.rpm_circle_background.attr({d: "M " + sx1 + "," + sy1 +
          " A" + radiusExt  + "," + radiusExt  + " 0 "+largeArcFlag+",1 " + ex2 + "," + ey2 +
          " L " + ex1 + "," + ey1 +
          " A" + radiusInt + "," + radiusInt + " 0 "+largeArcFlag+",0 " + sx2 + "," + sy2});

        speedoDisplay.max_text.text(maxSpeed)
      }
    }

    function redrawSpeedoTicks(lim,bigSep,smallSep) {
      var startAngle= 45*Math.PI/180;
      var maxAngle = -270;
      var centerX=217.7, centerY=55, radiusInt=42, radiusExt=43, radiusIntBig=43;

      var tickD = "";
      for(var ib = 0; ib<= (lim/bigSep) ; ib++){
        for(var is = 0; is<= (bigSep/smallSep); is++){
          var curAng = (ib*maxAngle/(lim/bigSep)+maxAngle*(1/(lim/bigSep))*(is/(bigSep/smallSep))) *Math.PI/180;
          if(curAng < (maxAngle*Math.PI/180)){break;}
          //console.log( (ib*270/(lim/bigSep)+270*(1/(lim/bigSep))*(is/(bigSep/smallSep))) , curAng);
          //console.log( "b=", ib*270/(lim/bigSep) , "s=", 270*(1/(lim/bigSep))*(is/(bigSep/smallSep)))
          var sx2 = (centerX) + Math.cos(startAngle+curAng) * (is===0?radiusIntBig:radiusInt);
          var sy2 = (centerY) + Math.sin(startAngle+curAng) * (is===0?radiusIntBig:radiusInt);

          var sx1 = (centerX) + Math.cos(startAngle+curAng) * radiusExt;
          var sy1 = (centerY) + Math.sin(startAngle+curAng) * radiusExt;
          tickD += "M "+(sx1)+","+(sy1)+" "+(sx2)+","+(sy2)+" ";
        }
      }
      speedoDisplay.ticks.attr({d: tickD});
    }

    function initDisplays() {

    }

    // overwriting plain javascript function so we can access from within the controller
    $window.setup = (data) => {
      if(!ready){
        console.log("calling setup while svg not fully loaded");
        setTimeout(function(){ $window.setup(data) }, 100);
        return;
      }
      //console.log("setup",data);

      if (data.uiUnitLength == "metric") {
        speedoDisplay.unit.text("km/h");
        electrics.odometer_unit.text("km");
        electrics.range_text_unit.text("km to E")
        unitspeedConv = 3.6;
        initSpeedoDisplays(7000, data.maxKPH)
        redrawSpeedoTicks(data.maxKPH,data.speedoMetricSepBig,data.speedoMetricSepSmall);
      } else {
        speedoDisplay.unit.text("mph");
        electrics.odometer_unit.text("mi");
        electrics.range_text_unit.text("mi to E")
        unitspeedConv = 2.23694;
        initSpeedoDisplays(7000, data.maxMPH)
        redrawSpeedoTicks(data.maxMPH,data.speedoImperialSepBig,data.speedoImperialSepSmall);
      }

      initTachoDisplays(data.redRPM, 7000, data.maxRPM)
      redrawTachoTicks(data.maxRPM,data.maxRPM,1000,data.redRPM)
      initDisplays()

      units.uiUnitTemperature = data.uiUnitTemperature || ""
    }

    $window.updateElectrics = (data) => {
      let conversion = unitspeedConv === 3.6?1:0.6213712
      electrics.odometer.text(((data.electrics.odometer/1000)*conversion).toFixed(1))
      electrics.range_text.text(((data.customModules.combustionEngineData.remainingRange)*conversion).toFixed(0))
    }

    function updateTachoDisplays(data) {
      if (speedoInitialised) {
        var speedAng = 226 + (data.electrics.rpm*0.00068*rpmRatio);
        var startAngle=-227*Math.PI/180, speedRad = (data.electrics.rpm*0.00068*rpmRatio)+startAngle;
        var maxRad = (275*Math.PI/180) + startAngle;
        speedRad = Math.min(speedRad, maxRad);
        //console.log("maxRad",maxRad,"rad",speedRad,"rad-start",speedRad-startAngle, "deg",(speedRad-startAngle)*180/Math.PI);
        if(Math.abs(speedRad-prevspeedAng)<0.3){return;}
        //rpmDisplay.speedValue.text((data.electrics.rpm * (unit=="metric"?3.6:2.23694) ).toFixed(0));
        rpmDisplay.needle.css({transform: `rotate(${(speedAng*56.745)}deg)` });

        var centerX=52.7, centerY=55, radiusInt=41, radiusExt=43, largeArcFlag= ((speedRad-startAngle)>Math.PI)? 1 : 0;
        //console.log("startAngle",startAngle,"speedRad",speedRad,"largeArcFlag",largeArcFlag);
        var sx2 = (centerX) + Math.cos(startAngle) * radiusInt;
        var sy2 = (centerY) + Math.sin(startAngle) * radiusInt;

        var sx1 = (centerX) + Math.cos(startAngle) * radiusExt;
        var sy1 = (centerY) + Math.sin(startAngle) * radiusExt;

        var ex2 = (centerX) + Math.cos(speedRad) * radiusExt;
        var ey2 = (centerY) + Math.sin(speedRad) * radiusExt;

        var ex1 = (centerX) + Math.cos(speedRad) * radiusInt;
        var ey1 = (centerY) + Math.sin(speedRad) * radiusInt;

        var mx1 = (centerX) + Math.cos(speedRad) * 8;
        var my1 = (centerY) + Math.sin(speedRad) * 8;

        rpmDisplay.rpm_circle.attr({d: "M " + sx1 + "," + sy1 +
          " A" + radiusExt  + "," + radiusExt  + " 0 "+largeArcFlag+",1 " + ex2 + "," + ey2 +
          " L " + ex1 + "," + ey1 +
          " A" + radiusInt + "," + radiusInt + " 0 "+largeArcFlag+",0 " + sx2 + "," + sy2});

        prevspeedAng = speedAng;

        var rpmMajor = Math.floor(data.electrics.rpm/1000);
        var rpmMinor = Math.floor((data.electrics.rpm-(rpmMajor*1000))/100);
        rpmDisplay.major_text.text(rpmMajor);
        rpmDisplay.minor_text.text(rpmMinor);
      }
    }

    function updateSpeedoDisplays(data) {
      if (speedoInitialised) {
        var speedAng = 226 + (data.electrics.wheelspeed*0.0025*speedRatio);
        var startAngle=-227*Math.PI/180, speedRad = (data.electrics.wheelspeed*0.0025*speedRatio)+startAngle;
        var maxRad = (275*Math.PI/180) + startAngle;
        speedRad = Math.min(speedRad, maxRad);
        //console.log("maxRad",maxRad,"rad",speedRad,"rad-start",speedRad-startAngle, "deg",(speedRad-startAngle)*180/Math.PI);
        if(Math.abs(speedRad-prevspeedAng)<0.3){return;}
        speedoDisplay.needle.css({transform: `rotate(${Math.min(speedAng*56.745,13095)}deg)` });

        var centerX=217.7, centerY=55, radiusInt=41, radiusExt=43, largeArcFlag= ((speedRad-startAngle)>Math.PI)? 1 : 0;
        //console.log("startAngle",startAngle,"speedRad",speedRad,"largeArcFlag",largeArcFlag);
        var sx2 = (centerX) + Math.cos(startAngle) * radiusInt;
        var sy2 = (centerY) + Math.sin(startAngle) * radiusInt;

        var sx1 = (centerX) + Math.cos(startAngle) * radiusExt;
        var sy1 = (centerY) + Math.sin(startAngle) * radiusExt;

        var ex2 = (centerX) + Math.cos(speedRad) * radiusExt;
        var ey2 = (centerY) + Math.sin(speedRad) * radiusExt;

        var ex1 = (centerX) + Math.cos(speedRad) * radiusInt;
        var ey1 = (centerY) + Math.sin(speedRad) * radiusInt;

        var mx1 = (centerX) + Math.cos(speedRad) * 8;
        var my1 = (centerY) + Math.sin(speedRad) * 8;

        speedoDisplay.rpm_circle.attr({d: "M " + sx1 + "," + sy1 +
          " A" + radiusExt  + "," + radiusExt  + " 0 "+largeArcFlag+",1 " + ex2 + "," + ey2 +
          " L " + ex1 + "," + ey1 +
          " A" + radiusInt + "," + radiusInt + " 0 "+largeArcFlag+",0 " + sx2 + "," + sy2});

        prevspeedAng = speedAng;

        speedoDisplay.text.text((data.electrics.wheelspeed*unitspeedConv).toFixed(0))
      }
    }

    $window.updateData = (data) => {
      if (data) {
        if(!ready){console.log("not ready");return;}
        // console.log(data);

        // Update PRNDS display
        updateGearIndicator(data);
        updateTachoDisplays(data);
        updateSpeedoDisplays(data);

        updateElectrics(data);
        updateOtherDisplays(data);
        //updateGaugeFuel(data);
        //updateGaugeTemp(data);
      }
    }
    //ready = true;
    //$window.updateConsum({current:0, average:0, range:0});
  });