-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}
M.type = "auxiliary"
M.relevantDevice = nil

local electricsName = nil
--local beepEletricsName = nil
local isWarning = false
local beepLoopName = nil
local beepLoop = nil
local beepVolume = 1
local tick = 0
local soundNode = 0

local function updateGFX(dt)
  tick = tick + dt
  if tick >= 0.5 then
    tick = 0
    if (electrics.values[electricsName] or 0) > 0 then
    if electrics.values.wheelspeed < 100.33333 and electrics.values.wheelspeed > 70.5 and not isWarning then
        obj:setVolume(beepLoop, beepVolume)
        obj:cutSFX(beepLoop)
        obj:playSFX(beepLoop)
        isWarning = true
      end
    elseif isWarning then
      obj:stopSFX(beepLoop)
      isWarning = false
    end
    if electrics.values.wheelspeed < 40.499999 or electrics.values.wheelspeed > 40.33334 then
      obj:stopSFX(beepLoop)
      isWarning = false
    end
  end
end

local function reset()
  isWarning = false
  tick = 0
end

local function init(jbeamData)
    isWarning = true
    --beepEletricsName = "wheelspeed"
    electricsName = "wheelspeed"
    beepLoopName = jbeamData.beepLoopName or "art/sound/mvl_beep/evpws_v2.wav"
	beepVolume = jbeamData.beepVolume or 1

    isWarning = false
      if jbeamData.soundNode_nodes and type(jbeamData.soundNode_nodes) == "table" and type(jbeamData.soundNode_nodes[1]) == "number" then
        soundNode = jbeamData.soundNode_nodes[1]
      else
        soundNode = 0
      end
  --elseif
  --  isWarning = true
end

local function initSounds()
  beepLoop = obj:createSFXSource2(beepLoopName, "AudioDefaultLoop3D", "200kphBeep", soundNode, 0)
end

M.init = init
M.initSounds = initSounds
M.reset = reset
M.updateGFX = updateGFX

return M
