angular.module('gaugesScreen', [])
.controller('GaugesScreenController', function($scope, $window) {
  var units = {
    uiUnitConsumptionRate: "metric",
    uiUnitDate: "ger",
    uiUnitEnergy: "metric",
    uiUnitLength: "metric",
    uiUnitPower: "hp",
    uiUnitPressure: "bar",
    uiUnitTemperature: "c",
    uiUnitTorque: "metric",
    uiUnitVolume: "l",
    uiUnitWeight: "kg"
  };

  $scope.data = {
    radio_left_text: '',
    radio_center_text: '',
    radio_right_text: ''
  };

	let previousSongIndex = 0;
	let previousVolume = 0;
	let showingVolumeMessage = false;
	let volumeMessageTimeout = null;

  $window.setup = (setupData) => {
    for (let dk in setupData) {
      if (typeof dk === "string" && dk.startsWith("uiUnit")) {
        units[dk] = setupData[dk];
      }
    }
    vueEventBus.emit('SettingsChanged', { values: units });
  };

$window.updateData = (data) => {
  $scope.$evalAsync(() => {
    const songNames = data.customModules.qashqai16_songs.names || [];
    const currentIndex = data.electrics.current_music_index || 1;
    const currentSong = songNames[currentIndex - 1] || "Unknown";

    $scope.data.radio_left_text = "USB";
	const now = new Date();
	const timeString = now.toLocaleTimeString([], { hour: '2-digit', minute: '2-digit', hour12: false });


	$scope.data.radio_right_text = timeString;

    const isMuted = !data.electrics.qashqai16_volume;

    const textEl = document.querySelector('.radio_center_text');

    function setCenterText(text) {
      if (!textEl) return;
      textEl.style.animation = "";
      textEl.style.transform = "translateX(0)";
      textEl.textContent = text;

      // Apply scrolling only if text overflows
      const container = document.querySelector('.radio-center-container');
      if (!container) return;

      const cw = container.clientWidth;
      const tw = textEl.scrollWidth;

      if (tw > cw) {
        const speed = 50; // px/sec
        const duration = (tw + cw) / speed;

        void textEl.offsetWidth; // force reflow
        textEl.style.animation = `slide-text ${duration}s linear infinite`;
      }
    }

    // Handle volume changes
    if (previousVolume !== data.electrics.qashqai16_volume) {
      previousVolume = data.electrics.qashqai16_volume;
      showingVolumeMessage = true;

      const volumeText = isMuted ? "Mute" : `Volume: ${previousVolume * 2}`;
      setCenterText(volumeText);

      if (volumeMessageTimeout) clearTimeout(volumeMessageTimeout);

      volumeMessageTimeout = setTimeout(() => {
        $scope.$evalAsync(() => {
          showingVolumeMessage = false;

          if (!isMuted) {
            setCenterText(currentSong);
          } else {
            setCenterText("Mute");
          }
        });
      }, 2000);

      return;
    }

    if (showingVolumeMessage) return; // do not scroll during volume

    // Normal display
    if (!isMuted) {
      if (previousSongIndex !== currentIndex) {
        setCenterText(currentSong);
      }
    } else {
      setCenterText("Mute");
    }

    previousSongIndex = currentIndex;
  });
};


});
