angular.module('gaugesScreen', [])
.controller('GaugesScreenController', function($scope, $window) {
  var units = {
    uiUnitConsumptionRate: "metric",
    uiUnitDate: "ger",
    uiUnitEnergy: "metric",
    uiUnitLength: "metric",
    uiUnitPower: "hp",
    uiUnitPressure: "bar",
    uiUnitTemperature: "c",
    uiUnitTorque: "metric",
    uiUnitVolume: "l",
    uiUnitWeight: "kg"
  };

  $scope.data = {
    gps_data1: '', // Author
    gps_data2: '', // Song Title
    gps_data3: ''
  };

  let previousSongIndex = 0;

  $window.setup = (setupData) => {
    for (let dk in setupData) {
      if (typeof dk === "string" && dk.startsWith("uiUnit")) {
        units[dk] = setupData[dk];
      }
    }
    vueEventBus.emit('SettingsChanged', { values: units });
  };

  $window.updateData = (data) => {
    $scope.$evalAsync(() => {
      const songNames = data.customModules.qashqai16_songs.names || [];
      const currentIndex = data.electrics.current_music_index || 1;
      const currentSong = songNames[currentIndex - 1] || "Unknown";

	  const now = new Date();
	  const timeString = now.toLocaleTimeString([], { hour: '2-digit', minute: '2-digit', hour12: false });


	  $scope.data.gps_data3 = timeString;

      // Regex to match " space long_hyphen space "
      const splitRegex = /\s-\s/;

      if (splitRegex.test(currentSong)) {
        const parts = currentSong.split(splitRegex);
        $scope.data.gps_data1 = parts[0].trim();
        $scope.data.gps_data2 = parts[1].trim();
      } else {
        // Fallback: display the whole title on one line
        $scope.data.gps_data1 = '';
        $scope.data.gps_data2 = currentSong;
      }
     
      previousSongIndex = currentIndex;
    });
  };
});