-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}
local htmlTexture = require("htmlTexture")

local updateTimer = 0
local updateFPS = 60

local hasSentMapData = false
local vehicleID = obj:getID()



local alreadyParked = 1;
local alreadyParkedMajor = 1;
local alreadyHigh = 0;


local function onInit()
   -- hasSentMapData = false
    obj:queueGameEngineLua("extensions.load('ui/uinavi')")
    
	--htmlTexture.create("@R60Nav", "local://local/vehicles/volkswagen_tcross/navi_screen.html", 420, 128, 30, 'automatic')
	htmlTexture.create("@q5_screen_digi", "local://local/vehicles/q5/gauges_screen/gauges_screen_q52.html", 544, 128, 30, 'automatic')
	
	--Init function for dashboard
    htmlTexture.call("@q5_screen_digi", "init")
	--obj:queueGameEngineLua(string.format('extensions.ui_uinavi.requestVehicleDashboardMap(%q)', "@R60Nav"))
	
	hasSentMapData = true
	
	--Resets the last menu option when the car is respawned to force an update
	lastMenuOption = 50;

end

local function onReset()
    --local destroy = 'be:getObjectByID('..vehicleID..'):destroyUITexture("'..naviScreenName..'")'
    --obj:queueGameEngineLua(destroy)
    onInit()
end



local function updateGFX(dt)

	--map
    if hasSentMapData then
        --local pos = obj:getPosition()
		--local posX = pos.x
		--local posY = pos.y
        --local rotation = math.deg(obj:getDirection()) + 180
       -- local speed = (electrics.values.airspeed or 0) * 3.6
        --local zoom = math.min(300 + speed * 1.5, 500)

        --obj:queueGameEngineLua("if be:getObjectByID("..vehicleID..") then be:getObjectByID("..vehicleID.."):queueJSUITexture('"..naviScreenName.."', 'map.setPosition("..pos.x..", "..pos.y..", "..rotation..")') end")
        --obj:queueGameEngineLua("if be:getObjectByID("..vehicleID..") then be:getObjectByID("..vehicleID.."):queueJSUITexture('"..naviScreenName.."', 'map.setZoom("..zoom..")') end")
    
		--htmlTexture.call("@R60Nav", "map.setPosition",{posX=posX,posY=posY,rotation=rotation})
		--htmlTexture.call("@R60Nav", "map.setZoom", zoom)
		
		local pos = obj:getPosition()
		local rotation = math.deg(obj:getDirection()) + 180
		local speed = electrics.values.wheelspeed * 1.609
		local zoom = math.min(300 + speed * 1.5, 500)
		
		local data = {x = pos.x, y = pos.y, rotation = rotation, zoom = zoom}
		--htmlTexture.call("@R60Nav", "map.updateData", data)
	end	
	
	
	--Dashboard
	local wSpeed = math.floor( electrics.values.wheelspeed * 3.6 or 0)  
	local nspeed = electrics.values.vwDigitalSpeedo
	local rpm = math.floor( electrics.values.rpm + 0.5 or 0)
	local gear = electrics.values.gear
	local parked = math.floor(electrics.values.parkingbrake + 0.5 or 0)
	local high = math.floor(electrics.values.highbeam + 0.5 or 0)
	local indicatorL = electrics.values.signal_L
	local indicatorR = electrics.values.signal_R
	local tcs = electrics.values.tcs
	local esc = electrics.values.esc
	local igni = electrics.values.ignition 
	local temp = math.floor(obj:getEnvTemperature() - 273.15) 
	local time = os.date("%H") .. ":" .. os.date("%M")

	
	
	--Checking if gear == null to prevent any issues

	htmlTexture.call("@q5_screen_digi", "updateGear", gear)

	
	htmlTexture.call("@q5_screen_digi", "updateSpeed", wSpeed)
	htmlTexture.call("@q5_screen_digi", "updateSpeedN", nspeed)
	htmlTexture.call("@q5_screen_digi", "updateRPM", rpm)
	htmlTexture.call("@q5_screen_digi", "updateTcs", {tcs=tcs,esc=esc})
	htmlTexture.call("@q5_screen_digi", "updateTPMS", {tpmslight})
	htmlTexture.call("@q5_screen_digi", "updateTemp", {temp})
	htmlTexture.call("@q5_screen_digi", "updateTime", {time})

	
	if (high < 0.5) then
		--headLights are turned off
		if (alreadyHigh == 1) then
			--Headlights were turned off this cycle
			
			htmlTexture.call("@q5_screen_digi", "updateHeadLightsOff")
			alreadyHigh = 0
		end
	else
		--headlights are turned on
		if (alreadyHigh == 0) then
			--Headlights were turned on this cycle
			htmlTexture.call("@q5_screen_digi", "updateHeadLightsOn")
			alreadyHigh = 1
		end
	end
	
	if (parked < 0.5) then
		--If parking brake is off
		if (alreadyParked == 1) then
			--parking brake was turned off this cycle therefore disable warning
			htmlTexture.call("@q5_screen_digi", "updateParkingBrakeOff")
			alreadyParked = 0
		end
	else
		--If parking brake is on
		
		--If RPM goes over 1000 while parking brake is on display major warning
		if (rpm > 1000) then
			htmlTexture.call("@q5_screen_digi", "updateParkingBrakeMajor")
		end
		
		if (rpm < 1000) then
			htmlTexture.call("@q5_screen_digi", "updateParkingBrakeMajorOff")
		end
		
		if (alreadyParked == 0) then
			--Parking brake was turned on this cycle therefore enable warning
			htmlTexture.call("@q5_screen_digi", "updateParkingBrakeOn")
			alreadyParked = 1
		end	

	
	end
	
	
	
	
end



-- public interface
M.onInit    = onInit
M.onReset   = onReset
M.updateGFX = updateGFX

return M
