-- written by DaddelZeit
-- DO NOT USE WITHOUT PERMISSION

local M = {}
M.type = "auxiliary"
M.relevantDevice = nil

local htmlTexture = require("htmlTexture")

local screenMaterialName = nil
local htmlFilePath = nil

local updateTimer = 0
local updateFPS = 15
local invFPS = 1 / updateFPS

local gpsData = {x = 0, y = 0, rotation = 0, zoom = 1}

local function updateGFX(dt)
  updateTimer = updateTimer + dt
  if updateTimer > invFPS and playerInfo.anyPlayerSeated then
    updateTimer = 0
    local pos = obj:getPosition()
    local rotation = math.deg(obj:getDirection()) + 180
    local speed = electrics.values.airspeed * 3.6
    local zoom = math.min(150 + speed * 1.5, 250)

    gpsData.x = pos.x
    gpsData.y = pos.y
    gpsData.rotation = rotation
    gpsData.zoom = zoom
    htmlTexture.call(screenMaterialName, "map.updateData", gpsData)

    local data = {}
    if zeitRadio then data = zeitRadio.getCurrentlyPlayingSongData() end
    htmlTexture.call(screenMaterialName, "updateData", data)
  end
end

local function reset()
end

local function init(jbeamData)
  screenMaterialName = jbeamData.screenMaterialName or "@fullsuv_main_screen"
  htmlFilePath = jbeamData.htmlFilePath or "local://local/vehicles/fullsuv/display/main_screen.html"
  local width = jbeamData.textureWidth or 512
  local height = jbeamData.textureHeight or 256

  if not screenMaterialName then
    log("E", "fullsuvMainScreen", "Got no material name for the texture, can't display anything...")
    M.updateGFX = nop
  else
    if htmlFilePath then
      htmlTexture.create(screenMaterialName, htmlFilePath, width, height, updateFPS, "automatic")
      obj:queueGameEngineLua(string.format("extensions.ui_uinavi.requestVehicleDashboardMap(%q)", screenMaterialName))
      print("chrars")
    else
      log("E", "fullsuvMainScreen", "Got no html path for the texture, can't display anything...")
      M.updateGFX = nop
    end
  end
end

M.reset = reset
M.init = init
M.updateGFX = updateGFX

return M
