-- written by DaddelZeit
-- DO NOT USE WITHOUT PERMISSION

local M = {}

M.type = "auxiliary"
M.messages = {
  lowfuel = {
    issued = false,
    message = "Fuel Level Low.",
    title = ""
  },
  watertemp = {
    issued = false,
    message = "High Engine Temperature.",
    title = ""
  },
  lowTirePressure = {
    issued = false,
    message = "Check tires for damage.",
    title = "Low Tire Pressure"
  },
  oilPanLeak = {
    issued = false,
    message = "Refill oil. \nIf happening repeatedly \nvisit service.",
    title = "Low Oil Pressure"
  },
  highBraketemp = {
    issued = false,
    message = "High Brake Temperature.",
    title = ""
  },
  checkengine = {
    issued = false,
    message = "Mechanical fault.\nVisit service.",
    title = "Check Engine"
  },
  sunroof = {
    issued = false,
    message = "High Wind Warning.\nSunroof may need closed.",
    title = "Close Sunroof",
    hydroId = 0
  },
  sunroof2 = {
    issued = false,
    message = "High Wind Warning.\nPanoroof may get damaged.",
    title = "Close Panoroof",
    hydroId = 0
  },

  -- air suspension
  airSuspensionLimitHigh = {
    issued = false,
    message = "Maximum height reached",
    title = "Air Suspension"
  },
  airSuspensionLimitLow = {
    issued = false,
    message = "Minimum height reached",
    title = "Air Suspension"
  },
  airSuspensionBounceMode = {
    issued = false,
    message = "Bounce Mode Enabled",
    title = "Air Suspension"
  }
}

local issuedMessages = deepcopy(M.messages)
local gaugeHTMLTexture
local timer = 0
local currentWarning = false

local soundURL = ""
local soundNode = 0
local soundVolume = 0
local isInside = false

local function updateGFX(dt)
  obj:queueGameEngineLua( [[
  local camObj = getCamera()
  camObj = (camObj and Sim.upcast(camObj)) or camObj
  local bool = core_camera and core_camera.isCameraInside(0, getCameraPosition())
  be:getPlayerVehicle(0):queueLuaCommand('controller.getControllerSafe("gauges/customModules/fullsuvMessageBox").enableSound('..tostring(bool)..')')
  ]] )
end

local function updateData(path)
end

local function enableSound(bool)
  isInside = bool
end

local function updateGaugeData(moduleData, dt)
  if currentWarning then
    timer = timer + dt

    if timer > 5 then
      local data = { hide = true }
      gaugeHTMLTexture:streamJS("toggleMessageWindow", "toggleMessageWindow", data)
      currentWarning = false
    end
    return
  end

  M.messages["sunroof"].issued = (electrics.values.sunroof1 == 1 and electrics.values.wheelspeed*3.6 > 120) and (v.data.hydros[M.messages["sunroof"].hydroId].state == v.data.hydros[M.messages["sunroof"].hydroId].outLimit) and M.messages["sunroof"].hydroId ~= 0
  M.messages["sunroof2"].issued = (electrics.values.sunroof2 == 1 and electrics.values.wheelspeed*3.6 > 100) and (v.data.hydros[M.messages["sunroof2"].hydroId].state == v.data.hydros[M.messages["sunroof2"].hydroId].outLimit) and M.messages["sunroof"].hydroId ~= 0
  M.messages["lowfuel"].issued = electrics.values.lowfuel == true
  M.messages["watertemp"].issued = electrics.values.watertemp > 110
  M.messages["lowTirePressure"].issued = (electrics.values.tirepressure == 1)
  M.messages["oilPanLeak"].issued = (electrics.values.oilPanLeak == 1)
  M.messages["highBraketemp"].issued = (electrics.values.highBraketemp == 1)
  M.messages["checkengine"].issued = (electrics.values.checkengineBetter == 1)
  M.messages["airSuspensionLimitHigh"].issued = (electrics.values.airSuspensionLimitHigh == 1)
  M.messages["airSuspensionLimitLow"].issued = (electrics.values.airSuspensionLimitLow == 1)
  M.messages["airSuspensionBounceMode"].issued = (electrics.values.airSuspensionBounceMode == 1)

  for k,v in pairs(M.messages) do
    if v.issued == true and v.issued ~= issuedMessages[k].issued then
      local data = {
        messageTitle = v.title,
        messageText = v.message
      }
      if v.message2 then data.messageText2 = v.message2 end
      issuedMessages[k].issued = v.issued

      timer = 0
      currentWarning = true
      gaugeHTMLTexture:streamJS("toggleMessageWindow", "toggleMessageWindow", data)

      if isInside then obj:playSFXOnce("fullsuvGaugeMessageWindow", soundNode, soundVolume, 1) end
    elseif v.issued ~= issuedMessages[k].issued then
      issuedMessages[k].issued = v.issued
    end
  end

  --issuedWarnings = M.warnings
end

local function setupGaugeData(properties, htmlTexture)
  gaugeHTMLTexture = htmlTexture

  local data = { hide = true }
  gaugeHTMLTexture:streamJS("toggleMessageWindow", "toggleMessageWindow", data)
end

local function reset()
  local data = { hide = true }
  gaugeHTMLTexture:streamJS("toggleMessageWindow", "toggleMessageWindow", data)
  currentWarning = false
end

local function init(jbeamData)
  for _,v in pairs(v.data.nodes) do
    if v.name == jbeamData.soundNode then
      soundNode = v.cid
    end
  end

  soundURL = jbeamData.soundEvent
  soundVolume = jbeamData.soundVolume or 1

  for _,v in pairs(v.data.hydros) do
    if v.inputSource == "sunroof1" then
      M.messages["sunroof"].hydroId = v.cid
    elseif v.inputSource == "sunroof2" then
      M.messages["sunroof2"].hydroId = v.cid
    end
  end
  dump(v.data.hydros[M.messages["sunroof"].hydroId])
end

local function initSounds()
  if soundURL then
    obj:createSFXSource(soundURL, "AudioDefault3D", "fullsuvGaugeMessageWindow", -1)
  end
end

M.init = init
M.reset = reset
M.updateGFX = updateGFX
M.initSounds = initSounds
M.enableSound = enableSound

M.updateData = updateData
M.updateGaugeData = updateGaugeData
M.setupGaugeData = setupGaugeData

return M
