local M = {}
local crashThreshold = 60
local rollThreshold = 9.8
local state = "idle"
local abs = math.abs

function updateGFX(dt)
  
   if state == "idle" then
   if sensors.gy2 > crashThreshold then
      controller.getController("vehicleController").setEngineIgnition(false)      
	  gui.message("Shutting off ignition...", 10)
    end
	
	if sensors.gz2 > rollThreshold and sensors.gz2 < 11 then	
		controller.getController("vehicleController").setEngineIgnition(false)
		state = "braking"
		electrics.set_warn_signal(true)
      gui.message("Rollover detected, shutting off ignition...", 10)
	  end
	  
	  elseif state == "braking" then
    electrics.values.brake = 1
    electrics.values.throttle = 0
    input.event("throttle", 0, 0) 
	
	 if abs(electrics.values.wheelspeed) < 0.5 then --or electrics.values.gearIndex < 0
     
	 input.event("parkingbrake", 1, 0)
      state = "holding"
	  input.event("throttle", 0, 0) 
      lastThrottle = input.throttle
    end	
	
	elseif state == "holding" then    
    if electrics.values.throttle > lastThrottle * 1.5 then		
      input.event("parkingbrake", 0, 0)
      electrics.set_warn_signal(false)
		state = "idle"
    end
    lastThrottle = electrics.values.throttle
	
	end
end

function onReset()
    electrics.set_warn_signal(false)
	crashThreshold = 60
	rollThreshold = 9.8
	state = "idle"	
end

function onInit()
    extensions.load('postCrashHorn')
end

-- public interface
M.onInit = onInit
M.onReset = onReset
M.updateGFX = updateGFX

return M