angular.module('beamng.app').directive('nitrousOxideControl', ['vehicleManager', '$interval', function(vehicleManager, $interval) {
  return {
    restrict: 'E',
    scope: {},
    template: `
      <div class="nitrous-oxide-control panel">
        <h3>Nitrous Oxide</h3>
        <button ng-click="toggleNitrous()" ng-class="{'armed': isArmed}">
          {{ isArmed ? 'Disarm' : 'Arm' }}
        </button>
        <div class="status" ng-if="isActive">Status: ACTIVE!</div>
        <div class="status" ng-if="!isActive">Status: OFF</div>
      </div>
    `,
    link: function(scope) {
      var vehicle = null;
      scope.isArmed = false;
      scope.isActive = false;

      function updateState() {
        if (!vehicle) return;
        var electrics = vehicle.get('electrics');
        if (!electrics) return;

        scope.isArmed = electrics.get('nitrousOxideArm') >= 1;
        scope.isActive = electrics.get('nitrousOxideActive') >= 1;
      }

      scope.toggleNitrous = function() {
        if (!vehicle) return;
        var electrics = vehicle.get('electrics');
        if (!electrics) return;

        electrics.set('nitrousOxideArm', scope.isArmed ? 0 : 1);
      };

      function refresh() {
        updateState();
      }

      var intervalPromise = $interval(refresh, 100);

      vehicleManager.getVehicles().then(function(vehicles) {
        if (vehicles.length > 0) {
          vehicle = vehicles[0]; // Current vehicle
          updateState();
        }
      });

      scope.$on('$destroy', function() {
        $interval.cancel(intervalPromise);
      });
    }
  };
}]);
