-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}
M.type = "auxiliary"

local engine = nil
local engineMaxRPM = 1
local gearbox = nil
local electricsName = nil
local hasBuiltPie = false

local timer1 = 0
local timer2 = 0
local rndNumb = 0
local transbrakeState = 0
local gearIndex = 0

local function updateGFX(dt)
  electrics.values[electricsName] = gearbox.lockCoef == 0
  JSD_Flame_tune.toggle_flames(0)
  timer1 = timer1 + 0.1
  timer2 = timer2 + 0.1

  gearIndex = electrics.values.gearIndex or 0
  if timer1 >= 0.6 then
    timer1 = 0
    -- print("Timer1 (transbrake):" .. timer1)
  end

  if timer2 >= 0.6 then
    timer2 = 0
    -- print("Timer2 (transbrake):" .. timer2)
  end

  engineMaxRPM = powertrain.getDevice("mainEngine").maxRPM
    -- print("Max RPM:" .. engineMaxRPM)
  rndNumb = math.random(0.5, 0.6)
  if timer2 >= rndNumb and electrics.values.rpm >= (powertrain.getDevice("mainEngine").maxRPM - 200) then
    JSD_Flame_tune.flame_sound()
    timer2 = 0
  end

  if transbrakeState >= 2 then
    transbrakeState = 0
  end
  if transbrakeState == 1 and gearIndex >= 0.5 then
		rndNumb = math.random(0.5, 0.6)
    if timer1 >= rndNumb and electrics.values.rpm >= 3000 then
      JSD_Flame_tune.flame_sound()
      timer1 = 0
    end
  end
end

local function setTransbrake(value)
  if gearbox then
    gearbox:setLock(value)
    guihooks.message("Transbrake is " .. (value and "enabled" or "disabled"), 2, "vehicle.transbrake.status")
    transbrakeState = transbrakeState + 1
  end
end

local function toggleTransbrake()
  if gearbox then
    local enabled = gearbox.lockCoef == 0
    setTransbrake(not enabled)
  end
end

local function init(jbeamData)
  local gearboxName = jbeamData.gearboxName or "gearbox"
  local engineName = jbeamData.engineName or "mainEngine"
  electricsName = jbeamData.electricsName or "transbrake"
  engine = powertrain.getDevice(engineName)
  gearbox = powertrain.getDevice(gearboxName)
  M.updateGFX = gearbox and updateGFX or nop

  if not hasBuiltPie then
    if gearbox then
      core_quickAccess.addEntry(
        {
          level = "/powertrain/",
          generator = function(entries)
            local noEntry = {
              title = "Transbrake",
              priority = 40,
              icon = "material_swap_horiz",
              onSelect = function()
                controller.getController("transbrake").toggleTransbrake()
                return {"reload"}
              end
            }
            if gearbox.lockCoef == 0 then
              noEntry.color = "#ff6600"
            end
            table.insert(entries, noEntry)
          end
        }
      )
    end
    hasBuiltPie = true
  end
end

--example: onGameplayEvent("controller:transbrake", "setTransbrake", true)
--example: onGameplayEvent("controller:myTransbrakeName", "setTransbrake", false)
local function onGameplayEvent(event, ...)
  local splits = split(event, ":")
  if splits[1] == "controller" and (splits[2] == M.typeName or splits[2] == M.name) then
    local params = {...}
    local dataTypeCheck, dataTypeError = checkTableDataTypes(params, {"string", "boolean"})
    if not dataTypeCheck then
      log("E", "transbrake.onGameplayEvent", dataTypeError)
      return
    end
    if params[1] == "setTransbrake" then
      setTransbrake(params[2])
    end
  end
end

M.init = init
M.updateGFX = nop
M.toggleTransbrake = toggleTransbrake
M.setTransbrake = setTransbrake
M.onGameplayEvent = onGameplayEvent

return M
