angular.module('gaugesScreen', [])
.controller('GaugesScreenController', function($scope, $window, $timeout) {
    $scope.data = {
        mphVal: "Bork",
        gear: "Bork",
        rpm: "Bork",
        coolantTempVal: "Bork",
        boostVal: "Bork",
        blackout: false,
        circle1Opacity: 0.1,
        circle2Opacity: 0.1,
        circle3Opacity: 0.1,
        circle4Opacity: 0.1,
        circle5Opacity: 0.1,
        circle6Opacity: 0.1,
        circle7Opacity: 0.1,
        circle8Opacity: 0.1,
        circle9Opacity: 0.1,
        circle10Opacity: 0.1,
        circle11Opacity: 0.1,
        circle12Opacity: 0.1,
        circle13Opacity: 0.1,
        circle14Opacity: 0.1,
        circle15Opacity: 0.1,
        twostepLightOpacity: 0.1,
        showFuelLevelRec: false,
        showOilPressRec: false,
        showFuelPressRec: false,
        showOilTempRec: false,
        showWaterRec: false,
        showTransTempRec: false,
        showRpmRec: false,
        showSplashScreen: false,
        loadingBarWidth: 0,
        showVoltsRec: false
    };
    const afrDecelValue = 18, afrAccelValue = 12.5, afrIdleValue = 14.7, idleFuelPressure = 60, maxRPMIncrease = 10, fuelRandomVariance = 2, coldOilTempF = 70, warmOilTempF = 190, hotOilTempF = 250, coldOilPressure = 104, warmOilPressure = 73, hotOilPressure = 5, coldRPMPressureIncrease = 20, warmRPMPressureIncrease = 10, lowRPMThreshold = 500, nearZeroRPMThreshold = 25;
    function getRandomAFR(baseValue, variance) {
        return (baseValue + (Math.random() * (variance * 2) - variance)).toFixed(1);
    }
    function updateOrbOpacities(currentRPM, maxRPM) {
        const totalOrbs = 15;
        if (currentRPM < 1000) {
            for (let i = 1; i <= totalOrbs; i++) {
                $scope.data[`circle${i}Opacity`] = 0.1;
            }
        } else {
            const rpmRange = maxRPM - 1000, rpmExcess = currentRPM - 1000, proportion = Math.min(rpmExcess / rpmRange, 1), orbsToLight = Math.floor(proportion * totalOrbs);
            for (let i = 1; i <= totalOrbs; i++) {
                $scope.data[`circle${i}Opacity`] = i <= orbsToLight ? 0.9 : 0.1;
            }
        }
    }
    function resetCircleOpacities() {
        for (let i = 1; i <= 15; i++) {
            $scope.data[`circle${i}Opacity`] = 0.1;
        }
    }
    function updateTwostepLight(isActive) {
        $scope.data.twostepLightOpacity = isActive ? 0.9 : 0.1;
    }
    function startLoadingBar() {
        let loadingProgress = 0, totalDuration = 3000, intervalDuration = 20, increment = 100 / (totalDuration / intervalDuration);
        const loadingInterval = setInterval(() => {
            $scope.$apply(() => {
                loadingProgress += increment;
                $scope.data.loadingBarWidth = (loadingProgress / 100) * 1000;
            });
            if (loadingProgress >= 100) clearInterval(loadingInterval);
        }, intervalDuration);
    }
    $window.updateData = (data) => {
        $scope.$evalAsync(function () {
            const previousIgnState = $scope.data.ign || 0;
            $scope.data.ign = data.ign;
            if (previousIgnState === 0 && (data.ign === 1 || data.ign === 3)) {
                $scope.data.showSplashScreen = true;
                $scope.data.loadingBarWidth = 0;
                startLoadingBar();
                $timeout(() => { $scope.data.showSplashScreen = false; }, 3000);
            }
            $scope.data.blackout = data.ign <= 0.1;
            if ($scope.data.blackout) {
                $scope.data.mphVal = "00";
                $scope.data.gear = "00";
                $scope.data.rpm = "00";
                $scope.data.coolantTempVal = "00";
                $scope.data.boostVal = "00";
                $scope.data.oilTempVal = "00";
                $scope.data.waterVal = "00";
                $scope.data.voltsVal = "00";
                $scope.data.fuelPressVal = "00";
                $scope.data.afrLeftVal = "00";
                $scope.data.afrRightVal = "00";
                $scope.data.twostepLightOpacity = 0.1;
                resetCircleOpacities();
                $scope.data.showFuelLevelRec = $scope.data.showOilPressRec = $scope.data.showFuelPressRec = $scope.data.showOilTempRec = $scope.data.showWaterRec = $scope.data.showTransTempRec = $scope.data.showRpmRec = false;
                return;
            }
            $scope.data.gear = data.gear === -1 ? "R" : data.gear === 0 ? "N" : data.gear;
            $scope.data.boostVal = data.boost.toFixed(0);
            const fuelPct = (data.fuel * 100 ).toFixed(0) + "%";
            $scope.data.fuelPercentage = fuelPct;
            $scope.data.rpm = data.ripems;
            $scope.data.mphVal = (data.speed * 2.23694).toFixed(0);
            $scope.data.gpsSpeedVal = (data.gps * 2.23694).toFixed(0);
            $scope.data.timingVal = data.timing.toFixed(0);
            let oilTempF = (data.oiltemp * 1.8) + 32, coolantTempF = (data.watertemp * 1.8) + 32, transOilTempF = oilTempF < 180 ? 135 : oilTempF > 250 ? 230 : 135 + ((oilTempF - 180) / 60) * 50;
            $scope.data.transOilTempVal = transOilTempF.toFixed(0);
            $scope.data.oilTempVal = oilTempF.toFixed(0);
            $scope.data.waterVal = coolantTempF.toFixed(0);
            $scope.data.voltsVal = data.voltsVal ? data.voltsVal.toFixed(1) : "00";
            $scope.data.showVoltsRec = parseFloat($scope.data.voltsVal) < 12.8;
            if (data.ripems < 500) {
                $scope.data.afrLeftVal = $scope.data.afrRightVal = 0;
            } else if (data.ripems >= 4500) {
                $scope.data.afrLeftVal = $scope.data.afrRightVal = getRandomAFR(afrAccelValue, 0.1);
            } else if (data.ripems < 1300) {
                $scope.data.afrLeftVal = $scope.data.afrRightVal = getRandomAFR(afrIdleValue, 0.1);
            } else {
                $scope.data.afrLeftVal = $scope.data.afrRightVal = getRandomAFR(afrDecelValue, 0.1);
            }
            let baseFuelPressure = idleFuelPressure + (Math.random() * 4 - 2), rpmFuelPressure = (data.ripems / 10000) * maxRPMIncrease;
            if (data.ripems < lowRPMThreshold) {
                let pressureDropFactor = data.ripems < nearZeroRPMThreshold ? 0 : data.ripems / lowRPMThreshold;
                baseFuelPressure *= pressureDropFactor;
                rpmFuelPressure *= pressureDropFactor;
            }
            let fuelPressure = baseFuelPressure + rpmFuelPressure;
            $scope.data.fuelPressVal = (fuelPressure + data.boost).toFixed(0);
            let oilPressure = data.ripems === 0 ? 0 : oilTempF <= 70 ? coldOilPressure + (data.ripems / 10000) * coldRPMPressureIncrease : oilTempF >= 250 ? hotOilPressure : warmOilPressure + ((oilTempF - warmOilTempF) / (hotOilTempF - warmOilTempF)) * (hotOilPressure - warmOilPressure) + (data.ripems / 10000) * warmRPMPressureIncrease;
            if (data.ripems < lowRPMThreshold) {
                let pressureDropFactor = data.ripems < nearZeroRPMThreshold ? 0 : data.ripems / lowRPMThreshold;
                oilPressure *= pressureDropFactor;
            }
            if (data.ripems !== 0) oilPressure += Math.random() * 2 - 1;
            $scope.data.oilPressVal = oilPressure.toFixed(0);
            $scope.data.timingVal = data.ripems < 400 ? 12 : data.timing.toFixed(0);
            const maxRPM = data.maxRpm || 8000, currentRPM = data.ripems, thresholdRPM = 1000;
            currentRPM >= thresholdRPM ? updateOrbOpacities(currentRPM, maxRPM) : resetCircleOpacities();
            $scope.data.twostepLightOpacity = data.twoStep !== undefined ? (data.twoStep ? 0.9 : 0.1) : 0.1;
            $scope.data.showFuelRec = parseFloat(fuelPct) < 3;
            $scope.data.showOilPressRec = parseFloat($scope.data.oilPressVal) < 20;
            $scope.data.showFuelPressRec = parseFloat($scope.data.fuelPressVal) < 50;
            $scope.data.showOilTempRec = parseFloat($scope.data.oilTempVal) > 250;
            $scope.data.showWaterTempRec = parseFloat($scope.data.waterVal) > 240;
            $scope.data.showTransTempRec = parseFloat($scope.data.transOilTempVal) > 200;
            $scope.data.showRpmRec = currentRPM > maxRPM - 400;
        });
    };
});
