angular.module('gaugesScreen', [])
.controller('GaugesScreenController', function($scope, $window) {

	  const rpmMax = 7000;
  const speedMax = 330;
  const tempMax = 130;
  const fuelMax = 100;
  const oilTempMax = 150;
  


	
	
  var units = {uiUnitConsumptionRate: "metric",
 
  uiUnitDate: "ger",
  uiUnitEnergy: "metric",
  uiUnitLength: "metric",
  uiUnitPower: "hp",
  uiUnitPressure: "bar",
  uiUnitTemperature: "c",
  uiUnitTorque: "metric",
  uiUnitVolume: "l",
  uiUnitWeight: "kg"};
  
  $scope.data = {};

  let lastRpm = 0, targetRpm = 0;
  let lastSpeed = 0, targetSpeed = 0;
  let hasReachedSpeedThreshold = false;
  let lastTemp = 0, targetTemp = 0;
  let lastFuel = 0, targetFuel = 0;
  let lastOil = 0, targetOil = 0;
  let lastFuelCons = 0, targetFuelCons = 0;
  




  function animateNeedles() {
    lastRpm += (targetRpm - lastRpm) * 0.2;
    lastSpeed += (targetSpeed - lastSpeed) * 0.2;
    lastTemp += (targetTemp - lastTemp) * 0.2;
    lastFuel += (targetFuel - lastFuel) * 0.2;
    lastOil += (targetOil - lastOil) * 0.2;

    const rpmNeedle = document.querySelector('.needle-rpm');
    if (rpmNeedle) {
      const angle = 9.1 + (lastRpm / rpmMax) * 210;

  rpmNeedle.style.transform = `rotate(${angle}deg)`;
    }






    requestAnimationFrame(animateNeedles);
  }

  animateNeedles();


  $window.setup = (setupData) => {
    for(let dk in setupData){
      if(typeof dk == "string" && dk.startsWith("uiUnit")){
        units[dk] = setupData[dk];
      }
    }
    vueEventBus.emit('SettingsChanged', {values:units})


    $scope.data.speedUnit = units.uiUnitLength=="metric"?"km/h":"mph";
  };
  
 
	const bootIntro = document.getElementById("bootIntro");
const bootWrapper = document.getElementById("bootIntroWrapper");
let bootWasShown = false;
let lastEngineRunning = false;
let lastIgnitionOn = false;
let fadeOutTimer = null;
	
	
	
	
	
	
	
	
$window.updateMode = function (data) {
	
  if (!data?.modeName) return;

  const svgDoc = document.querySelector('.dashboard-bg')?.contentDocument;
  if (!svgDoc) return;
  const text = svgDoc.getElementById('ModeText');
  const box = svgDoc.getElementById('ModeBOX');










  const modeMap = {
    "Comfort": "NORMAL",
    "Sport": "SPORT",
    "Sport+": "SPORT PLUS",
    "Off": "OFF"
  };

  const fullText = modeMap[data.modeName] || data.modeName;

  if (text) text.textContent = fullText.toUpperCase();
  if (box && data.modeColor) box.setAttribute('stroke', data.modeColor);
};









  $window.updateData = (data) => {
    $scope.$evalAsync(() => {


const ignitionLevel = data.electrics?.ignitionLevel || 0;
const ignitionOn = ignitionLevel > 0;                 // ключ повернут?
const engineRunning = !!data.electrics?.engineRunning; // мотор реально запущен?

// 2) Указатели на DOM-слои (они у тебя уже объявлены выше в файле)
const bootIntro  = document.getElementById("bootIntro");
const bootWrapper = document.getElementById("bootIntroWrapper");

// Вспомогалки
function showIntro() {
  if (!bootIntro || !bootWrapper) return;

  // если было запланировано затухание — отменим
  if (fadeOutTimer) { clearTimeout(fadeOutTimer); fadeOutTimer = null; }

  // показать слой и плавно проявить саму картинку (опирается на transition у <img> в HTML)
  bootWrapper.style.display = "flex";
  bootWrapper.style.opacity = "1";

  // перезапуск гифки/кадра
  const src = bootIntro.src;
  bootIntro.src = ""; bootIntro.src = src;

  // плавный fade-in (transition задан в HTML)
  bootIntro.style.opacity = "0";
  requestAnimationFrame(() => {
    bootIntro.style.opacity = "1";
  });
}

function fadeOutIntro(delayMs = 1000) {
  if (!bootIntro || !bootWrapper) return;
  if (fadeOutTimer) { clearTimeout(fadeOutTimer); }

  fadeOutTimer = setTimeout(() => {
    // начать плавное затухание картинки (её transition ~0.8s в HTML)
    bootIntro.style.opacity = "0";
    // параллельно затемним обёртку (у неё transition ~1s в HTML)
    bootWrapper.style.opacity = "0";

    // когда затухание обёртки закончится — спрячем слой
    setTimeout(() => {
      bootWrapper.style.display = "none";
      bootWrapper.style.opacity = "1"; // вернуть дефолт на будущее
      // bootIntro оставляем с opacity 0, чтобы следующий showIntro дал плавный вход
    }, 1000);
  }, delayMs);
}

// Логика:
// A) Включили зажигание (переход 0 -> >0): ПЛАВНО ПОЯВИТЬ и ДЕРЖАТЬ
if (ignitionOn && !lastIgnitionOn) {
  showIntro();
}

// B) Выключили зажигание (переход >0 -> 0): СКРЫТЬ СРАЗУ
if (!ignitionOn && lastIgnitionOn) {
  if (fadeOutTimer) { clearTimeout(fadeOutTimer); fadeOutTimer = null; }
  if (bootWrapper) {
    bootWrapper.style.display = "none";
    bootWrapper.style.opacity = "1";
  }
  if (bootIntro) bootIntro.style.opacity = "0";
}

// C) Мотор запустился (false -> true): через 1 секунду начинаем ЗАТУХАТЬ
if (engineRunning && !lastEngineRunning) {
  fadeOutIntro(1000); // <- задержка 1s перед началом fade-out
}

// Запомним прошлые состояния
lastIgnitionOn = ignitionOn;
lastEngineRunning = engineRunning;



const isImperial = units.uiUnitLength === "imperial";
const speedKph = data.electrics.wheelspeed * 3.6;
const speedMph = speedKph / 1.60934;
const threshold = isImperial ? 15 : 25;
const currentSpeed = isImperial ? speedMph : speedKph;

const pressureHint = document.querySelector('.tire-pressure-msg');
if (pressureHint) {
  pressureHint.textContent = isImperial ? "Meas. above 15 mph" : "Meas. above 25 km/h";

  if (!hasReachedSpeedThreshold && currentSpeed >= threshold) {
    hasReachedSpeedThreshold = true;
  }

  pressureHint.style.display = hasReachedSpeedThreshold ? "none" : "block";
}

      const rpm = data.electrics.rpm || 0;
      const speed = UiUnits.speed(data.electrics.wheelspeed).val.toFixed(0);

	  
	  
const tireData = data.customModules?.tireData || {};
const pressures = tireData.pressures || {};



function formatPressureKpa(valueKpa) {
  if (typeof valueKpa === "number") {
    const bar = valueKpa / 100;
    return bar.toFixed(1) + " bar";
  }
  return "---";
}


$scope.data.pressureFL = hasReachedSpeedThreshold ? formatPressureKpa(pressures.FL) : "---";
$scope.data.pressureFR = hasReachedSpeedThreshold ? formatPressureKpa(pressures.FR) : "---";
$scope.data.pressureRL = hasReachedSpeedThreshold ? formatPressureKpa(pressures.RL) : "---";
$scope.data.pressureRR = hasReachedSpeedThreshold ? formatPressureKpa(pressures.RR) : "---";


      const fuel = data.electrics.fuel || 0;
	  
	  
      const coolant = data.electrics.watertemp || 0; 
	  const odometer  = Math.round(data.electrics?.panamernken_odometer || 0);

      const oiltemp = data.electrics.oiltemp || 0;
      const watertemp = data.electrics.watertemp || 0;
      const time = data.customModules?.environmentData?.time || "--:--";
      const currentFuelConsumption = data.customModules?.combustionEngineData?.currentFuelConsumption || 0;
	  
	  



let rawGear = data.electrics?.gear;
let parsedGear = "";

if (rawGear === -1) {
  parsedGear = "R";
} else if (rawGear === 0) {
  parsedGear = "N";
} else if (typeof rawGear === "string") {
  if (rawGear.startsWith("M")) {
    parsedGear = "M"; //
  } else if (rawGear.startsWith("S") || rawGear.startsWith("D")) {
    parsedGear = "D";
  } else {
    parsedGear = rawGear;
  }
} else {
  parsedGear = rawGear;
}

$scope.data.parsedGear = parsedGear;

const svgDoc = document.querySelector('.dashboard-bg')?.contentDocument;
if (svgDoc) updateTransmissionDisplay(svgDoc, parsedGear);
if (!svgDoc) return;











const parkingBrakeEl = svgDoc.getElementById("parkingbrake");
if (parkingBrakeEl) {
  const isBrakeOn = !!data.electrics?.parkingbrakelight;
  parkingBrakeEl.setAttribute("visibility", isBrakeOn ? "visible" : "hidden");
}


const lowpressureEl = svgDoc.getElementById("lowpressure");
if (lowpressureEl) {
  const islowpressureOn = !!data.electrics?.lowpressure;
  lowpressureEl.setAttribute("visibility", islowpressureOn ? "visible" : "hidden");
}


const signal_REl = svgDoc.getElementById("signal_R");
if (signal_REl) {
  const issignal_ROn = !!data.electrics?.signal_R;
  signal_REl.setAttribute("visibility", issignal_ROn ? "visible" : "hidden");
}

const signal_LEl = svgDoc.getElementById("signal_L");
if (signal_LEl) {
  const issignal_LOn = !!data.electrics?.signal_L;
  signal_LEl.setAttribute("visibility", issignal_LOn ? "visible" : "hidden");
}


const absEl = svgDoc.getElementById("abs");
if (absEl) {
  const isabsOn = !!data.electrics?.absActive;
  absEl.setAttribute("visibility", isabsOn ? "visible" : "hidden");
}

const checkengineEl = svgDoc.getElementById("checkengine");
if (checkengineEl) {
  const ischeckengineOn = !!data.electrics?.checkengine;
  checkengineEl.setAttribute("visibility", ischeckengineOn ? "visible" : "hidden");
}

const runningEl = svgDoc.getElementById("running");
if (runningEl) {
  const isrunningOn = !!data.electrics?.engineRunning;
  runningEl.setAttribute("visibility", isrunningOn ? "visible" : "hidden");
}

const lowhighbeamEl = svgDoc.getElementById("lowhighbeam");
if (lowhighbeamEl) {
  const islowhighbeamOn = !!data.electrics?.lowhighbeam;
  lowhighbeamEl.setAttribute("visibility", islowhighbeamOn ? "visible" : "hidden");
}

const highbeamEl = svgDoc.getElementById("highbeam");
if (highbeamEl) {
  const ishighbeamOn = !!data.electrics?.highbeam;
  highbeamEl.setAttribute("visibility", ishighbeamOn ? "visible" : "hidden");
}


const brakeEl = svgDoc.getElementById("brake");
if (brakeEl) {
  const isbrakeOn = !!data.electrics?.abswarn;
  brakeEl.setAttribute("visibility", isbrakeOn ? "visible" : "hidden");
}


const escEl = svgDoc.getElementById("esc");
if (escEl) {
  const isescOn = !!data.electrics?.esc;
  escEl.setAttribute("visibility", isescOn ? "visible" : "hidden");
}

const escActiveEl = svgDoc.getElementById("escActive");
if (escActiveEl) {
  const isescActiveOn = !!data.electrics?.escActive;
  escActiveEl.setAttribute("visibility", isescActiveOn ? "visible" : "hidden");
}


const abswarnEl = svgDoc.getElementById("abswarn");
if (abswarnEl) {
  const isabswarnOn = !!data.electrics?.absActive;
  abswarnEl.setAttribute("visibility", isabswarnOn ? "visible" : "hidden");
}

const lowfuelEl = svgDoc.getElementById("lowfuel");
if (lowfuelEl) {
  const islowfuelOn = !!data.electrics?.lowfuel;
  lowfuelEl.setAttribute("visibility", islowfuelOn ? "visible" : "hidden");
}

const oilEl = svgDoc.getElementById("oil");
if (oilEl) {
  const isoilOn = !!data.electrics?.oil;
  oilEl.setAttribute("visibility", isoilOn ? "visible" : "hidden");
}







const watertempEl = svgDoc.getElementById("watertemp");
if (watertempEl) {
  const iswatertempOn = watertemp > 110;
  watertempEl.setAttribute("visibility", iswatertempOn ? "visible" : "hidden");
}


const oiltempEl = svgDoc.getElementById("oiltemp");
if (oiltempEl) {
  const isoiltempOn = oiltemp > 130;
  oiltempEl.setAttribute("visibility", isoiltempOn ? "visible" : "hidden");
}













const cruiseActive = data.electrics?.cruiseControlActive;
const cruiseSpeed = data.electrics?.cruiseControlTarget;
const cruiseText = svgDoc?.getElementById("cruiseSpeedText");

if (cruiseText) {
  if (cruiseActive && cruiseSpeed > 0) {
    const speed = isImperial ? cruiseSpeed * 2.23694 : cruiseSpeed * 3.6;
    const unit = isImperial ? " mph" : " km/h";
    cruiseText.textContent = Math.round(speed) + unit;
  } else {
    cruiseText.textContent = "---";
  }
}

const waterFill = svgDoc?.getElementById("waterTempFill");
const oilFill = svgDoc?.getElementById("oilTempFill");

// Параметры
const maxHeight = 235;
const baseY = 955 + maxHeight; 

// Уровень от 0 до 1
const waterLevel = Math.max(0, Math.min(1, watertemp / 130));
const oilLevel = Math.max(0, Math.min(1, oiltemp / 150));

if (waterFill) {
  const h = maxHeight * waterLevel;
  waterFill.setAttribute("height", h);
  waterFill.setAttribute("y", baseY - h);
  waterFill.style.transition = "width 0.2s ease";
}

if (oilFill) {
  const h = maxHeight * oilLevel;
  oilFill.setAttribute("height", h);
  oilFill.setAttribute("y", baseY - h);
  oilFill.style.transition = "width 0.2s ease";
}



const fuelFill = svgDoc?.getElementById("fuelFill");
fuelFill.style.transition = "width 0.4s ease";

if (fuelFill && typeof data.electrics.fuel === "number") {
  const maxWidth = 560; 
  const fuelLevel = Math.max(0, Math.min(1, data.electrics.fuel));
  fuelFill.setAttribute("width", fuelLevel * maxWidth);
}





const fuelRange = svgDoc.getElementById("fuelRangeText");
if (fuelRange) {
  fuelRange.textContent = $scope.data.range || "-- km";
}







const gx = data.customModules?.accelerationData?.xSmooth || 0;
const gy = data.customModules?.accelerationData?.ySmooth || 0;


const scale = 15;
const gforceDot = svgDoc.getElementById('gforce-dot');
if (gforceDot) {
  gforceDot.setAttribute('transform', `translate(${gx * scale}, ${-gy * scale})`);
}


const gxPositive = gx > 0 ? (gx / 10).toFixed(1) : "0.0";
const gxNegative = gx < 0 ? (-gx / 10).toFixed(1) : "0.0";
const gyPositive = gy > 0 ? (gy / 10).toFixed(1) : "0.0";
const gyNegative = gy < 0 ? (-gy / 10).toFixed(1) : "0.0";


const gforceXPos = svgDoc.getElementById('gforce-x-positive');
if (gforceXPos) gforceXPos.textContent = gxPositive;

const gforceXNeg = svgDoc.getElementById('gforce-x-negative');
if (gforceXNeg) gforceXNeg.textContent = gxNegative;

const gforceYPos = svgDoc.getElementById('gforce-y-positive');
if (gforceYPos) gforceYPos.textContent = gyPositive;

const gforceYNeg = svgDoc.getElementById('gforce-y-negative');
if (gforceYNeg) gforceYNeg.textContent = gyNegative;
	  
	  
	  
	  
	  
	  
	  

      targetRpm = rpm;
      targetSpeed = speed;
      targetFuel = fuel * 100;
      targetTemp = coolant;
      targetOil = oiltemp;
      targetFuelCons = currentFuelConsumption;


      $scope.data.engineRpm = Math.round(rpm);

	 
      $scope.data.speedUnit = (units.uiUnitLength === "metric") ? "km/h" : "mph";
      $scope.data.engineRpm = Math.round(rpm);
      $scope.data.fuel = Math.round(fuel * 100);
      $scope.data.speedVal = Math.round(speed);
      $scope.data.time = time;
	  


	if (units.uiUnitTemperature === 'c') {
  $scope.data.oilTemp = `${Math.round(oiltemp)} °C`;
  $scope.data.waterTemp = `${Math.round(watertemp)} °C`;
} else {
  const oilF = (oiltemp * 9 / 5) + 32;
  const waterF = (watertemp * 9 / 5) + 32;
  $scope.data.oilTemp = `${Math.round(oilF)} °F`;
  $scope.data.waterTemp = `${Math.round(waterF)} °F`;
}


if (data.electrics.panamernken_odometer) {
  let val = data.electrics.panamernken_odometer;
  val *= (units.uiUnitLength === "metric") ? 1 : 0.6215;
  val = Math.min(999999, val);

  let intPart = Math.floor(val).toString().padStart(1, "0");
  $scope.data.odo = `${intPart}${units.uiUnitLength === "metric" ? "  km" : "  mi"}`;
} else {
  $scope.data.odo = "";
}


      $scope.data.fuelConsumption = (units.uiUnitLength === "metric")
        ? currentFuelConsumption.toFixed(1) + " l/100km"
        : (235.2 / currentFuelConsumption).toFixed(1) + " mpg";


let temperatureEnv = data.customModules?.environmentData?.temperatureEnv;
if (units.uiUnitTemperature === 'c') {
  $scope.data.temp = (temperatureEnv > 99.9 || temperatureEnv < -99.9)
    ? "---°C"
    : temperatureEnv.toFixed(0) + " °C";
} else {
  const fahrenheit = (temperatureEnv * 9 / 5) + 32;
  $scope.data.temp = (fahrenheit > 99.9 || fahrenheit < -99.9)
    ? "---°F"
    : fahrenheit.toFixed(0) + " °F";
}









function updateTransmissionDisplay(svgDoc, gear) {
  const gearBoxP = svgDoc.getElementById("GearBoxP");
  const gearTextP = svgDoc.getElementById("GearTextP");

  if (gear === "P") {
    if (gearBoxP) gearBoxP.setAttribute("visibility", "visible");
    if (gearTextP) {
      gearTextP.setAttribute("visibility", "visible");
      gearTextP.setAttribute("fill", "black");
      gearTextP.setAttribute("font-size", "80");
    }
  } else {
    if (gearBoxP) gearBoxP.setAttribute("visibility", "hidden");
    if (gearTextP) gearTextP.setAttribute("visibility", "hidden");
  }

  ["R", "N", "D", "M"].forEach((g) => {
    const el = svgDoc.getElementById("GearText" + g);
    if (!el) return;

    const isActive = gear === g;
    el.setAttribute("fill", isActive ? "#00BFFF" : "#FFFFFF");
    el.setAttribute("font-size", isActive ? "65" : "50");
	
const elM = svgDoc.getElementById("GearTextM");
if (elM && typeof data?.electrics?.gear === "string") {
  const g = data.electrics.gear;
  if (g.startsWith("M")) {
    elM.textContent = g; 
  } else {
    elM.textContent = "M";
  }
}
  });
}





const fuelUsed = data.engine?.fuelUsed || 0;
const distanceKm = odometer / 1000;
let avgConsumption = 15;
if (distanceKm > 0.5 && fuelUsed > 0.01) {
  avgConsumption = (fuelUsed / distanceKm) * 100;
}
const fuelCapacity = data.engine?.fuelCapacity || 50;
const fuelLiters = fuel * fuelCapacity;
let range = (fuelLiters / avgConsumption) * 216;

if (units.uiUnitLength !== "metric") {
  range *= 0.621371; 
}

$scope.data.range = Math.round(range) + (units.uiUnitLength === "metric" ? " km" : " mi");



    });
  };

});
