-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt
local M = {}

local function init()
  electrics.values.disp_R = 0
  electrics.values.disp_N = 0
  electrics.values.disp_1 = 0
  electrics.values.disp_2 = 0
  electrics.values.disp_3 = 0
  electrics.values.disp_4 = 0
  electrics.values.disp_5 = 0
  electrics.values.disp_6 = 0
  electrics.values.disp_Pa = 0
  electrics.values.disp_Ra = 0
  electrics.values.disp_Na = 0
  electrics.values.disp_Da = 0
  electrics.values.disp_P_cvt = 0
  electrics.values.disp_R_cvt = 0
  electrics.values.disp_N_cvt = 0
  electrics.values.disp_D_cvt = 0
  electrics.values.disp_L_cvt = 0
end

local function reset()
  init()
end

local function updateGFX(dt)
  local gearIndex = electrics.values.gearIndex or 0
  local gear_A = electrics.values.gear_A or 0
  --Rev
  electrics.values.disp_R = gearIndex < -0.5 and 1 or 0
  --Neutral
  electrics.values.disp_N = (gearIndex >= -0.5 and gearIndex < 0.5) and 1 or 0
  --First
  electrics.values.disp_1 = (gearIndex >= 0.5 and gearIndex < 1.5) and 1 or 0
  --Second
  electrics.values.disp_2 = (gearIndex >= 1.5 and gearIndex < 2.5) and 1 or 0
  --Third
  electrics.values.disp_3 = (gearIndex >= 2.5 and gearIndex < 3.5) and 1 or 0
  --Fourth
  electrics.values.disp_4 = (gearIndex >= 3.5 and gearIndex < 4.5) and 1 or 0
  --Fifth
  electrics.values.disp_5 = (gearIndex >= 4.5 and gearIndex < 5.5) and 1 or 0
  --Sixth
  electrics.values.disp_6 = gearIndex > 5.5 and 1 or 0
  --Park Auto
  electrics.values.disp_Pa = gear_A < 0.1 and 1 or 0
  --Reverse Auto
  electrics.values.disp_Ra = (gear_A >= 0.1 and gear_A < 0.2) and 1 or 0
  --Neutral Auto
  electrics.values.disp_Na = (gear_A >= 0.2 and gear_A < 0.3) and 1 or 0
  --Drive Auto
  if gear_A >= 0.3 and gear_A < 0.4 then
    electrics.values.disp_Da = 1
    --if in D ignore the gearIndex digits
    electrics.values.disp_1 = 0
    electrics.values.disp_2 = 0
    electrics.values.disp_3 = 0
    electrics.values.disp_4 = 0
    electrics.values.disp_5 = 0
    electrics.values.disp_6 = 0
  else
    electrics.values.disp_Da = 0
  end
  --Park CVT
  electrics.values.disp_P_cvt = gear_A < 0.2 and 1 or 0
  --Reverse CVT
  electrics.values.disp_R_cvt = (gear_A >= 0.2 and gear_A < 0.4) and 1 or 0
  --Neutral CVT
  electrics.values.disp_N_cvt = (gear_A >= 0.4 and gear_A < 0.7) and 1 or 0
  --Drive CVT
  electrics.values.disp_D_cvt = gear_A >= 0.7 and 1 or 0
end

-- public interface
M.onInit = init
M.onReset = reset
M.updateGFX = updateGFX

return M
