local M = {}

-- Made by LucasBE
-- Do not reuse or modify without permission. Feel free to use this as a reference for your own code

-- configurable variables
local operationTime = 2.5 -- time it takes to open/close a window (in seconds)
local dipAmount = 0.1     -- amount frameless windows dip down by (0.1 is 10% of total window travel)
local dipTime = 2         -- time it takes for the frameless window to dip
local dipDelay = 0.3      -- delay after door is closed for the frameless window to go back up

-- define windows and coupler values here
-- control electrics have to be defined as "glassName_control" (i.e. glass_FR_control) in Jbeam
-- you can add as many windows as you want in each category ("frameless" or "regular")
local windows = {
    frameless = {
        {name = "glass_FR", coupler = "doorRCoupler"},
        {name = "glass_FL", coupler = "doorLCoupler"}
    },
    regular = {
        {name = "glass_RR"},
        {name = "glass_RL"}
    }
}

local isDipped = {}
local closeTimers = {}

local function onReset()
    for _, windowGroup in pairs(windows) do
        for _, window in ipairs(windowGroup) do
            local windowName = type(window) == "table" and window.name or window
            electrics.values[windowName] = 0
            electrics.values[windowName .. "_control"] = 0
            isDipped[windowName] = false
            closeTimers[windowName] = 0
        end
    end
end

local function updateGFX(dt)

    
    --if electrics.values.ignitionLevel < 1 then
        -- freeze windows if ignition is off
        --return
    --end

    local function updateWindow(window, targetValue)

        local currentValue = electrics.values[window]
        local controlValue = electrics.values[window .. "_control"]

        if controlValue == 1 then
            return math.min(currentValue + (dt / operationTime), targetValue or 1)
        else
            return math.max(currentValue - (dt / operationTime), 0)
        end
    end

    local function dipWindow(currentValue, targetValue, dt)
        if currentValue < targetValue then
            return math.min(currentValue + (dt / dipTime), targetValue)
        elseif currentValue > targetValue then
            return math.max(currentValue - (dt / dipTime), targetValue)
        else
            return currentValue
        end
    end

    local function updateWindowFrameless(window, couplerValue)
        local currentValue = electrics.values[window]
        local controlValue = electrics.values[window .. "_control"]

        if electrics.values[couplerValue] == 1 then
            if currentValue == 0 and not isDipped[window] then
                electrics.values[window] = dipWindow(currentValue, dipAmount, dt)
                isDipped[window] = electrics.values[window] >= dipAmount
            elseif currentValue <= dipAmount then
                electrics.values[window] = dipWindow(currentValue, dipAmount, dt)
                isDipped[window] = true
            end

            if controlValue == 1 and currentValue > 0 then
                electrics.values[window] = updateWindow(window, 1)
                isDipped[window] = false
            elseif controlValue == 0 and currentValue > dipAmount then
                electrics.values[window] = dipWindow(currentValue, dipAmount, dt)
            end
            closeTimers[window] = 0
        else
            if isDipped[window] then
                closeTimers[window] = closeTimers[window] + dt
                if closeTimers[window] >= dipDelay then
                    electrics.values[window] = updateWindow(window, 0)
                    if electrics.values[window] == 0 then
                        isDipped[window] = false
                    end
                end
            else
                electrics.values[window] = updateWindow(window, 1)
            end
        end
    end

    for _, window in ipairs(windows.frameless) do
        updateWindowFrameless(window.name, window.coupler .. "_notAttached")
    end

    for _, window in ipairs(windows.regular) do
        electrics.values[window.name] = updateWindow(window.name)
    end
end

-- Public interface
M.updateGFX = updateGFX
M.onInit = onReset
M.onReset = onReset

return M
