local M = {}

-- Made by LucasBE
-- Do not reuse or modify without permission. Feel free to use this as a reference for your own code

-- configurable variables
local maxAllowedSpeed = 30    -- max operation speed in km/h
local operationDuration = 10  -- total duration for full soft top operation (open/close) in seconds
local maxChangesAllowed = 5   -- maximum changes allowed before warning
local maxChangesOverheat = 10 -- maximum changes allowed before motor is broken
local monitoringPeriod = 10   -- monitoring period for roof state change in seconds (overheating logic)
local safeguardDelay = 0.1

local safeguardTimer, operationTimer, roofMotorBroken = 0, 0, false
local changeCount, changeTimestamps = 0, {}
local pausedPosition, softtopTarget, operationInProgress = nil, nil, false
local softtopState, lastSofttopAsked = 0, -1

local function onReset()
    electrics.values.softtopAsked = 0
    electrics.values.softtopElectric = 0
    electrics.values.softtopOperating = 0
    safeguardTimer, operationTimer = 0, 0
    changeCount = 0
    changeTimestamps = {}
    roofMotorBroken = false
    softtopTarget = nil
    pausedPosition = nil
    operationInProgress = false
    softtopState = 0
    lastSofttopAsked = -1
    electrics.values.glass_RL_control = 0
    electrics.values.glass_RR_control = 0
    lastCouplerState = 0
end

local function updateGFX(dt)

    if electrics.values.softtopCoupler_notAttached == nil then
        return -- leaves if softtop isn't equipped
    end

    electrics.values.softtopOperating = operationInProgress and 1 or 0

    -- safeguard and state update when coupled
    if electrics.values.softtopCoupler_notAttached == 0 then
        safeguardTimer = safeguardTimer + dt
        if safeguardTimer >= safeguardDelay then
            softtopTarget = 0
        end
        softtopState = 0
        operationInProgress = false
    else
        safeguardTimer = 0
        softtopState = 1
    end

    -- handle motor overheating and breaking
    if roofMotorBroken then
        electrics.values.softtopElectric = lastElectricState
        softtopTarget = nil
        if electrics.values.softtopAsked > 0 then
            guihooks.message("Roof motor broken", 5, "nil")
            electrics.values.softtopAsked = 0
        end
        return
    end

    -- handle ignition off, pause operation
    if electrics.values.ignitionLevel < 1 then
        if softtopTarget ~= nil then
            operationInProgress = false
        end
        return
    elseif pausedPosition ~= nil then
        softtopTarget = softtopTarget
        operationInProgress = true
    end

    -- main operation logic
    if electrics.values.ignitionLevel >= 1 then
        
        -- open rear windows
        if electrics.values.softtopCoupler_notAttached ~= lastCouplerState then
            lastCouplerState = electrics.values.softtopCoupler_notAttached
            if electrics.values.softtopCoupler_notAttached == 1 then
                if electrics.values.glass_RL_control == 0 then
                    electrics.values.glass_RL_control = 1
                end
                if electrics.values.glass_RR_control == 0 then
                    electrics.values.glass_RR_control = 1
                end
            else
                if electrics.values.glass_RL_control == 1 then
                    electrics.values.glass_RL_control = 0
                end
                if electrics.values.glass_RR_control == 1 then
                    electrics.values.glass_RR_control = 0
                end
            end
        end

        if electrics.values.softtopAsked ~= lastSofttopAsked then
            lastSofttopAsked = electrics.values.softtopAsked

            if electrics.values.softtopAsked == 1 then
                if electrics.values.wheelspeed <= maxAllowedSpeed / 3.6 then
                    table.insert(changeTimestamps, os.clock())
                    changeCount = changeCount + 1

                    -- determine target state
                    if softtopState == 0 then
                        softtopTarget = 1
                    elseif softtopTarget ~= nil then
                        softtopTarget = 1 - softtopTarget
                    else
                        softtopTarget = 0
                    end
                    operationTimer = 0
                    operationInProgress = true

                else
                    local speedLimit = maxAllowedSpeed
                    local speedUnitStr = "km/h"

                    if settings.getValue("uiUnitLength") == "imperial" then
                        speedLimit = maxAllowedSpeed / 1.60934
                        speedUnitStr = "mph"
                    end

                    speedLimit = math.floor((speedLimit + 2.5) / 5) * 5
                    guihooks.message("The roof cannot be operated over " .. speedLimit .. " " .. speedUnitStr, 5, "nil")
                end
            end
        end

        if electrics.values.softtopAsked ~= 1 then
            operationTimer = 0
        end
    end

    -- smooth transition to target
    if softtopTarget ~= nil then
        local current = electrics.values.softtopElectric
        local diff = softtopTarget - current
        local increment = (dt / operationDuration) * (diff > 0 and 1 or -1)
        electrics.values.softtopElectric = current + increment
        if (increment > 0 and electrics.values.softtopElectric >= softtopTarget) or (increment < 0 and electrics.values.softtopElectric <= softtopTarget) then
            electrics.values.softtopElectric = softtopTarget
            softtopTarget = nil
            operationInProgress = false
        end
    end

    -- remove old timestamps and check for overheating
    while #changeTimestamps > 0 and os.clock() - changeTimestamps[1] > monitoringPeriod do
        table.remove(changeTimestamps, 1)
        changeCount = changeCount - 1
    end

    if changeCount > maxChangesAllowed and changeCount <= maxChangesOverheat then
        guihooks.message("Roof motor overheating", 5, "nil")
    elseif changeCount > maxChangesOverheat then
        roofMotorBroken = true
        lastElectricState = electrics.values.softtopElectric
        guihooks.message("Roof motor broken", 5, "nil")
    end
end

-- public interface
M.updateGFX = updateGFX
M.onInit = onReset
M.onReset = onReset

return M
