-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

local function onReset()
    
	
	electrics.values['ramp_lift'] = 0
    electrics.values['ramp_lift_input'] = 0
	
	electrics.values['crane_rotate'] = 0
    electrics.values['crane_rotate_input'] = 0
	
	electrics.values['main_boom_lift'] = 0
    electrics.values['main_boom_lift_input'] = 0
	
	electrics.values['knuckle_boom_lift'] = 0
    electrics.values['knuckle_boom_lift_input'] = 0
	
	electrics.values['hook_lift'] = 0
    electrics.values['hook_lift_input'] = 0
	
	electrics.values['davit_extend'] = 0
    electrics.values['davit_extend_input'] = 0
	
	electrics.values['davit_lift'] = 0
    electrics.values['davit_lift_input'] = 0
	
	electrics.values['light_rotate'] = 0
    electrics.values['light_rotate_input'] = 0
	
	electrics.values['light_vertical_rotate'] = 0
    electrics.values['light_vertical_rotate_input'] = 0
	
	
	
	
end

local function updateGFX(dt)
   
	electrics.values['ramp_lift'] = math.min(1, math.max(-0, (electrics.values['ramp_lift'] + electrics.values['ramp_lift_input'] * dt * 0.065)))
	electrics.values['crane_rotate'] = math.min(1, math.max(-1, (electrics.values['crane_rotate'] + electrics.values['crane_rotate_input'] * dt * 0.004)))
	electrics.values['main_boom_lift'] = math.min(1, math.max(0, (electrics.values['main_boom_lift'] + electrics.values['main_boom_lift_input'] * dt * 0.036)))
	electrics.values['knuckle_boom_lift'] = math.min(1, math.max(0, (electrics.values['knuckle_boom_lift'] + electrics.values['knuckle_boom_lift_input'] * dt * 0.065)))
	electrics.values['hook_lift'] = math.min(1, math.max(-0.007, (electrics.values['hook_lift'] + electrics.values['hook_lift_input'] * dt * 0.01)))
	electrics.values['davit_extend'] = math.min(1, math.max(0, (electrics.values['davit_extend'] + electrics.values['davit_extend_input'] * dt * 0.08)))
	electrics.values['davit_lift'] = math.min(1, math.max(-0.15, (electrics.values['davit_lift'] + electrics.values['davit_lift_input'] * dt * 0.05)))
	electrics.values['light_rotate'] = math.min(1, math.max(-1, (electrics.values['light_rotate'] + electrics.values['light_rotate_input'] * dt * 0.01)))
	electrics.values['light_vertical_rotate'] = math.min(1, math.max(-0.7, (electrics.values['light_vertical_rotate'] + electrics.values['light_vertical_rotate_input'] * dt * 0.2)))
	
end

-- public interface
M.onInit    = onReset
M.onReset   = onReset
M.updateGFX = updateGFX

return M
