-- written by DaddelZeit
-- DO NOT USE WITHOUT PERMISSION

-- modified by szanto_sz

local M = {}

local refHydros = {
    stage1 = "newsuper_stage1_reference",
    stage2 = "newsuper_stage2_reference",
    stage3 = "newsuper_stage3_reference",
    stage4 = "newsuper_stage4_reference",
    roof = "newsuper_roof_reference",
}

local stage1Smoother = newTemporalSigmoidSmoothing(0.4, 0.6, 0.6, 0.6, 0)
local stage2Smoother = newTemporalSigmoidSmoothing(0.4, 0.6, 0.6, 0.6, 0)
local stage3Smoother = newTemporalSigmoidSmoothing(0.4, 0.6, 0.6, 0.6, 0)
local stage4Smoother = newTemporalSigmoidSmoothing(0.4, 0.6, 0.6, 0.6, 0)
local stage5Smoother = newTemporalSigmoidSmoothing(0.4, 0.6, 0.5, 0.3, 0)
local roofMotionState = 0
local stage1TargetValue = 0
local stage2TargetValue = 0
local stage3TargetValue = 0
local stage4TargetValue = 0
local stage5TargetValue = 0
local direction = "open"

local whirrLoop = 0

local function getHydroState(cid)
    return v.data.hydros[cid].state
end

local function roofMovementFinish()
    roofMotionState = 0
    electrics.values.roofMoving = 0
    obj:playSFXOnceCT("event:>Vehicle>Latches>Hood>modern_07_open_hood", v.data.refNodes[0].ref, 2, 0.5, 0.4, 0)
    obj:stopSFX(whirrLoop)
end

local function openMovement()
    local roofOpen = getHydroState(refHydros.roof) < 0.76
    local stage1Open = getHydroState(refHydros.stage1) < 0.65
    local stage2Open = getHydroState(refHydros.stage2) > 1.9
    local stage3Open = getHydroState(refHydros.stage3) > 7.95
    local stage4Open = getHydroState(refHydros.stage4) > 2.35
    
    if roofMotionState == 1 then 
        stage1TargetValue = 1

        if stage1Open then
            stage2TargetValue = 1
        end
        
        if stage2Open then
            stage3TargetValue = 1

            if stage3Open then
                stage4TargetValue = 1
                
                if stage4Open then
                    stage5TargetValue = 1
                    
                    roofMotionState = roofOpen and 2 or roofMotionState
                end
            end
        end

    elseif roofMotionState == 2 then
        stage3TargetValue = 0
        stage4TargetValue = 0
        if getHydroState(refHydros.stage3) < 2 then
            stage2TargetValue = 0
        end

        -- this is terrible, but occasionally beamng decides that 1 isn't actually 1 and so it gets stuck here
        if tostring(stage5TargetValue) == "1" then
            if electrics.values.toggle_stage2roof == 0 then
                roofMovementFinish()
            end
        end
    end

end

local function closeMovement()
    local roofClosed = getHydroState(refHydros.roof) > 0.98
    local stage1Closed = getHydroState(refHydros.stage1) > 0.98
    local stage2Open = getHydroState(refHydros.stage2) > 1.9
    local stage3Open = getHydroState(refHydros.stage3) > 7.95
    local stage4Open = getHydroState(refHydros.stage4) > 1
    local stage4closed = getHydroState(refHydros.stage4) < 1.05

    if roofMotionState == 1 then 
        stage2TargetValue = 1

        if stage2Open then
            stage3TargetValue = 1

            if stage3Open then
                stage4TargetValue = 1
                
                if stage4Open then
                    stage5TargetValue = 0
                    if roofClosed then
                        
                        roofMotionState = roofClosed and 2 or roofMotionState
                    end
                end
            end
        end

    elseif roofMotionState == 2 then
        stage4TargetValue = 0
        if stage4closed then
            stage3TargetValue = 0
        end

        if getHydroState(refHydros.stage3) < 1.05 then
            stage2TargetValue = 0
            
            if getHydroState(refHydros.stage2) > 1.5 then
                stage1TargetValue = 0
            end
        end
        

        -- this is terrible, but occasionally beamng decides that 1 isn't actually 1 and so it gets stuck here
        if tostring(stage5TargetValue) == "0" then
            if electrics.values.toggle_stage2roof == 0 then
                roofMovementFinish()
            end
        end

    end

end

local function updateGFX(dt)

    if roofMotionState == 0 then return end

    electrics.values.toggle_stage1roof = stage1Smoother:get(stage1TargetValue, dt)
    electrics.values.toggle_stage2roof = stage2Smoother:get(stage2TargetValue, dt)
    electrics.values.toggle_stage3roof = stage3Smoother:get(stage3TargetValue, dt)
    electrics.values.toggle_stage4roof = stage4Smoother:get(stage4TargetValue, dt)
    electrics.values.toggle_stage5roof = stage5Smoother:get(stage5TargetValue, dt)
    
    local volume = math.abs(stage1Smoother.prevvel)*0.65+math.abs(stage2Smoother.prevvel)*0.35+math.abs(stage3Smoother.prevvel)*0.65+math.abs(stage4Smoother.prevvel)*0.85+math.abs(stage5Smoother.prevvel)*0.75
    local pitch = math.abs(stage1Smoother.prevvel)*0.8+math.abs(stage2Smoother.prevvel)*0.75+math.abs(stage3Smoother.prevvel)*0.65+math.abs(stage4Smoother.prevvel)*0.65+math.abs(stage5Smoother.prevvel)*0.8+0.7
    obj:setVolumePitch(whirrLoop, volume, pitch)

    if direction == "open" then
        openMovement()
    else
        closeMovement()
    end
end

local function startRoofAction()
    if roofMotionState ~= 0 then
        guihooks.message("Please wait for the roof to completely open/close.", 2, "vehicle.newsuperroof.canttoggle")
        return
    end

    if electrics.values.wheelspeed > 2.68224 then
        guihooks.message("The roof cannot be toggled above 6mph (10km/h).", 2, "vehicle.newsuperroof.canttoggle")
        return
    end

    controller.getController("roofOpen").toggleGroup()

    if getHydroState(refHydros.roof) < 0.98 then
        stage5TargetValue = 1
        direction = "close"
        guihooks.message("The roof is now closing.", 15, "vehicle.newsuperroof.toggled")
        electrics.values.roofMoving = 2
    else
        stage5TargetValue = 0
        direction = "open"
        guihooks.message("The roof is now opening.", 15, "vehicle.newsuperroof.toggled")
        electrics.values.roofMoving = 1
    end

    obj:playSFXOnceCT("event:>Vehicle>Latches>Hood>modern_06_open_hood", v.data.refNodes[0].ref, 1, 0.5, 0.1, 0)
    obj:playSFX(whirrLoop)

    roofMotionState = 1
end

local function initSounds()
    whirrLoop = obj:createSFXSource2("/vehicles/newsuper/art/sound/electric_whirr.ogg", "AudioDefaultLoop3D", "roofWhirrLoop", v.data.hydros[refHydros.stage3].id1, 0)
end

local function init()
    for i=0, tableSizeC(v.data.hydros)-1 do
        local v = v.data.hydros[i]

        if not v.tag then goto skip end
        for k,v2 in pairs(refHydros) do
            if v2 ~= v.tag then goto skip2 end
            refHydros[k] = v.cid
            ::skip2::
        end
        ::skip::
    end

    electrics.values.toggle_newsuperroof = 0
    electrics.values.toggle_stage1roof = 0
    electrics.values.toggle_stage2roof = 0
    electrics.values.toggle_stage3roof = 0
    electrics.values.toggle_stage4roof = 0
    electrics.values.toggle_stage5roof = 0
    electrics.values.roofMoving = 0
end

local function reset()
    roofMotionState = 0
    stage1Smoother:set(0)
    stage2Smoother:set(0)
    stage3Smoother:set(0)
    stage4Smoother:set(0)
    stage5Smoother:set(0)
    stage1TargetValue = 0
    stage2TargetValue = 0
    stage3TargetValue = 0
    stage4TargetValue = 0
    stage5TargetValue = 0
    electrics.values.toggle_newsuperroof = 0
    electrics.values.toggle_stage1roof = 0
    electrics.values.toggle_stage2roof = 0
    electrics.values.toggle_stage3roof = 0
    electrics.values.toggle_stage4roof = 0
    electrics.values.toggle_stage5roof = 0
    electrics.values.roofMoving = 0
end

M.tailgateCheck = tailgateCheck
M.initSounds = initSounds
M.startRoofAction = startRoofAction
M.updateGFX = updateGFX
M.init = init
M.reset = reset

return M
