angular.module('gaugesScreen', [])

  .controller('GaugesScreenController', function ($scope, $element, $window) {
    "use strict";
    var vm = this;

    var svg;
    var navContainer = $element[0].children[0];
    var navDimensions = [];

    var gauge = { gears: {} };
    var tacho = {  };
    var infoDisplay = {};
    var roots = {};
    var electrics = {lights:{} };
    var gagues = {fuel:{},temp:{}};


    var speedoInitialised = true;
    var currentGear = '';

    var ready = false;

    var unit = "metric";
    var unitspeedConv = 2.23694;


    // Make sure SVG is loaded
    $scope.onSVGLoaded = function () {
        console.log("onSVGLoaded");
      svg = $element[0].children[0].children[0];
	  
      roots.fuel_bar = hu('#fuel_bar', svg);
	  
      //speedometer
      gears.root = hu('#gears', svg);
      gauge.gears.P = hu('#gear_P', svg);
      gauge.gears.R = hu('#gear_R', svg);
      gauge.gears.N = hu('#gear_N', svg);
      gauge.gears.D = hu('#gear_D', svg);
      gauge.gears["1"] = hu('#gear_1', svg);
      gauge.gears["2"] = hu('#gear_2', svg);
      gauge.gears["3"] = hu('#gear_3', svg);
      gauge.gears["4"] = hu('#gear_4', svg);
      gauge.gears["5"] = hu('#gear_5', svg);
      gauge.gears["6"] = hu('#gear_6', svg);


      electrics.root = hu('#electrics', svg);
      electrics.lights.lights = hu("#light_lights", electrics.root);
      electrics.lights.highbeam = hu("#light_highbeam", electrics.root);
      electrics.lights.parkingbrake = hu("#light_parkingbrake", electrics.root);
      electrics.lights.checkengine = hu("#light_checkengine", electrics.root);
      electrics.abs = hu("#light_abs", electrics.root);

      ready = true;
    }


    function fixClock(v, fill="0"){
      return (v<10)? fill+v : v;
    }
	
	    function updateGagueFuel(data) {
      let fuel = data.electrics.fuel;
      let children = roots.fuel_bar.n.childNodes

      for (let i = 0; i < children.length; i++) {
        let index = parseInt(children[i].id.replace("fuel_bar_","")); //not lucky :(
        children[i].style.opacity = (fuel >= index*0.052 )?1:0;
      }
    }
	
    function updateGearIndicator(data) {
      // only update when gear is changed
      if (currentGear !== data.electrics.gear) {
        if(data.powertrain.gearbox.type === "automaticGearbox"){//auto
          for (var key in gauge.gears) {
            var gear = data.electrics.gear.replace("S", "").replace("M", "");
            gauge.gears[key].n.style.display = (key === gear)?"inline":"none";
          }
        }else{//other (manual,seq)
          for (var key in gauge.gears) {
            var gear = (data.electrics.gear == 0)?"N":String(data.electrics.gear);
            gear = (data.electrics.gear == -1)?"R":gear;

            gauge.gears[key].n.style.display = (key === gear)?"inline":"none";
          }
        }
        currentGear = data.electrics.gear;
      }
    }

    function setElec(val, state, key){
      if( val === undefined || val === null){console.error("setElec: svg element not found", key); return;}
      if( state === undefined || state === null){console.error("setElec: state not found", key);val.n.style.display = "none"; return;}
      var cssState = (state===true || state>0.1)?"inline":"none";
      val.n.style.display = cssState;
      //val.n.setAttribute("opacity", (state || state>0.1)?1.0:0.3)
    }

    $window.updateElectrics = (data) => {

      for(var k in electrics.lights){
        setElec(electrics.lights[k], data.electrics[k], k);
      }

      electrics.abs.n.style.display = (data.electrics["abs"]==1) ?"inline":"none";
      if(data.electrics["abs"] === undefined){
        //nope
      }else{
        if( electrics.abs.n.classList.contains("blink") !== (data.electrics["abs"]===1)){
          electrics.abs.n.classList.toggle("blink", data.electrics["abs"]===1);
        }
      }

      //electrics.temp_logo.n.style.display = (data.electrics.watertemp > 110)?"inline":"none";

      //electrics.lights_battery.n.style.display = (data.electrics.engineRunning<0.1)?"inline":"none";

      //const current_time = new Date(Date.now());
      //infoDisplay.hour.text(fixClock(current_time.getHours(), "{"));
      //infoDisplay.min.text(fixClock(current_time.getMinutes()));

    }


    $window.updateData = (data) => {
      if (data) {
        if(!ready){console.log("not ready");return;}
        // console.log(data);

        // Update PRNDS display
        updateGearIndicator(data);
        // Update Speed displays
        //updateSpeedDisplays(data);
        //updateTachoDisplays(data);

        updateElectrics(data);
        updateGagueFuel(data);
        //updateGagueTemp(data);
        //updateOilTemp(data);
        //updateBattery(data);
      }
    }
	
	    $window.setup = (data) => {
      if(!ready){
        console.log("calling setup while svg not fully loaded");
        setTimeout(function(){ $window.setup(data) }, 100);
        return;
      }
	
      console.log("setup",data);
	
    }
    ready = true;
  });