-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt


local M = {}
local clamp = clamp
local spwh3ID
local spwh3
local spww5
local winch_attach
local spwrCid1
local spwrCid2
local spwrCid3
local spwrCid4
local spwrCid5
local spwrStress
local winchRelease
local spwinch_sound
local spwinch_sound_volume
local spwinch_sound_stop
local spwinch_playsound
local spwinch_playsound2

local function init()
  electrics.values.spwinch_hydro = 0
  electrics.values.spwinch_input = 0
  electrics.values.spwinch = 0
  electrics.values.spwinch_attach = 0
  electrics.values.spwinch_freespool = 0
  spwh3ID = "spwh3"
  spww5ID = "spww5"
  winch_attach = false
  spwrStress = 0
  winchRelease = 0
  spwinch_sound_volume = 0
  spwrCid1 = 0
  spwrCid2 = 0
  spwrCid3 = 0
  spwrCid4 = 0
  spwrCid5 = 0
  spwinch_sound_stop = true
  spwinch_playsound = false
  spwinch_playsound2 = true
  for k, node in pairs (v.data.nodes) do
    if node.name == spwh3ID then
      spwh3 = node.cid

      end
    end
  for k, node in pairs (v.data.nodes) do
    if node.name == spww5ID then
      spww5 = node.cid

      end
    end
  --spwinch_sound = obj:createSFXSource2("event:>Engine>Bands>Real>electric_eng_05", "AudioDefaultLoop3D", "spwinch_sound", spww5, spww5) --node, volume

  --obj:cutSFX(spwinch_sound)
end

local function reset()
  electrics.values.spwinch_hydro = 0
  electrics.values.spwinch_input = 0
  electrics.values.spwinch = 0
  electrics.values.spwinch_attach = 0
  electrics.values.spwinch_freespool = 0
  winch_attach = false
  spwrStress = 0
  winchRelease = 0
  spwinch_sound_volume = 0
  spwinch_sound_stop = true
  spwinch_playsound = false
  spwinch_playsound2 = true
end

local function initSounds()
  spwinch_sound = obj:createSFXSource2("event:>Engine>Starter>v8flat_1986_eng", "AudioDefaultLoop3D", "spwinch_sound", spww5, 1) --node, volume
--"event:>Engine>Starter>v6diesel_2011_eng"
end

local function updateGFX(dt) -- ms

  for _, h in pairs(v.data.hydros) do
    if h.name == "spwrr15" then
      spwrCid1 = h.bcid
      if h.name == "spwrr20" then
        spwrCid2 = h.bcid
        if h.name == "spwrr30" then
          spwrCid3 = h.bcid
          if h.name == "spwrr40" then
            spwrCid4 = h.bcid
            if h.name == "spwrr48" then
              spwrCid5 = h.bcid
    end
  end
end
end
end
end



if electrics.values.spwinch_attach > 0 then
  obj:setNodeMass(spwh3, 230)
  guihooks.message("Hook attached!", 0.4, "SP_Winch2")
  winch_attach = true
  
else
  obj:setNodeMass(spwh3, 1.0)
  if winch_attach == true then
    guihooks.message("Hook detached!", 0.4, "SP_Winch2")
  winch_attach = false
end
end

spwrStress = math.max(obj:getBeamStress(spwrCid1), obj:getBeamStress(spwrCid2), obj:getBeamStress(spwrCid3), obj:getBeamStress(spwrCid4), obj:getBeamStress(spwrCid5))
if electrics.values.spwinch_freespool == 1 then
  guihooks.message("Free spool active!", 0.01, "SP_Winch3")
if spwrStress > 1200 then
  winchRelease = 60
else
  winchRelease = 0
end
else
  winchRelease = 0
end

if electrics.values.spwinch_freespool == 1 then
if electrics.values.spwinch_hydro < 0.001 then
  electrics.values.spwinch_hydro = 0.01
end
end

if electrics.values.spwinch > 0 then
  electrics.values.spwinch_freespool = 0
  guihooks.message("Winch length: " .. (math.ceil(electrics.values.spwinch_hydro*100)) .. "%", 0.4, "SP_Winch1")
else if electrics.values.spwinch < 0 then
  electrics.values.spwinch_freespool = 0
  guihooks.message("Winch length: " .. (math.ceil(electrics.values.spwinch_hydro*100)) .. "%", 0.4, "SP_Winch1")
else if winchRelease > 0 then
  guihooks.message("Winch length: " .. (math.ceil(electrics.values.spwinch_hydro*100)) .. "%", 0.4, "SP_Winch1")
end
end
end



if electrics.values.spwinch < 0 then
  if spwrStress > 1000 then
    if spwrStress <= 8000 then
    electrics.values.spwinch = -2
    electrics.values.spwinch_hydro = clamp(electrics.values.spwinch_hydro + winchRelease * dt * 0.01 + electrics.values.spwinch * dt * 0.005 , 0, 1)
    end
  end
if spwrStress > 8000 then
  electrics.values.spwinch = -1
  electrics.values.spwinch_hydro = clamp(electrics.values.spwinch_hydro + winchRelease * dt * 0.01 + electrics.values.spwinch * dt * 0.005 , 0, 1)
end
if spwrStress > 24000 then
  electrics.values.spwinch = 0
  guihooks.message("Winch overloaded!", 0.4, "SP_Winch1")
  electrics.values.spwinch_hydro = clamp(electrics.values.spwinch_hydro + winchRelease * dt * 0.01 + electrics.values.spwinch * dt * 0.005 , 0, 1)
else 
electrics.values.spwinch_hydro = clamp(electrics.values.spwinch_hydro + winchRelease * dt * 0.01 + electrics.values.spwinch * dt * 0.005 , 0, 1)
end
else 
  electrics.values.spwinch_hydro = clamp(electrics.values.spwinch_hydro + winchRelease * dt * 0.01 + electrics.values.spwinch * dt * 0.005 , 0, 1)
end



-- SOUND
if spwinch_sound_volume <= 0 then
  obj:cutSFX(spwinch_sound)
  spwinch_sound_stop = true
  spwinch_sound_volume = 0
  --obj:cutSFX(spwinch_sound)
end
if electrics.values.spwinch ~= 0 then
  if electrics.values.spwinch_hydro > 0 then
    if electrics.values.spwinch_hydro < 1 then

      if spwinch_sound_volume < 0.7 then
        spwinch_sound_volume = spwinch_sound_volume + 0.1
      end
      --obj:playSFX(spwinch_sound)
      spwinch_playsound = true
      spwinch_sound_stop = false
else
  spwinch_playsound = false
  if spwinch_sound_stop ~= true then
    spwinch_sound_volume = spwinch_sound_volume - 0.01
    spwinch_playsound2 = true
  end
end
else
  spwinch_playsound = false
  if spwinch_sound_stop ~= true then
    spwinch_sound_volume = spwinch_sound_volume - 0.01
    spwinch_playsound2 = true
  end
end
else
  spwinch_playsound = false
  if spwinch_sound_stop ~= true then
    spwinch_sound_volume = spwinch_sound_volume - 0.01
    spwinch_playsound2 = true
  end
end
obj:setVolumePitch(spwinch_sound, (spwinch_sound_volume), 0.4)
--obj:setVolumePitch(spwinch_sound, 1, 0.4)

if spwinch_playsound == true then
  if spwinch_playsound2 == true then
    obj:playSFX(spwinch_sound)
    spwinch_playsound2 = false
  end
end

end






-- public interface
M.init    = reset
M.reset   = reset
M.updateGFX = updateGFX
M.init = init
M.initSounds = initSounds
M.resetSounds = resetSounds

return M
