angular.module("beamng.apps").directive("videoPlayerApp", function () {
  return {
    template: [
      '<div class="vp-host">',
      '  <style>',
      '    .vp-host{position:relative;width:100%;height:100%;box-sizing:border-box;',
      '      background:#111;border-radius:8px;overflow:hidden;display:flex;flex-direction:column}',
      '    .vp-video-wrap{position:relative;flex:1;display:flex;align-items:center;justify-content:center;background:#000}',
      '    video.vp-video{max-width:100%;max-height:100%;width:100%;height:100%;object-fit:contain;background:#000}',
      '    .vp-controls{display:flex;align-items:center;gap:8px;padding:8px;background:rgba(20,20,20,.9);color:#e6e6e6}',
      '    .vp-btn{height:28px;min-width:44px;border:0;border-radius:6px;padding:0 10px;background:#2c2f34;color:#e6e6e6;cursor:pointer}',
      '    .vp-select{height:28px;background:#2c2f34;color:#e6e6e6;border:0;border-radius:6px;padding:0 8px}',
      '    .vp-spacer{flex:1}',
      '    .vp-time{font-variant-numeric:tabular-nums;opacity:.8}',
      '    input[type="range"]{vertical-align:middle}',
      '  </style>',
      '  <div class="vp-video-wrap">',
      '    <video class="vp-video" webkit-playsinline playsinline></video>',
      '  </div>',
      '  <div class="vp-controls" ng-mousedown="$event.stopPropagation()" ng-mouseup="$event.stopPropagation()" ng-click="$event.stopPropagation()">',
      '    <button class="vp-btn" ng-click="prev()">Prev</button>',
      '    <button class="vp-btn" ng-click="toggle()">{{playing?"Pause":"Play"}}</button>',
      '    <button class="vp-btn" ng-click="next()">Next</button>',
      '    <select class="vp-select" ng-model="idx" ng-options="i as (playlist[i].title||playlist[i].file) for i in seq" ng-change="load(idx)"></select>',
      '    <span class="vp-spacer"></span>',
      '    <label><input type="checkbox" ng-model="loop" ng-change="applyLoop()"> Loop</label>',
      '    <label style="margin-left:8px">Vol <input type="range" min="0" max="1" step="0.01" ng-model="volume" ng-change="applyVolume()"></label>',
      '    <span class="vp-time">{{timeNow}} / {{timeDur}}</span>',
      '  </div>',
      '</div>'
    ].join(''),
    replace: true,
    restrict: 'EA',
    scope: true,
    link: function (scope, element) {
      var video = element[0].querySelector('video');
      scope.playlist = [];
      scope.seq = [];
      scope.idx = 0;
      scope.playing = false;
      scope.loop = false; // default off
      scope.volume = 1;   // default full volume
      scope.timeNow = '0:00';
      scope.timeDur = '0:00';

      function fmt(t){ t = t||0; var m = Math.floor(t/60); var s = Math.floor(t%60); return m+":"+(s<10?"0":"")+s; }
      function updateTimes(){ scope.$evalAsync(function(){ scope.timeNow = fmt(video.currentTime||0); scope.timeDur = isFinite(video.duration)? fmt(video.duration) : '--:--'; }); }

      scope.applyLoop = function(){ video.loop = !!scope.loop; };
      scope.applyVolume = function(){ try{ video.volume = Math.max(0, Math.min(1, Number(scope.volume)||0)); }catch(e){} };

      scope.toggle = function(){ if(!video.src){ scope.load(scope.idx); return; } if(video.paused){ video.play(); } else { video.pause(); } };
      scope.prev = function(){ if(!scope.playlist.length) return; scope.idx = (scope.idx - 1 + scope.playlist.length) % scope.playlist.length; scope.load(scope.idx, true); };
      scope.next = function(){ if(!scope.playlist.length) return; scope.idx = (scope.idx + 1) % scope.playlist.length; scope.load(scope.idx, true); };

      scope.load = function(i, autoplay){
        if(!scope.playlist.length) return;
        if(i<0||i>=scope.playlist.length) i = 0;
        var item = scope.playlist[i];
        var src = item && item.file ? item.file : '';
        if(!src) return;
        // Resolve relative paths inside this app folder
        if(!/^https?:/i.test(src) && !src.startsWith('/')){
          src = '/ui/modules/apps/videoPlayer/' + src.replace(/^\.\/?/, '');
        }
        video.src = src;
        video.load();
        if(autoplay){ video.play(); }
      };

      // wire events
      video.addEventListener('play', function(){ scope.$evalAsync(function(){ scope.playing = true; }); });
      video.addEventListener('pause', function(){ scope.$evalAsync(function(){ scope.playing = false; }); });
      video.addEventListener('timeupdate', updateTimes);
      video.addEventListener('loadedmetadata', updateTimes);

      // try to fetch playlist.json next to this app
      try {
        var xhr = new XMLHttpRequest();
        xhr.open('GET', '/ui/modules/apps/videoPlayer/playlist.json', true);
        xhr.onreadystatechange = function(){
          if(xhr.readyState === 4){
            try{
              if(xhr.status >= 200 && xhr.status < 300){
                var data = JSON.parse(xhr.responseText||'[]');
                if(Array.isArray(data)){
                  scope.$evalAsync(function(){
                    scope.playlist = data;
                    scope.seq = data.map(function(_,i){ return i; });
                    scope.idx = 0;
                  });
                }
              }
            }catch(e){ /* ignore */ }
          }
        };
        xhr.send();
      } catch(e) {}

      // init defaults
      scope.applyLoop();
      scope.applyVolume();
    }
  };
});