﻿
angular.module("beamng.apps").directive("lowranceNavMap", function () {
  return {
    template: [
      '<div class="lnv-bezel">',
      '<style>',
      '  .lnv-bezel{position:relative;height:100%;width:100%;overflow:hidden;box-sizing:border-box;',
      '    background:rgba(28,30,34,.65);border-radius:8px;box-shadow:inset 0 1px 2px rgba(255,255,255,.06),inset 0 -1px 2px rgba(0,0,0,.35);',
      '    padding:8px 84px 8px 8px;font-family:Segoe UI,Roboto,Arial,sans-serif}',
      '  .lnv-logo{position:absolute;top:6px;left:50%;transform:translateX(-50%);color:#fff;font-weight:900;letter-spacing:2px;font-size:14px;text-shadow:0 1px 1px rgba(0,0,0,.6)}',
      '  .lnv-side{position:absolute;right:10px;top:28px;bottom:16px;width:var(--sideW,70px);display:flex;flex-direction:column;align-items:center;gap:10px;',
      '    transform-origin:top right;transform:scale(var(--scale,1));}',
      '  .lnv-circle{width:44px;height:44px;border-radius:50%;border:1px solid #2c2f34;cursor:pointer;color:#e7e9ee;font-weight:700;',
      '    background:linear-gradient(#606369,#3d4046);box-shadow:inset 0 2px 3px rgba(255,255,255,.08),inset 0 -2px 2px rgba(0,0,0,.35),0 3px 6px rgba(0,0,0,.45)}',
      '  .lnv-rect{min-width:64px;height:28px;border-radius:6px;border:1px solid #2c2f34;background:linear-gradient(#5a5d63,#3a3d43);color:#e7e9ee;font-weight:700;cursor:pointer;',
      '    box-shadow:inset 0 1px 2px rgba(255,255,255,.08),inset 0 -1px 2px rgba(0,0,0,.35),0 2px 4px rgba(0,0,0,.35)}',
      '  .lnv-screen{position:absolute;inset:8px var(--sideInset,80px) 8px 8px;border-radius:8px;background:#2b2f35;box-shadow:inset 0 2px 8px rgba(0,0,0,.55),inset 0 0 0 1px #1c1f24;overflow:hidden}',
      '  .lnv-topbar{display:none}',
      '  .lnv-leftstats{position:absolute;left:10px;top:8px;display:flex;flex-direction:column;gap:10px;pointer-events:none;z-index:3}',
      '  .lnv-leftstats .stat{min-width:110px}',
      '  .lnv-leftstats .row{display:flex;align-items:baseline;justify-content:flex-start;gap:6px;color:#111;font-weight:800;font-size:12px;letter-spacing:.4px}',
      '  .lnv-leftstats .big{font-weight:900;color:#000;font-size:28px;line-height:1;margin-top:2px;letter-spacing:0.2px}',
      '  .lnv-leftstats .muted{color:#333;font-weight:700;font-size:11px}',
      '  .lnv-rec{width:10px;height:10px;border-radius:50%;background:#ff3b30;display:inline-block;margin-right:6px;box-shadow:0 0 6px rgba(255,59,48,.8)}',
      '  .lnv-map-host{position:absolute;inset:0;z-index:1;cursor:grab}',
      '  .lnv-dragging .lnv-map-host{cursor:grabbing}',
      '  /* slide-out menu */',
      '  .lnv-menu-wrap{position:absolute;inset:0;z-index:4;pointer-events:none}',
      '  .lnv-menu-dim{position:absolute;inset:0;background:rgba(0,0,0,.4);opacity:0;transition:opacity .15s ease;pointer-events:auto;z-index:1}',
      '  .lnv-menu{position:absolute;top:0;right:0;height:100%;width:240px;background:rgba(24,26,30,.96);box-shadow: -8px 0 18px rgba(0,0,0,.4);transform:translateX(100%);transition:transform .2s ease;pointer-events:auto;display:flex;flex-direction:column;z-index:5;border-top-left-radius:10px;border-bottom-left-radius:10px;overflow:auto;-webkit-overflow-scrolling:touch;overscroll-behavior:contain}',
      '  .lnv-menu.open ~ .lnv-menu-dim{opacity:1;pointer-events:auto}',
      '  .lnv-menu.open{transform:translateX(0)}',
      '  .lnv-menu .hdr{color:#e6e6e6;font-weight:800;letter-spacing:.8px;padding:10px 12px;border-bottom:1px solid rgba(255,255,255,.06)}',
      '  .lnv-menu .grp{padding:8px 0;border-bottom:1px solid rgba(255,255,255,.06)}',
      '  .lnv-menu .title{color:#9fb1c1;font-weight:800;font-size:12px;padding:0 12px 6px}',
      '  .lnv-menu .row{display:flex;align-items:center;gap:8px;padding:6px 12px;color:#e6e6e6}',
      '  .lnv-menu .row input[type="text"]{flex:1;height:26px;border:0;border-radius:4px;padding:0 8px;color:#eee;background:#2b2f35}',
      '  .lnv-menu .btn{height:28px;min-width:64px;border:0;border-radius:6px;padding:0 10px;background:linear-gradient(#5a5d63,#3a3d43);color:#e7e9ee;font-weight:800;cursor:pointer}',
      '  .lnv-menu .list{max-height:180px;overflow:auto}',
      '  .lnv-menu input[type="color"]{cursor:pointer;position:relative;z-index:10}',
      '  .lnv-menu .item{padding:8px 12px;color:#e6e6e6;cursor:pointer}',
      '  .lnv-menu .swatch{width:18px;height:18px;border-radius:3px;border:1px solid #222;display:inline-block}',
      '  .lnv-menu .mini{height:26px;min-width:48px}',
      '  .lnv-menu .item:hover{background:rgba(255,255,255,.08)}',
      '  .lnv-menu .foot{margin-top:auto;padding:10px 12px;display:flex;gap:10px;justify-content:flex-end}',
      '  .lnv-bottom{position:absolute;left:0;right:0;bottom:4px;text-align:right;color:#aab2bd;font-size:11px;padding:0 8px;pointer-events:none}',
      '  /* WPT picker tiles */',
      '  .lnv-wpt-tiles{display:grid;grid-template-columns:repeat(auto-fill,minmax(56px,1fr));gap:8px;max-height:150px;overflow-y:auto;overflow-x:hidden;padding:4px}',
      '  .lnv-wpt-tile{border-radius:8px;padding:8px;display:flex;flex-direction:column;align-items:center;justify-content:center;cursor:pointer;min-width:0;box-sizing:border-box;',
      '     transition:all .12s;border:1px solid #222;background:rgba(0,0,0,.25)}',
      '  .lnv-wpt-tile img{width:32px;height:32px;display:block;object-fit:contain}',
      '  .lnv-wpt-tile .cap{color:#aaa;font-size:10px;margin-top:6px;text-align:center;max-width:100%;white-space:nowrap;overflow:hidden;text-overflow:ellipsis}',
      '  .lnv-wpt-tile.selected{border-color:#fff;box-shadow:0 0 0 2px rgba(255,255,255,.15)}',
      '</style>',
      '  <div class="lnv-logo">LOWRANCE</div>',
      '  <div class="lnv-screen">',
      '    <div class="lnv-wpt-pop" ng-show="wptPickerOpen" ng-click="$event.stopPropagation()" style="position:absolute;right:96px;top:60px;width:260px;background:rgba(24,26,30,.96);border-radius:10px;box-shadow:0 10px 22px rgba(0,0,0,.55);padding:10px;z-index:6">',
      '      <div style="color:#9fb1c1;font-weight:800;font-size:12px;padding:2px 0 6px">New Waypoint</div>',
      '      <input type="text" class="md-input" placeholder="Label" ng-model="wptLabel" style="width:100%;height:26px;border:0;border-radius:4px;padding:0 8px;color:#eee;background:#2b2f35;margin-bottom:8px">',
      '      <div style="color:#9fb1c1;font-weight:800;font-size:12px;padding:2px 0 6px">Icon</div>',
      '      <div class="lnv-wpt-tiles">',
      '        <div class="lnv-wpt-tile" ng-repeat="ico in availableIcons" ng-click="pickWptIcon(ico)" ng-class="{selected: wptIcon===ico}">',
      '          <img ng-src="{{iconUrl(ico)}}"/>',
      '          <div class="cap">{{(ico||" ").replace("lowrace_icon_"," ").replace(".svg","")}}</div>',
      '        </div>',
      '      </div>',
      '      <div style="color:#9fb1c1;font-size:11px;margin-top:8px">Press WPT to confirm</div>',
      '    </div>',
      '    <div class="lnv-leftstats">',
      '      <div class="stat">',
      '        <div class="row"><span><span class="lnv-rec" ng-show="recBtn===\'Stop\'"></span></span><span class="muted">mph</span></div>',
      '        <div class="big">{{mph | number:1}}</div>',
      '      </div>',
      '      <div class="stat">',
      '        <div class="row"><span>MAX</span><span class="muted">mph</span></div>',
      '        <div class="big">{{maxMph | number:1}}</div>',
      '      </div>',
      '      <div class="stat">',
      '        <div class="row"><span>TRIP</span><span class="muted">mi</span></div>',
      '        <div class="big">{{trailMiles | number:1}}</div>',
      '      </div>',
      '    </div>',
      '    <div id="lnv-map" class="lnv-map-host"></div>',
      '    <div class="lnv-menu-wrap" ng-show="menuOpen">',
      '      <div class="lnv-menu open" ng-click="$event.stopPropagation()">',
      '        <div class="hdr">MENU</div>',
      '        <div class="grp">',
      '          <div class="title">Routes</div>',
      '          <div class="row"><button class="btn" style="min-width:90px" ng-click="loadSelected($event)">Load</button><button class="btn" style="min-width:80px;margin-left:8px" ng-click="clearAllRoutes($event)">Clear</button></div>',
      '          <div class="row">',
      '            <button id="lnv-dd-inmenu" class="btn" ng-click="openMenu($event)" style="flex:1;display:flex;align-items:center;justify-content:space-between">',
      '              <span>{{selectedRoute || "Select route"}}</span>',
      '              <span style="opacity:.8">v</span>',
      '            </button>',
      '            <button class="btn mini" style="margin-left:8px" ng-disabled="!selectedRoute" ng-click="deleteRoute(selectedRoute)">Del</button>',
      '          </div>',
      '        </div>',
      // insert Route Name section above Recording
      '        <div class="grp">',
      '          <div class="title">Route Name</div>',
      '          <div class="row"><input type="text" placeholder="Route name" ng-model="routeName"/></div>',
      '        </div>',
      '        <div class="grp">',
      '          <div class="title">Recording</div>',
      '          <div class="row" style="gap:10px"><button class="btn" style="min-width:90px" ng-click="startNewRoute($event)">Start</button><button class="btn" style="min-width:90px" ng-click="stopRoute($event)">Stop</button></div>',
      '          <div class="row"><span style="color:#e6e6e6;margin-right:8px">Color:</span>',
      '            <span ng-repeat="c in palette" ',
      '                  ng-click="pickNewColor(c)" ',
      '                  title="{{c}}" ',
      '                  style="width:18px;height:18px;border-radius:3px;border:1px solid #222;display:inline-block;cursor:pointer;margin-right:6px;box-shadow:0 0 0 2px {{newRouteColor===c?\'#fff\':\'transparent\'}} inset;background:{{c}}"></span>',
      '          </div>',
      '        </div>',
      '        <div class="grp">',
      '          <div class="title">Settings</div>',
      '          <div class="row"><label style="color:#e6e6e6;width:100%">Map Opacity <input type="range" min="0.2" max="1" step="0.05" ng-model="opacity" ng-change="applyOpacity()" style="float:right; width:120px"></label></div>',
      '          <div class="row" style="justify-content:space-between"><span style="color:#e6e6e6">Max speed: {{maxMph | number:0}} mph</span><button class="btn mini" ng-click="clearMax($event)" title="Reset max airspeed">Clear Max</button></div>',
      '          <div class="row" style="align-items:center;gap:8px">',
      '            <span style="color:#e6e6e6">Waypoint hotkey: <span style="color:#9fb1c1">{{wptBindingLabel || "none"}}</span></span>',
      '            <span style="margin-left:auto"></span>',
      '            <button class="btn mini" ng-click="startBind($event)">Bind</button>',
      '            <button class="btn mini" ng-click="clearBind($event)" style="margin-left:6px">Clear</button>',
      '          </div>',
      '        </div>',
      '        <div class="foot"><button class="btn" ng-click="menuOpen=false">Close</button><button class="btn" ng-click="loadSelected($event)">Enter</button></div>',
      '      </div>',
      '      <div class="lnv-menu-dim" ng-click="menuOpen=false"></div>',
      '    </div>',
      '    <div class="lnv-bottom">MADE BY BEAMG BAJA CREW</div>',
      '  </div>',
      '  <div class="lnv-side"',
      '    ng-mousedown="$event.stopPropagation()" ng-mouseup="$event.stopPropagation()" ng-click="$event.stopPropagation()" ng-wheel="$event.stopPropagation()" ng-contextmenu="$event.stopPropagation()">',
      '    <button class="lnv-circle" ng-click="zoomIn($event)">+</button>',
      '    <button class="lnv-circle" ng-click="zoomOut($event)">-</button>',
      '    <button class="lnv-circle" ng-click="toggleNorth($event)">{{northUp ? "N" : "H"}}</button>',
      '    <button class="lnv-circle" title="Center on vehicle" ng-click="centerOnVehicle($event)">&#9673;</button>',
      '    <button class="lnv-rect" ng-click="addWpt($event)">WPT</button>',
      '    <button class="lnv-rect" ng-click="menuOpen=true">MENU</button>',
      '    <input ng-model="wptLabel" placeholder="WPT label" style="width:64px;height:26px;border:0;border-radius:5px;padding:0 6px;outline:none;color:#eee;background:rgba(0,0,0,.35);margin-top:-2px;display:none"/>',
      '    <button class="lnv-rect" ng-click="toggleRec($event)" style="display:none">{{recBtn}}</button>',
      '    <input ng-model="routeName" placeholder="route" style="width:64px;height:26px;border:0;border-radius:5px;padding:0 6px;outline:none;color:#eee;background:rgba(0,0,0,.35);display:none"/>',
      '    <button class="lnv-rect" ng-click="saveNamed($event)" style="display:none">SAVE</button>',
      '    ',
      '    ',
      '    <label style="display:none;color:#e6e6e6;font-size:12px;margin-top:4px">Opacity <input type="range" min="0.2" max="1" step="0.05" ng-model="opacity" ng-change="applyOpacity()" style="vertical-align:middle;width:64px;margin-left:6px"></label>',
      '',
      '    <label style="display:none;color:#e6e6e6;font-size:12px;"><input type="checkbox" ng-model="showRoute" ng-change="applyVisibility()"> Route</label>',
      '  </div>',
      '</div>'
    ].join(''),
    replace: true,
    restrict: 'EA',
    scope: true,
    link: function (scope, element) {
      // state
      scope.routes = [];
      scope.selectedRoute = "";
      scope.routeName = "";
      scope.recBtn = "Record";
      scope.wptLabel = "";
      scope.wptPickerOpen = false;
      let pendingWptPos = null; // capture position at first WPT press
      // Default selected waypoint icon. If the icon list hasn't arrived yet,
      // fall back to a known bundled icon so confirming a WPT still shows up.
      scope.wptIcon = '';
      scope.availableIcons = [];
      scope.iconsBase = '/ui/modules/apps/lowranceNav/mikeslowranceicons/';
      try { scope.wptIcon = localStorage.getItem('lnvWptIcon')||''; } catch(_){}
      scope.iconUrl = function(name){ return (scope.iconsBase||'') + name; };
      scope.pickWptIcon = function(name){ scope.wptIcon = name; try { localStorage.setItem('lnvWptIcon', name||''); } catch(_){} try { console.log('[lowranceNav] picked icon', name); } catch(_){} };
      function defaultIcon(){
        try {
          if (scope.availableIcons && scope.availableIcons.length) return scope.availableIcons[0];
          // Fallback to a bundled icon name that exists in this mod
          return 'lowrace_icon_checkpoint.svg';
        } catch(_) { return 'lowrace_icon_checkpoint.svg'; }
      }
      scope.$on('lowranceGPS.iconsList', function(_, d){
        scope.$evalAsync(function(){
          scope.availableIcons = (d && d.icons) || [];
          if (d && d.base) scope.iconsBase = d.base;
          // materialize defs entries so we can reference them by id
          try {
            if (typeof defsRef !== 'undefined' && defsRef) {
              for (var i=0;i<scope.availableIcons.length;i++){
                var n = scope.availableIcons[i];
                var id = 'wptIcon:'+n;
                if (!svg.querySelector('#'+id.replace(/(:|\.|\[|\]|,)/g,'\\$1'))) {
                  var img = document.createElementNS('http://www.w3.org/2000/svg','image');
                  img.setAttribute('id', id);
                  img.setAttribute('width','24'); img.setAttribute('height','24');
                  img.setAttribute('x','-12'); img.setAttribute('y','-12');
                  var url = scope.iconUrl(n);
                  try { img.setAttributeNS('http://www.w3.org/1999/xlink','href', url); } catch(_){}
                  try { img.setAttribute('href', url); } catch(_){}
                  defsRef.appendChild(img);
                }
              }
            }
          } catch(_){}
          // default selection to last used or first available
          if (!scope.wptIcon || scope.availableIcons.indexOf(scope.wptIcon) === -1) {
            try { var last = localStorage.getItem('lnvWptIcon')||''; } catch(_) { last=''; }
            scope.wptIcon = last && scope.availableIcons.indexOf(last) !== -1 ? last : (scope.availableIcons[0]||defaultIcon());
          }
          rebuildIconsOverlay();
        });
      });
      
      scope.airspeed = 0;
      scope.maxAirspeed = 0;
      scope.mph = 0;
      scope.maxMph = 0;
      scope.showRoute = true;
      scope.opacity = 1;
      // Default to heading-up (rotating map). User can toggle to North-up.
      scope.northUp = false;
      // Keep centering on player vehicle even when freecam is active
      scope.followVehicle = true;
      scope.wptClicks = 0;
      scope.menuOpen = false;
      scope.currentMap = '';
      scope.routeColors = {};
      scope.thinPrimary = true;
      scope.hideDuringRec = false;
      scope.recordingName = '';
      scope.palette = ['#4AA3FF','#FFD200','#FD6A00','#00D084','#FF4D4D','#9B59B6'];
      scope.newRouteColor = scope.palette[0];
      // Trip distance (miles) of the current/recorded trail
      scope.trailMiles = 0;
      const M_PER_MI = 1609.344;
      function flatMiles(flat){
        try {
          if (!flat || flat.length < 4) return 0;
          let d = 0; let x1 = flat[0]||0, y1 = flat[1]||0;
          for (let i=2;i<flat.length;i+=2){ const x2 = flat[i]||0, y2 = flat[i+1]||0; const dx = x2-x1, dy = y2-y1; d += Math.sqrt(dx*dx + dy*dy); x1 = x2; y1 = y2; }
          return d / M_PER_MI;
        } catch(_) { return 0; }
      }
      function setTrailMilesFrom(flat){
        try { const mi = flatMiles(flat||[]); scope.$evalAsync(function(){ scope.trailMiles = mi; }); } catch(_){}
      }
      // When picking a color while recording, immediately recolor the active trail
      scope.pickNewColor = function(c){
        scope.newRouteColor = c;
        // If a recording is in progress, bind the color to this route name
        if (scope.recordingName) {
          try {
            scope.routeColors[scope.recordingName] = c;
            // persist so subsequent updates use the same color
            localStorage.setItem('lnvRouteColors', JSON.stringify(scope.routeColors));
          } catch(_){}
          // Repaint the currently drawn primary trail with the new color (stock route)
          try {
            const flat = (typeof routeCache !== 'undefined' && routeCache[scope.recordingName]) || [];
            if (typeof nav !== 'undefined' && flat && flat.length) {
              nav.setRoute({ markers: densifyFlat(flat, 0.6), color: withAlpha(c) });
            }
          } catch(_){}
        }
      };

      function ext(s){ bngApi.engineLua(s); }
      function stop(e){ if(e){ e.stopPropagation(); e.preventDefault(); } }

      const root = element[0];
      const host = root.querySelector('#lnv-map');
      const screenEl = root.querySelector('.lnv-screen');

      // container and defs svg
      const cont = document.createElement('div');
      cont.id = 'lnv-container-' + (Math.random()*1e9|0);
      cont.style.position = 'absolute';
      cont.style.inset = '0';
      host.appendChild(cont);

      const svg = document.createElementNS('http://www.w3.org/2000/svg','svg');
      svg.setAttribute('width','100%');
      svg.setAttribute('height','100%');
      svg.style.position = 'absolute';
      svg.style.left = '0';
      svg.style.top  = '0';
      svg.style.pointerEvents = 'none';
      svg.style.zIndex = '9999';
      cont.appendChild(svg);

      // Waypoint icon overlay layer
      const iconsLayer = document.createElementNS('http://www.w3.org/2000/svg','g');
      iconsLayer.setAttribute('id','wpt-icons');
      iconsLayer.style.pointerEvents = 'none';
      svg.appendChild(iconsLayer);

      let defsRef = null;
      (function(){
        try {
          const defs = document.createElementNS('http://www.w3.org/2000/svg','defs');
          defs.setAttribute('id','lnv-defs');
          const vimg  = document.createElementNS('http://www.w3.org/2000/svg','image');
          vimg.setAttribute('id','vehicleMarker');
          // Smaller marker so it doesn't dominate the screen
          vimg.setAttribute('width','24');
          vimg.setAttribute('height','24');
          vimg.setAttribute('x','-12');
          vimg.setAttribute('y','-12');
          // Prefer the app-local asset (shipped with this mod). Some game versions
          // require the non-namespaced 'href' attribute as well as xlink:href.
          const markerUrl = '/ui/modules/apps/lowranceNav/vehicleMarker.svg';
          vimg.setAttributeNS('http://www.w3.org/1999/xlink','href', markerUrl);
          try { vimg.setAttribute('href', markerUrl); } catch(_){}
          defs.appendChild(vimg);
          svg.appendChild(defs);
          defsRef = defs;
        } catch(_){}
      })();

      // north pointer
      const northEl = document.createElement('div');
      northEl.id = 'lnv-north-' + (Math.random()*1e9|0);
      northEl.style.position = 'absolute';
      northEl.style.left = '12px';
      northEl.style.top  = '12px';
      host.appendChild(northEl);

      // navigator
      let nav, opts;
      function initNav() {
        // pick a safe vehicle marker source: in-document element if present, else URL fallback
        let vehicleMarkerSrc = '#vehicleMarker';
        try { if (!document.querySelector('#vehicleMarker')) vehicleMarkerSrc = '/ui/modules/apps/lowranceNav/vehicleMarker.svg'; } catch(_){}
        const base = {
          root, container: cont, north: northEl,
          // Lowrance-like chart colors (beige land + white roads)
          backgroundRgb: [203, 187, 120],
          roadColors: ["#FFFFFFFF","#E6E6E6FF","#B5B5B5FF"],
          markers: true,
          markerColor: '#FFD200',
          vehicles: true,
          // Use in-document marker when available; otherwise fallback to URL
          vehicleMarker: vehicleMarkerSrc,
          vehicleColor: '#00B0FF',
          cameraColor: '#00000000',
          // Disable native thick route; we draw our own colored overlay
          routes: true,
          rotate: !scope.northUp, scale: 0.8, speedZoom: true, speedZoomIncrements: 1, speedZoomMultiplier: 2,
          offsetX: 0, offsetY: 0, speedOffset: 0, pitch: 0, speedPitch: 30
        };
        try { nav = new bngNavigator(base); }
        catch (_) { base.container = '#'+cont.id; base.north = '#'+northEl.id; nav = new bngNavigator(base); }
        opts = (nav.getOptions && nav.getOptions()) || { scale: base.scale, rotate: base.rotate };
        // expose opts for topbar binding
        scope.$evalAsync(function(){ scope.opts = opts; });
        // Ensure layering: try to push vehicle layer above route/markers
        try {
          const L = (nav && nav.layers) ? nav.layers : {};
          Object.keys(L||{}).forEach(function(key){
            const layer = L[key]; if (!layer) return;
            const canvas = layer.vcanvas || layer.rcanvas || layer.canvas;
            if (!canvas || !canvas.style) return;
            if (/route/i.test(key)) canvas.style.zIndex = '2';
            else if (/marker/i.test(key)) canvas.style.zIndex = '3';
            else if (/vehicle|player/i.test(key)) canvas.style.zIndex = '6';
          });
        } catch(_){}

        // Scale vehicle marker with zoom by resizing the in-document SVG.
        // This keeps the icon proportional to map zoom.
        const vimgEl = svg.querySelector('#vehicleMarker');
        function applyVehicleSizeFor(scale){
          try {
            const s = Math.max(0.2, Math.min(3.5, Number(scale)||1));
            // Invert vs zoom: smaller icon when zoomed in, larger when zoomed out
            const target = 26 / s; // ~26px at scale=1
            const px = Math.round(Math.max(14, Math.min(36, target))); // clamp
            const half = Math.round(px/2);
            if (vimgEl) {
              vimgEl.setAttribute('width', String(px));
              vimgEl.setAttribute('height', String(px));
              vimgEl.setAttribute('x', String(-half));
              vimgEl.setAttribute('y', String(-half));
            }
          } catch(_){}
        }
        let __lnv_lastScale = -1;
        function tickVehicleSize(){
          try {
            const o = (nav && nav.getOptions) ? nav.getOptions() : opts;
            const sc = (o && o.scale) ? o.scale : 1;
            if (Math.abs(sc - __lnv_lastScale) > 0.01) { __lnv_lastScale = sc; applyVehicleSizeFor(sc); }
          } catch(_){}
        }
        applyVehicleSizeFor(opts.scale || 1);
        const __lnv_sizeTimer = setInterval(tickVehicleSize, 200);
        scope.$on('$destroy', function(){ try { clearInterval(__lnv_sizeTimer); } catch(_){} });
        // Note: we avoid forcing a URL vehicleMarker here so that the
        // in-document '#vehicleMarker' element (with explicit sizing) is respected.
        // Use stock BeamNG route drawing. Do not override setRoute.
        try {
          if (nav && nav.layers && nav.layers.route && nav.layers.route.rcanvas) {
            nav.layers.route.rcanvas.style.display = '';
            nav.layers.route.rcanvas.style.pointerEvents = 'none';
          }
          // Ensure markers canvas is visible for image markers
          if (nav && nav.layers && nav.layers.markers && nav.layers.markers.rcanvas) {
            nav.layers.markers.rcanvas.style.display = '';
            nav.layers.markers.rcanvas.style.pointerEvents = 'none';
            // bring markers above route
            nav.layers.markers.rcanvas.style.zIndex = '5';
          }
        } catch(_){}
      }
      // build initial navigator
      initNav();

      // Helper to fully rebuild navigator when maps change (clears old tiles/cache)
      function reinitNavigator(){
        try { if (nav && nav.setRoute) nav.setRoute([]); } catch(_){ }
        try { cont.innerHTML = ''; } catch(_){ }
        try { initNav(); } catch(_){ }
        // ensure our SVG overlays are re-attached above the navigator canvases
        try { cont.appendChild(svg); } catch(_){ }
        try { syncIconsTransform(); } catch(_){ }
        try { rebuildIconsOverlay(); } catch(_){ }
      }

      // player position for WPT drops
      let lastPos = { x: 0, y: 0 };

      // base + user pan offsets
      let baseOffsetX = 0, baseOffsetY = 0; // recomputed on resize
      let panX = 0, panY = 0;               // user-controlled pan (drag)

      function applyPan(){ try { nav.setOptions({ offsetX: baseOffsetX + panX, offsetY: baseOffsetY + panY }); } catch(_){} }

      function updateOffsets(){
        const r = host.getBoundingClientRect();
        baseOffsetX = r.width * 0.5;
        baseOffsetY = r.height * 0.5;
        try { nav.setOptions({ speedOffset: 0 }); } catch(_){}
        applyPan();
      }
      scope.$on('app:resized', function(){ computeScale(); updateOffsets(); try { syncIconsTransform(); } catch(_){} try { rebuildIconsOverlay(); } catch(_){} });
      setTimeout(function(){ computeScale(); updateOffsets(); }, 0);

      // responsive UI scale (keeps side buttons usable on small widgets)
      function computeScale(){
        try {
          const r = root.getBoundingClientRect();
          const basePad = 560; // approximate full height of side stack at scale=1
          const s = Math.max(0.55, Math.min(1, (r.height-16)/basePad));
          const sideW = Math.round(70*s);
          root.style.setProperty('--scale', s);
          root.style.setProperty('--sideW', sideW+'px');
          root.style.setProperty('--sideInset', (8 + sideW + 10)+'px');
        } catch(_){}
      }

      // mouse drag panning (Google Maps-style)
      let dragging = false; let startX = 0, startY = 0, startPanX = 0, startPanY = 0;
      function onMove(ev){ if(!dragging) return; const dx = ev.clientX - startX; const dy = ev.clientY - startY; panX = startPanX + dx; panY = startPanY + dy; applyPan(); ev.preventDefault(); }
      function onUp(ev){ if(!dragging) return; dragging=false; root.classList.remove('lnv-dragging'); document.removeEventListener('mousemove', onMove, true); document.removeEventListener('mouseup', onUp, true); ev.preventDefault(); }
      host.addEventListener('mousedown', function(ev){ if(ev.button!==0) return; dragging=true; startX=ev.clientX; startY=ev.clientY; startPanX=panX; startPanY=panY; root.classList.add('lnv-dragging'); document.addEventListener('mousemove', onMove, true); document.addEventListener('mouseup', onUp, true); ev.preventDefault(); ev.stopPropagation(); }, true);

      // stock map stream
      scope.$on('NavigationMap', function(_, d){ if (d) try { nav.setData(d); } catch(_) { nav.setData(d); } });
      scope.$on('NavigationMapUpdate', function(_, d){
        if (!d) return;
        if (d.controlID && d.objects) {
          const o = d.objects[d.controlID];
          if (o) {
            lastPos.x = o.pos[0];
            lastPos.y = o.pos[1];
            // Do not bind center/rotation to camera when in freecam; HUD event will drive it
            // We still allow speed for internal calculations if needed
            // If not following vehicle (legacy behavior), update from stream but do NOT feed speed
            // apply global heading offset (clockwise)
            const HEADING_OFFSET = 90; // degrees to the right
            try { if (!scope.followVehicle) nav.updateData({ x:o.pos[0], y:o.pos[1], rotation:o.rot + 180 + HEADING_OFFSET }); } catch(e){}
            // Do not derive MPH from camera stream; HUD event provides vehicle airspeed
            // Build our own live trail independent of engine ground markers
            try {
              // Only build local trail while recording and not suppressed
              if (scope.recBtn === 'Stop' && !trailSuppressed) {
                if (!window.__lnv_lastTrailPt) window.__lnv_lastTrailPt = {x: lastPos.x, y: lastPos.y};
                const dx = lastPos.x - window.__lnv_lastTrailPt.x;
                const dy = lastPos.y - window.__lnv_lastTrailPt.y;
                if ((dx*dx + dy*dy) > 1) { // ~1m threshold
                  if (!window.__lnv_liveTrailFlat) window.__lnv_liveTrailFlat = [];
                  window.__lnv_liveTrailFlat.push(lastPos.x, lastPos.y);
                  // keep last ~400 pts (200 segments)
                  if (window.__lnv_liveTrailFlat.length > 400) window.__lnv_liveTrailFlat.splice(0, window.__lnv_liveTrailFlat.length - 400);
                  window.__lnv_lastTrailPt = {x:lastPos.x, y:lastPos.y};
                }
              }
            } catch(_){ }
          }
        }
        try { nav.setData(d); } catch(_) { nav.setData(d); }
        try { syncIconsTransform(); } catch(_){}
        // Reapply live trail while recording using stock route layer
        if (scope.recBtn === 'Stop' && !trailSuppressed) {
          drawLiveTrail();
          // Intentionally avoid updating trip miles here while recording; rely on full route updates.
        }
        renderFeed();
        renderLocal();
        renderWptOverlays();
      });

      // local + feed markers using setMarkers({ key, items })
      let localWpts = [];
      let feedWpts  = [];
      let wptCache  = Object.create(null);  // name -> flat items for 'wpts:<name>'
      let routeCache = Object.create(null);       // name -> flat [x1,y1,...]
      scope.activeRoutes = Object.create(null);   // name -> boolean (extra overlays)
      let primaryRouteName = '';
      let pendingFetchName = '';
      let pendingPrimaryReapply = '';

      function toItems(list){ var items=[]; for(var i=0;i<list.length;i++){ var p=list[i]; var x=(p&&p.x!=null)?p.x:(Array.isArray(p)?p[0]:0); var y=(p&&p.y!=null)?p.y:(Array.isArray(p)?p[1]:0); items.push(x, y, 0, 0); } return items; }
      function toItemsSized(list, size){ var items=[]; var sz = size||14; for(var i=0;i<list.length;i++){ var p=list[i]; var x=(p&&p.x!=null)?p.x:(Array.isArray(p)?p[0]:0); var y=(p&&p.y!=null)?p.y:(Array.isArray(p)?p[1]:0); items.push(x, y, sz, 0); } return items; }
      function groupByIcon(list){ var m={}; for(var i=0;i<list.length;i++){ var p=list[i]||{}; var key=(p.icon||''); (m[key]||(m[key]=[])).push(p); } return m; }
      function renderGrouped(baseKey, list){ try {
        // Do not draw any engine markers here; rely on NavigationStaticMarkers
        // to render the chosen SVG icons. We only clear our legacy layers.
        try { nav.setMarkers({ key: baseKey, items: [] }); } catch(_){ }
      } catch(e){} }
      function renderLocal(){ renderGrouped('local', localWpts); }
      function renderFeed(){  renderGrouped('feed',  feedWpts); }

      function applyWpts(d){
        try {
          const src = (d && d.markers) ? d.markers : (Array.isArray(d) ? d : []);
          const pts=[]; for(let i=0;i<src.length;i++){ const p=src[i]; if(!p) continue; if(Array.isArray(p)) pts.push({x:p[0],y:p[1],icon:p.icon||''}); else if(typeof p.x==='number') pts.push({x:p.x,y:p.y,icon:p.icon||''}); }
          feedWpts = pts; localWpts = [];
        } catch(_){ feedWpts = []; }
        renderFeed(); renderLocal();
      }

      function applyRoute(d){
  if (!scope.showRoute) { try { nav.setRoute([]); } catch(_){} return; }
  const flat = toFlat(d);
  const dense = densifyFlat(flat, 0.6);
  const routeName = scope.recordingName || scope.selectedRoute || primaryRouteName || '';
  const col = (scope.routeColors && scope.routeColors[routeName]) || (scope.recordingName ? scope.newRouteColor : '#4AA3FF');
  try {
    nav.setRoute({ markers: dense, color: withAlpha(col) });
  } catch(_){}
  // update trip miles for any route we draw as primary
  setTrailMilesFrom(flat);
  renderFeed(); renderLocal();
 }

      function toFlat(d){ if(!d) return []; if(Array.isArray(d)) return d; if (d.markers && Array.isArray(d.markers)) return d.markers; return []; }
      function withAlpha(hex){ try { if(!hex) return '#4AA3FFFF'; if(hex.length===7) return hex+'FF'; if(hex.length===9) return hex; } catch(_){} return '#4AA3FFFF'; }
      function flatToItems(flat){
        var out=[];
        // Use a smaller size for a thinner, cleaner line
        var sz = scope.thinPrimary ? 0.6 : 1.0;
        for (var i=0;i<flat.length;i+=2) {
          out.push(flat[i]||0, flat[i+1]||0, sz, 0);
        }
        return out;
      }
      function flatToItemsSized(flat, size){ var out=[]; var sz=size||1; for(var i=0;i<flat.length;i+=2){ out.push(flat[i]||0, flat[i+1]||0, sz, 0); } return out; }
      function densifyFlat(flat, step){
        // Insert intermediate points between consecutive samples to create a continuous stroke
        var s = Math.max(0.25, step || 0.6);
        var out=[]; if (!flat || flat.length < 4) return flat || [];
        var x1 = flat[0], y1 = flat[1]; out.push(x1, y1);
        for (var i=2;i<flat.length;i+=2){
          var x2 = flat[i], y2 = flat[i+1];
          var dx = x2 - x1, dy = y2 - y1; var dist = Math.sqrt(dx*dx + dy*dy);
          if (dist > 0) {
            var n = Math.floor(dist / s);
            for (var k=1; k<n; k++) {
              var t = k / n; out.push(x1 + dx*t, y1 + dy*t);
            }
          }
          out.push(x2, y2); x1 = x2; y1 = y2;
        }
        return out;
      }

      function renderActiveRoutes(){
        try {
          Object.keys(scope.activeRoutes||{}).forEach(function(name){
            const on = !!scope.activeRoutes[name];
            const key = 'route:'+name;
            if (!on) { try { nav.setMarkers({ key, items: [] }); } catch(_){} return; }
            const flat = routeCache[name] || [];
            // draw as dense markers to approximate a path; muted gray-blue
            const items = flatToItems(flat);
            const color = (scope.routeColors && scope.routeColors[name]) || '#4AA3FF';
            nav.setMarkers({ key, items, color: color });
          });
          // ensure WPT layers are on top after drawing routes
          renderWptOverlays();
        } catch(_){}
      }

      function renderWptOverlays(){ renderFeed(); renderLocal(); rebuildIconsOverlay(); }

      // ---------- SVG Icon Overlay (guaranteed) ----------
      let namedWptsMap = Object.create(null); // name -> [{x,y,icon}]
      let tempWpts = []; // short-lived overlay until named payload arrives

      function allOverlayWpts(){
        let out = [];
        try { (localWpts||[]).forEach(function(p){ if(p && p.icon) out.push(p); }); } catch(_){ }
        try { (feedWpts||[]).forEach(function(p){ if(p && p.icon) out.push(p); }); } catch(_){ }
        try { (tempWpts||[]).forEach(function(p){ if(p && p.icon) out.push(p); }); } catch(_){ }
        try { Object.keys(namedWptsMap||{}).forEach(function(k){ (namedWptsMap[k]||[]).forEach(function(p){ if(p && p.icon) out.push(p); }); }); } catch(_){ }
        return out;
      }

      // Crosshair (simple static SVG centered above everything)
      const crosshairHost = document.createElement('div');
      crosshairHost.id = 'lnv-crosshair';
      Object.assign(crosshairHost.style, {
        position: 'absolute', left: '50%', top: '50%',
        transform: 'translate(-50%, -50%)', pointerEvents: 'none',
        zIndex: '10000', width: '26px', height: '26px'
      });
      // 24x24 SVG with white cross + dark outline for contrast
      crosshairHost.innerHTML = [
        '<svg width="26" height="26" viewBox="0 0 26 26" xmlns="http://www.w3.org/2000/svg" style="display:block">',
        '  <g stroke-linecap="round">',
        '    <line x1="3" y1="13" x2="23" y2="13" stroke="#000" stroke-opacity="0.55" stroke-width="3"/>',
        '    <line x1="13" y1="3" x2="13" y2="23" stroke="#000" stroke-opacity="0.55" stroke-width="3"/>',
        '    <line x1="3" y1="13" x2="23" y2="13" stroke="#fff" stroke-opacity="0.95" stroke-width="1.4"/>',
        '    <line x1="13" y1="3" x2="13" y2="23" stroke="#fff" stroke-opacity="0.95" stroke-width="1.4"/>',
        '  </g>',
        '</svg>'
      ].join('');
      try { host.appendChild(crosshairHost); } catch(_){}

      // Invert current map wrapper matrix (SVG) to convert screen -> world
      function currentWrapper(){
        try { return (nav && nav.layers && nav.layers.map && nav.layers.map.rwrapper) || null; } catch(_) { return null; }
      }
      function screenCenterWorld(){
        try {
          const r = host.getBoundingClientRect();
          const cx = r.left + r.width/2, cy = r.top + r.height/2; const wrap = currentWrapper(); if (!wrap || !wrap.getScreenCTM) return { x: lastPos.x||0, y: lastPos.y||0 };
          const M = wrap.getScreenCTM(); if (!M || typeof M.inverse !== 'function') return { x: lastPos.x||0, y: lastPos.y||0 };
          const inv = M.inverse();
          const pt = new DOMPoint(cx, cy).matrixTransform(inv);
          return { x: pt.x, y: pt.y };
        } catch(_) { return { x: lastPos.x||0, y: lastPos.y||0 }; }
      }

      function syncIconsTransform(){
        // Copy the transform from a navigator canvas so our world coords align
        try {
          let src = null;
          const L = nav && nav.layers;
          if (L && L.markers) src = (L.markers.rcanvas || L.markers.canvas);
          if (!src && L && L.route) src = (L.route.rcanvas || L.route.canvas);
          if (!src && L && L.map) src = (L.map.rwrapper || L.map.rcanvas);
          if (src && src.style) {
            iconsLayer.style.transform = src.style.transform || '';
            iconsLayer.style.transformOrigin = src.style.transformOrigin || '0 0';
          }
        } catch(_){ }
      }

      let __lnv_syncTimer = null;
      function ensureSyncTimer(){ try { if (!__lnv_syncTimer) { __lnv_syncTimer = setInterval(syncIconsTransform, 180); } } catch(_){} }
      scope.$on('$destroy', function(){ try { if (__lnv_syncTimer) clearInterval(__lnv_syncTimer); __lnv_syncTimer = null; } catch(_){} });

      function rebuildIconsOverlay(){ if (!iconsLayer) return;
        try {
          while (iconsLayer.firstChild) iconsLayer.removeChild(iconsLayer.firstChild);
          const list = allOverlayWpts(); if (!list || !list.length) return;
          // size icons relative to map zoom (smaller when zoomed in)
          let sc = 1; try { const o = (nav && nav.getOptions) ? nav.getOptions() : opts; sc = (o && o.scale) ? o.scale : 1; } catch(_){}
          const base = 28; // ~px at scale=1
          const SZ   = Math.round(Math.max(16, Math.min(40, base / Math.max(0.25, Math.min(4, Number(sc)||1)))));
          const HALF = SZ/2;
          for (let i=0;i<list.length;i++){
            const p = list[i]; if(!p || !p.icon) continue;
            const img = document.createElementNS('http://www.w3.org/2000/svg','image');
            const url = scope.iconUrl(p.icon);
            try { img.setAttributeNS('http://www.w3.org/1999/xlink','href', url); } catch(_){ }
            try { img.setAttribute('href', url); } catch(_){ }
            img.setAttribute('x', String((p.x||0) - HALF));
            img.setAttribute('y', String((p.y||0) - HALF));
            img.setAttribute('width', String(SZ)); img.setAttribute('height', String(SZ));
            img.style.pointerEvents = 'none';
            iconsLayer.appendChild(img);
          }
          try { svg.appendChild(iconsLayer); } catch(_){ }
          try { syncIconsTransform(); } catch(_){}
        } catch(_){ }
      }// Live trail overlay (on top of any engine-drawn trail)
      let liveTrailFlat = [];
      let trailSuppressed = false; // set true when user presses Clear
      function drawLiveTrail(){
        try {
          if (!scope.showRoute || scope.hideDuringRec) {
            nav.setRoute([]);
            return;
          }
          // prefer engine-provided trail when available; otherwise use our locally built trail
          let srcFlat = (liveTrailFlat && liveTrailFlat.length) ? liveTrailFlat : (window.__lnv_liveTrailFlat || []);
          if (!srcFlat || !srcFlat.length) return;
          const dense = densifyFlat(srcFlat, 0.6);
          // Cut the head (near-vehicle) to avoid a visible stub
          const headCut = Math.min(dense.length, scope.thinPrimary ? 4 : 6);
          const drawFlat = dense.slice(0, dense.length - headCut);
          // Use stock BeamNG nav route drawing with selected color
          const color = (scope.routeColors && (scope.routeColors[scope.recordingName] || scope.routeColors[scope.selectedRoute] || scope.routeColors[primaryRouteName])) || scope.newRouteColor || '#4AA3FF';
          try { nav.setRoute({ markers: drawFlat, color: withAlpha(color) }); } catch(_){}
        } catch(_){}
      }

      // events
      // Track the engine's ground marker payload if it still emits, then draw our overlay later
      scope.$on('NavigationGroundMarkersUpdate', function(_, d){
        if (trailSuppressed) {
          try { liveTrailFlat = []; window.__lnv_liveTrailFlat = []; window.__lnv_lastTrailPt = null; } catch(_){}
          return;
        }
        try { liveTrailFlat = toFlat(d); } catch(_){}
          if (scope.recBtn !== 'Stop') { try { setTrailMilesFrom(liveTrailFlat); } catch(_){ } }
        setTimeout(function(){ drawLiveTrail(); try { syncIconsTransform(); } catch(_){} }, 0);
      });
      // Route-scoped waypoint updates
      scope.$on('lowranceGPS.wptsNamed', function(_, d){
        try {
          const name = (d && d.name) || '';
          const src  = (d && d.markers) ? d.markers : [];
          // group by icon
          const groups = {};
          const store = [];
          for (let i=0;i<src.length;i++){
            const p = src[i]; if(!p) continue; const x = (p.x!=null)?p.x:(Array.isArray(p)?p[0]:0); const y=(p.y!=null)?p.y:(Array.isArray(p)?p[1]:0); const icon = p.icon || '';
            (groups[icon]||(groups[icon]=[])).push({x:x,y:y});
            store.push({x:x,y:y,icon:icon});
          }
          namedWptsMap[name] = store;
          // clear any temp markers for this route (now persisted)
          tempWpts = [];
          // clear previous groups for this name; static markers will handle display
          try { nav.setMarkers({ key: 'wpts:'+name, items: [] }); } catch(_){ }
          wptCache[name] = []; // not used for grouped anymore
          // If this is for the actively recording route, clear the local preview layer
          if (name && name === scope.recordingName) { localWpts = []; nav.setMarkers({ key: 'local', items: [] }); }
          // keep WPTs on top + refresh overlay
          renderWptOverlays();
          rebuildIconsOverlay();
        } catch(_){ }
      });

      // visibility + opacity
      scope.applyVisibility = function(){
        // Re-apply route visibility and refresh markers
        try {
          if (!scope.showRoute) { try { nav.setRoute([]); } catch(_){} }
          else {
            const flat = (primaryRouteName && routeCache[primaryRouteName]) || [];
            applyRoute({ markers: flat });
          }
        } catch(_){}
        renderWptOverlays();
      };
      scope.applyOpacity = function(){ try { host.style.opacity = String(scope.opacity); } catch(_){} };
      // init current opacity on first render
      scope.applyOpacity();

      // controls
      function safeOpts() { return (nav.getOptions && nav.getOptions()) || opts || { scale: 1, rotate: !scope.northUp }; }
      scope.zoomIn  = function(e){ stop(e); const o=safeOpts(); const s=Math.min(3,(o.scale||1)*1.15); nav.setOptions({ scale:s }); opts.scale=s; };
      scope.zoomOut = function(e){ stop(e); const o=safeOpts(); const s=Math.max(0.2,(o.scale||1)/1.15); nav.setOptions({ scale:s }); opts.scale=s; };
      scope.toggleNorth = function(e){ stop(e); scope.northUp=!scope.northUp; const rotate=!scope.northUp; nav.setOptions({ rotate }); opts.rotate=rotate; };
      scope.centerOnVehicle = function(e){ stop(e); panX = 0; panY = 0; applyPan(); updateOffsets(); };

      // WPT: drop and persist
      scope.addWpt = function(e){
        stop(e);
        if (scope.recBtn !== 'Stop') { return; } // only allow when recording
        if (!scope.wptPickerOpen) {
          scope.wptPickerOpen = true;
          // capture the position at the time of opening so vehicle movement doesn't shift it
          pendingWptPos = screenCenterWorld();
          // preload selection from last or first available
          try {
            if (!scope.wptIcon || scope.availableIcons.indexOf(scope.wptIcon) === -1) {
              var last = localStorage.getItem('lnvWptIcon')||'';
              scope.wptIcon = last && scope.availableIcons.indexOf(last) !== -1 ? last : (scope.availableIcons[0]||defaultIcon());
            }
          } catch(_){}
          try { console.log('[lowranceNav] WPT picker open; base:', scope.iconsBase, 'icons:', scope.availableIcons); } catch(_){}
          return;
        }
        // confirm
        scope.wptPickerOpen = false;
        const label = scope.wptLabel || 'WPT';
        const icon  = scope.wptIcon || defaultIcon();
        const pos = pendingWptPos || { x: lastPos.x, y: lastPos.y };
        // Add immediate overlay feedback (temp) and clear local preview
        tempWpts.push({ x:pos.x, y:pos.y, icon: icon });
        rebuildIconsOverlay();
        localWpts = []; renderLocal();
        try {
          bngApi.engineLua('extensions.lowranceGPS.addWaypointAt({ x = ' + String(pos.x||0) + ', y = ' + String(pos.y||0) + ', label = ' + JSON.stringify(label) + ', icon = ' + JSON.stringify(icon) + ' })');
        } catch(_){}
        // clear local markers immediately to avoid duplicates
        try { nav.setMarkers({ key:'local', items: [] }); } catch(_){}
        try { localStorage.setItem('lnvWptIcon', icon||''); } catch(_){}
        pendingWptPos = null;
      };

      // Also accept generic waypoint payloads (non-scoped) for compatibility
      scope.$on('lowranceGPS.markers', function(_, d){
        try { applyWpts(d); rebuildIconsOverlay(); } catch(_){}
      });

      // record + save/load
      scope.startNewRoute = function(e){
        stop(e);
        scope.recBtn = 'Stop';
        trailSuppressed = false;
        // clear any local waypoint previews for a fresh recording session
        localWpts = []; renderLocal();
        // clear WPT overlay of previous primary if it's not part of overlays
        try { if (primaryRouteName && !scope.activeRoutes[primaryRouteName]) { nav.setMarkers({ key:'wpts:'+primaryRouteName, items: [] }); delete wptCache[primaryRouteName]; } } catch(_){ }
        function ts(){ const d=new Date(); const p=n=>String(n).padStart(2,'0'); return `route_${d.getFullYear()}${p(d.getMonth()+1)}${p(d.getDate())}_${p(d.getHours())}${p(d.getMinutes())}${p(d.getSeconds())}`; }
        const name = (scope.routeName && scope.routeName.trim()) ? scope.routeName.trim() : ts();
        scope.recordingName = name;
        scope.selectedRoute = name;
        primaryRouteName = name;
        scope.$evalAsync(function(){ scope.trailMiles = 0; });
        // persist chosen color for this new route
        try { scope.routeColors[name] = scope.newRouteColor; localStorage.setItem('lnvRouteColors', JSON.stringify(scope.routeColors)); } catch(_){ }
        ext('extensions.lowranceGPS.startRouteRecordNamed(' + JSON.stringify(name) + ')');
        try { nav.setRoute([]); } catch(_){}
      };
      scope.stopRoute     = function(e){ stop(e); scope.recBtn = 'Record'; ext('extensions.lowranceGPS.stopRouteRecord()'); scope.recordingName=''; };
      scope.toggleRec = function(e){ stop(e); const start = scope.recBtn === 'Record'; (start?scope.startNewRoute:scope.stopRoute)(e); };
      function cleanName(s){ return (s||'default').replace(/[^a-zA-Z0-9_-]/g,'_'); }
      scope.saveNamed    = function(e){ stop(e); const n=cleanName(scope.routeName); ext('extensions.lowranceGPS.saveNamed(' + JSON.stringify(n) + ')'); ext('extensions.lowranceGPS.list()'); };
      scope.loadSelected = function(e){
        stop(e);
        trailSuppressed = false;
        if (!scope.selectedRoute) return;
        pendingFetchName = '';
        primaryRouteName = scope.selectedRoute;
        ext('extensions.lowranceGPS.loadNamed(' + JSON.stringify(scope.selectedRoute) + ')');
      };

      // HUD + player-follow
      scope.$on('lowranceGPS.hud',        function(_, d){
        if (!d) return;
        const ktToMph = 1.15077945;
        const a = Number(d.airspeed)||0; const m = Number(d.maxAirspeed)||0;
        const mphA = a * ktToMph; const mphM = m * ktToMph;
        scope.$evalAsync(function(){
          if (mphA >= 0 && mphA < 350) scope.mph = mphA;
          // Prefer UI-tracked max from current airspeed to ensure it always increments
          if (mphA >= 0 && mphA < 350) scope.maxMph = Math.max(scope.maxMph||0, mphA);
          // Keep raw values for other uses
          scope.airspeed = a; scope.maxAirspeed = m;
        });
        // Follow active vehicle position/heading from Lua to avoid freecam tracking
        try {
          if (scope.followVehicle) {
            const upd = {};
            if (typeof d.x === 'number' && typeof d.y === 'number') { upd.x = d.x; upd.y = d.y; lastPos.x = d.x; lastPos.y = d.y; }
            if (typeof d.rot === 'number') {
              const HEADING_OFFSET = 90; // degrees to the right
              upd.rotation = d.rot + 180 + HEADING_OFFSET; // align with engine + offset
            }
            if (Object.keys(upd).length) nav.updateData(upd);
          }
        } catch(_){}
      });

      // Reset max speed from menu
      scope.clearMax = function(e){
        stop(e);
        scope.$evalAsync(function(){ scope.maxMph = 0; });
        try { bngApi.engineLua('extensions.lowranceGPS.resetMax()'); } catch(_){ }
      };

      // ---------- Waypoint hotkey binding ----------
      function loadBind(){ try { return JSON.parse(localStorage.getItem('lnvWptBind')||'null')||null; } catch(_) { return null; } }
      function saveBind(b){ try { localStorage.setItem('lnvWptBind', JSON.stringify(b||{})); } catch(_){} }
      function labelFor(b){ if(!b) return ''; if(b.type==='key') return b.code||b.key||''; if(b.type==='pad') return 'Pad'+(b.gp|0)+':B'+(b.btn|0); return ''; }
      scope.wptBind = loadBind();
      scope.wptBindingLabel = labelFor(scope.wptBind);
      // Re-apply engine keyboard binding on load
      try { if (scope.wptBind && scope.wptBind.type === 'key') {
        (function(evLike){
          function toEngineKey(b){
            if (!b) return '';
            if (b.code && b.code.startsWith('Key') && b.code.length===4) return b.code.slice(3).toLowerCase();
            if (b.code && b.code.startsWith('Digit')) return b.code.slice(5);
            if ((b.code || '').toLowerCase() === 'space' || (b.key||'').toLowerCase()===' ') return 'space';
            if ((b.code||'') === 'Enter' || (b.key||'') === 'Enter') return 'enter';
            const k = (b.key||'').toLowerCase();
            if (k && k.length===1) return k;
            return k || (b.code||'').toLowerCase();
          }
          const engKey = toEngineKey(scope.wptBind);
          if (engKey) bngApi.engineLua('extensions.lowranceGPS.bindKeyboardKey(' + JSON.stringify(engKey) + ')');
        })();
      } } catch(_){}

      // Fire addWpt via binding (only while recording)
      function maybeAddWpt(){ try { if (scope.recBtn === 'Stop') scope.addWpt(); } catch(_){} }
      let bindingActive = false;
      function keyMatches(ev, bind){
        try {
          if (!bind) return false;
          const code = (ev.code || '').toString();
          const key  = (ev.key  || '').toString();
          const kc   = (ev.keyCode != null) ? ev.keyCode : (ev.which != null ? ev.which : null);
          if (bind.code && code && code === bind.code) return true;
          if (bind.key && key && key.toLowerCase() === String(bind.key).toLowerCase()) return true;
          if (bind.keyCode != null && kc != null && Number(bind.keyCode) === Number(kc)) return true;
        } catch(_){}
        return false;
      }
      function onKeyDown(ev){
        try {
          if (bindingActive) return; // do not trigger while capturing a new bind
          if (!scope.wptBind || scope.wptBind.type !== 'key') return;
          if (ev.repeat) return;
          // Ignore when typing in inputs or menu dropdowns
          const t = ev.target; const tn = (t && t.tagName)||''; if (tn==='INPUT' || tn==='TEXTAREA') return;
          if (keyMatches(ev, scope.wptBind)) {
            ev.preventDefault(); ev.stopPropagation(); maybeAddWpt();
          }
        } catch(_){}
      }
      function onKeyUp(ev){
        try {
          if (bindingActive) return;
          if (!scope.wptBind || scope.wptBind.type !== 'key') return;
          // Some engines only surface keyup reliably to UI; use as fallback
          const t = ev.target; const tn = (t && t.tagName)||''; if (tn==='INPUT' || tn==='TEXTAREA') return;
          if (keyMatches(ev, scope.wptBind)) {
            ev.preventDefault(); ev.stopPropagation(); maybeAddWpt();
          }
        } catch(_){}
      }
      document.addEventListener('keydown', onKeyDown, true);
      document.addEventListener('keyup', onKeyUp, true);

      // Gamepad polling for binding and runtime
      let gpPollTimer = null; let gpPressed = false; let bindUntil = 0; let bindPadMode = false;
      function pollGamepads(){
        try {
          const now = Date.now();
          const pads = navigator.getGamepads ? navigator.getGamepads() : [];
          // Capture mode: pick the first pressed button
          if (bindPadMode && now < bindUntil) {
            for (let gi=0; gi<pads.length; gi++){
              const gp = pads[gi]; if(!gp||!gp.buttons) continue;
              for (let bi=0; bi<gp.buttons.length; bi++){
                const b = gp.buttons[bi]; if (b && b.pressed) {
                  scope.wptBind = { type:'pad', gp: gi, btn: bi };
                  scope.wptBindingLabel = labelFor(scope.wptBind);
                  saveBind(scope.wptBind);
                  bindPadMode = false; bindUntil = 0; bindingActive = false; scope.$applyAsync();
                  return;
                }
              }
            }
          }
          // Runtime trigger
          const b = scope.wptBind;
          if (b && b.type === 'pad' && pads[b.gp]){
            const gp = pads[b.gp]; const btn = (gp.buttons && gp.buttons[b.btn]) || null;
            const pressed = !!(btn && (btn.pressed || btn.value > 0.5));
            if (pressed && !gpPressed) { gpPressed = true; maybeAddWpt(); }
            else if (!pressed && gpPressed) { gpPressed = false; }
          }
        } catch(_){}
      }
      gpPollTimer = setInterval(pollGamepads, 80);

      scope.$on('$destroy', function(){ try { document.removeEventListener('keydown', onKeyDown, true); document.removeEventListener('keyup', onKeyUp, true);} catch(_){} try { clearInterval(gpPollTimer); } catch(_){} });

      // Bind controls in UI (key or pad)
      scope.startBind = function(e){
        stop(e);
        bindingActive = true;
        scope.wptBindingLabel = 'press a key or pad...';
        // key capture
        const once = function(ev){
          document.removeEventListener('keydown', once, true);
          if (!bindingActive) return;
          bindingActive = false; bindPadMode = false; bindUntil = 0;
          // Ignore modifier-only
          if (!ev.code || ev.code === 'ShiftLeft' || ev.code === 'ShiftRight' || ev.code === 'ControlLeft' || ev.code === 'ControlRight' || ev.code === 'AltLeft' || ev.code === 'AltRight' || ev.code === 'MetaLeft' || ev.code === 'MetaRight') { scope.$applyAsync(()=>{ scope.wptBindingLabel = labelFor(scope.wptBind); }); return; }
          scope.wptBind = { type:'key', code: ev.code, key: ev.key, keyCode: (ev.keyCode != null ? ev.keyCode : (ev.which != null ? ev.which : null)) };
          saveBind(scope.wptBind);
          scope.$applyAsync(function(){ scope.wptBindingLabel = labelFor(scope.wptBind); });
          // Map DOM KeyboardEvent to engine actionMap key tokens
          try {
            function toEngineKey(ev){
              const c = ev.code || '';
              if (c.startsWith('Key') && c.length===4) return c.slice(3).toLowerCase();
              if (c.startsWith('Digit')) return c.slice(5);
              if (c === 'Space') return 'space';
              if (c === 'Enter' || ev.key === 'Enter') return 'enter';
              const k = (ev.key||'').toLowerCase();
              if (k.length === 1) return k;
              return k || c.toLowerCase();
            }
            const engKey = toEngineKey(ev);
            if (engKey) bngApi.engineLua('extensions.lowranceGPS.bindKeyboardKey(' + JSON.stringify(engKey) + ')');
            // Also send raw virtual key so Lua can listen via onKeyEvent if needed
            var vk = (ev.keyCode != null ? ev.keyCode : (ev.which != null ? ev.which : 0));
            if (vk) bngApi.engineLua('extensions.lowranceGPS.setVk(' + String(vk|0) + ')');
          } catch(_){}
          ev.preventDefault(); ev.stopPropagation();
        };
        document.addEventListener('keydown', once, true);
        // pad capture window
        bindPadMode = true; bindUntil = Date.now() + 6000;
      };
      scope.clearBind = function(e){ stop(e); scope.wptBind = null; scope.wptBindingLabel = ''; saveBind(null); try { bngApi.engineLua('extensions.lowranceGPS.unbindKeyboard()'); } catch(_){} };
      scope.$on('lowranceGPS.routesList', function(_, d){
        scope.$evalAsync(function(){
          scope.routes = (d && d.routes) || [];
          const map = (d && d.map) || '';
          const prev = scope.currentMap || '';
          const changed = !!map && map !== prev;
          if (changed) {
            try { Object.keys(scope.activeRoutes||{}).forEach(function(n){ nav.setMarkers({ key:'route:'+n, items: [] }); }); } catch(_){ }
            scope.activeRoutes = {};
            routeCache = Object.create(null);
            // Clear any currently drawn primary/stock route and overlays
            try { scope.clearAllRoutes && scope.clearAllRoutes(); } catch(_){}
            // Re-request the dashboard map stream and POIs (same as manual button)
            try { bngApi.engineLua("extensions.ui_uiNavi.requestUIDashboardMap()"); } catch(_){ }
            try { bngApi.engineLua("if gameplay_markerInteraction then freeroam_bigMapPoiProvider.sendMissionLocationsToMinimap() end"); } catch(_){ }
            // Request fresh map stream; avoid heavy navigator rebuilds here
            // to prevent suppressing the engine's pending map payload.
          }
          scope.currentMap = map;
          // single-route mode: do not restore overlay selections
        });
      });

      // When a route payload arrives from Lua
      scope.$on('lowranceGPS.route', function(_, d){
        const name = pendingFetchName || primaryRouteName || scope.selectedRoute || '';
        try { liveTrailFlat = toFlat(d); } catch(_){}
        try { setTrailMilesFrom(liveTrailFlat); } catch(_){}
        if (pendingFetchName) {
          routeCache[pendingFetchName] = toFlat(d);
          primaryRouteName = pendingFetchName;
          pendingFetchName = '';
          pendingPrimaryReapply = '';
          renderWptOverlays();
          return;
        }
        // otherwise treat as primary route update
        routeCache[name] = toFlat(d);
        primaryRouteName = name;
        try { setTrailMilesFrom(routeCache[name]||[]); } catch(_){}
        // While recording, show stock route using selected color
        if (scope.recBtn === 'Stop') {
          if (!scope.hideDuringRec) {
            const col = (scope.routeColors && scope.routeColors[scope.recordingName || name]) || scope.newRouteColor || '#4AA3FF';
            try { nav.setRoute({ markers: densifyFlat(routeCache[name], 0.6), color: withAlpha(col) }); } catch(_){ }
          }
        }
        // If not recording and thinPrimary is enabled, still use stock route with color
        else if (scope.thinPrimary) {
          const col = (scope.routeColors && scope.routeColors[name]) || '#4AA3FF';
          try { nav.setRoute({ markers: densifyFlat(routeCache[name], 0.6), color: withAlpha(col) }); } catch(_){ }
        } else {
          applyRoute(d);
        }
        renderActiveRoutes();
        renderWptOverlays();
      });

      // dropdown portal (kept for compatibility / hidden in UI)
      let menuEl=null; function closeMenu(){ if(menuEl&&menuEl.parentNode) menuEl.parentNode.removeChild(menuEl); menuEl=null; }
      scope.openMenu = function(e){ stop(e); closeMenu(); const btn=document.getElementById('lnv-dd-btn') || document.getElementById('lnv-dd-inmenu'); const r=btn.getBoundingClientRect();
        menuEl = document.createElement('div'); Object.assign(menuEl.style,{ position:'fixed', left:(r.left|0)+'px', top:((r.top|0)+r.height)+'px', minWidth:Math.max(180,r.width)+'px', maxHeight:'240px', overflow:'auto', background:'rgba(20,20,20,.98)', borderRadius:'6px', padding:'4px', boxShadow:'0 8px 18px rgba(0,0,0,.6)', zIndex:'100000' });
        if (!scope.routes.length) { const empty=document.createElement('div'); empty.textContent='No saves'; empty.style.color='#ccc'; empty.style.padding='6px 8px'; menuEl.appendChild(empty); }
        else { scope.routes.forEach(function(name){ const item=document.createElement('div'); item.textContent=name; Object.assign(item.style,{color:'#eee',padding:'6px 8px',borderRadius:'4px',cursor:'pointer'}); item.onmouseenter=()=>item.style.background='rgba(255,255,255,.08)'; item.onmouseleave=()=>item.style.background='transparent'; item.onclick=function(ev){ ev.stopPropagation(); ev.preventDefault(); scope.$applyAsync(()=>{ scope.selectedRoute=name; }); closeMenu(); }; menuEl.appendChild(item); }); }
        document.body.appendChild(menuEl); setTimeout(function(){ function onDoc(ev){ if(menuEl && !menuEl.contains(ev.target)){ closeMenu(); document.removeEventListener('mousedown', onDoc, true); document.removeEventListener('keydown', onKey, true);} } function onKey(ev){ if(ev.key==='Escape'){ closeMenu(); document.removeEventListener('mousedown', onDoc, true); document.removeEventListener('keydown', onKey, true);} } document.addEventListener('mousedown', onDoc, true); document.addEventListener('keydown', onKey, true); },0);
      };

      // in-app slide-out helpers
      scope.refreshRoutes = function(e){ stop(e); ext('extensions.lowranceGPS.list()'); };
      function persistActive(){ try { localStorage.setItem('lnvActive:'+scope.currentMap, JSON.stringify(Object.keys(scope.activeRoutes).filter(function(k){ return !!scope.activeRoutes[k]; }))); } catch(_){ } }
      function ensureRouteCached(name){ if (!routeCache[name]) { ext('extensions.lowranceGPS.peekNamedRoute(' + JSON.stringify(name) + ')'); } }
      function ensureAllSelectedCached(){ try { Object.keys(scope.activeRoutes||{}).forEach(function(n){ if (scope.activeRoutes[n]) ensureRouteCached(n); }); } catch(_){ } }
      scope.loadSelectedRoutes = function(e){
        stop(e);
        try { Object.keys(routeCache||{}).forEach(function(n){ if (!scope.activeRoutes[n]) { nav.setMarkers({ key:'route:'+n, items: [] }); nav.setMarkers({ key:'wpts:'+n, items: [] }); delete wptCache[n]; } }); } catch(_){ }
        try { Object.keys(scope.activeRoutes||{}).forEach(function(n){ if (scope.activeRoutes[n]) { ensureRouteCached(n); ext('extensions.lowranceGPS.peekNamedWpts(' + JSON.stringify(n) + ')'); } }); } catch(_){}
        renderActiveRoutes();
        persistActive();
      };
      scope.clearAllRoutes = function(e){
        stop(e);
        const prev = primaryRouteName; primaryRouteName = '';
        pendingFetchName = '';
        pendingPrimaryReapply = '';
        scope.selectedRoute = '';
        scope.recordingName = '';
        trailSuppressed = true;
        try { /* no engine route */ nav.setRoute([]); nav.setRoute({ markers: [] }); nav.setMarkers({ key:'trail:erase', items: [] }); nav.setMarkers({ key:'trail:color', items: [] }); } catch(_){ }
        try { bngApi.engineLua('if core_groundMarkers and core_groundMarkers.setPath then core_groundMarkers.setPath(nil) end'); } catch(_){ }
        try { bngApi.engineLua('extensions.lowranceGPS.clearUiWpts()'); } catch(_){ }
        function clearWpts(name){ try { nav.setMarkers({ key:'wpts:'+name, items: [] }); } catch(_){} }
        try { Object.keys(routeCache||{}).forEach(function(n){ nav.setMarkers({ key:'route:'+n, items: [] }); clearWpts(n); }); } catch(_){ }
        try { (scope.routes||[]).forEach(function(n){ clearWpts(n); }); } catch(_){ }
        try { if (prev) clearWpts(prev); } catch(_){ }
        try { nav.setMarkers({ key:'local', items: [] }); nav.setMarkers({ key:'feed', items: [] }); } catch(_){ }
        // clear overlay caches
        try { namedWptsMap = Object.create(null); tempWpts = []; } catch(_){ }
        localWpts = []; feedWpts = []; liveTrailFlat = []; try { window.__lnv_liveTrailFlat = []; window.__lnv_lastTrailPt = null; } catch(_){ }
        routeCache = Object.create(null);
        wptCache = Object.create(null);
        scope.activeRoutes = {};
        scope.$evalAsync(function(){ scope.trailMiles = 0; });
        try { nav.setRoute([]); nav.setRoute({ markers: [] }); } catch(_){ }
        try { applyRoute([]); } catch(_){ }
        try { rebuildIconsOverlay(); } catch(_){ }
      };
      scope.selectMenuRoute = function(name){
        scope.$evalAsync(function(){ scope.selectedRoute = name; });
        // Set as primary; fetch if needed. Clear any other overlays/caches.
        try { Object.keys(routeCache||{}).forEach(function(n){ if (n!==name) { nav.setMarkers({ key:'route:'+n, items: [] }); nav.setMarkers({ key:'wpts:'+n, items: [] }); delete routeCache[n]; delete wptCache[n]; } }); } catch(_){ }
        if (routeCache[name]) { primaryRouteName = name; applyRoute({ markers: routeCache[name] }); }
        else { pendingFetchName = name; primaryRouteName = name; ext('extensions.lowranceGPS.peekNamed(' + JSON.stringify(name) + ')'); }
        // always fetch associated waypoints for the chosen primary
        try { bngApi.engineLua('extensions.lowranceGPS.peekNamedWpts(' + JSON.stringify(name) + ')'); } catch(_){}
      };
      scope.toggleRoute = function(name){ /* single-route mode: ignore */ };
      scope.changeRouteColor = function(name, color){ try { scope.routeColors[name] = color; localStorage.setItem('lnvRouteColors', JSON.stringify(scope.routeColors)); if (primaryRouteName===name) applyRoute({ markers: routeCache[name]||[] }); } catch(_){} };
      scope.deleteRoute = function(name){ try {
        // clear UI + caches
        delete routeCache[name]; delete scope.activeRoutes[name]; delete wptCache[name]; delete scope.routeColors[name]; try { nav.setMarkers({ key:'route:'+name, items: [] }); nav.setMarkers({ key:'wpts:'+name, items: [] }); } catch(_){ }
        try { localStorage.setItem('lnvRouteColors', JSON.stringify(scope.routeColors)); } catch(_){ }
        if (primaryRouteName === name) { primaryRouteName = ''; applyRoute([]); }
        // ask Lua to remove file and refresh list
        ext('extensions.lowranceGPS.deleteNamed(' + JSON.stringify(name) + ')');
      } catch(_){} };

      // load saved colors if present
      try { scope.routeColors = JSON.parse(localStorage.getItem('lnvRouteColors')||'{}') || {}; } catch(_) { scope.routeColors = {}; }

      // start stock map + list
      bngApi.engineLua("extensions.ui_uiNavi.requestUIDashboardMap()");
      bngApi.engineLua("if gameplay_markerInteraction then freeroam_bigMapPoiProvider.sendMissionLocationsToMinimap() end");
      ext("extensions.lowranceGPS.list()");
      ext('extensions.lowranceGPS.listWptIcons()');
    }
  };
});




