-- Создано: PoonJik(KDM MODS)
-- Created by: PoonJik(KDM MODS)

local M = {}
M.type = "auxiliary"

local function updateGFX(dt)
end

local function getLocalizedWeekday()
  -- Получаем язык пользователя из настроек игры
  local userLang = settings and settings.getValue and settings.getValue("userLanguage") or "en-US"

  -- Формируем путь к JSON-файлу локализации
  local localePath = "/vehicles/gtishka/locales/" .. userLang .. ".json"

  -- Загружаем переводы
  local translations = jsonReadFile(localePath)

  -- Если файл не найден или пуст, используем английский как запасной вариант
  if not translations then
    translations = jsonReadFile("/vehicles/gtishka/locales/en-US.json") or {}
  end

  -- Определяем день недели (0 = воскресенье, 1 = понедельник, ..., 6 = суббота)
  local dayIndex = tonumber(os.date("%w"))

  -- Ключ перевода
  local key = "gtishka.textWeekday." .. ({
    "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"
  })[dayIndex + 1]

  -- Возвращаем локализированное название дня недели или английский вариант по умолчанию
  return translations[key] or key
end

local function updateGaugeData(moduleData, dt)
  moduleData.temperatureEnv = obj:getEnvTemperature() - 273.15 -- температура
  moduleData.time = os.date("%H") .. ":" .. os.date("%M") -- часы:минуты
  moduleData.date = os.date("%d") .. "/" .. os.date("%m") .. "/" .. os.date("%Y") -- дд.мм.гггг
  moduleData.weekday = getLocalizedWeekday() -- день недели
end

local function setupGaugeData(properties)
end

local function reset()
end

local function init(jbeamData)
end

M.init = init
M.reset = reset
M.updateGFX = updateGFX

M.setupGaugeData = setupGaugeData
M.updateGaugeData = updateGaugeData

return M
