
local M = {}

local throttleThreshold = 0.7
local engineKickIn = 0

local maxBatteryCapacity = 0
local batteriesUsed = {}
local eMotors = {}

local ceDisabled = false
local starterTick = 0
local eDisabled = false
local gear = ""
local evMode = false
local transfercase = nil

M.regen = 0

local throttle = 0
local brake = 0

local defaultRegen = 0
local brakeRegenCoef = 0
local regenThrottleSmoother = newExponentialSmoothing(10)
local currentRegenThrottle = 0

local min = math.min
local max = math.max


local function toggleCombustionStarter(bool)
    if electrics.values.ignitionLevel ~= 2 then return end
    if bool then
        for _, ce in pairs (powertrain.getDevicesByType("combustionEngine")) do
            if ce.ignitionCoef ~= 1 then
                ce:activateStarter(ce)
            end
            controller.mainController.setStarter(true)
        end
        ceDisabled = false
    elseif not bool then
        for _, ce in pairs (powertrain.getDevicesByType("combustionEngine")) do
            if ce.ignitionCoef ~= 0 then
                ce:deactivateStarter(ce)
            end
            controller.mainController.setStarter(false)
        end
        ceDisabled = true
    end
end


local function disableCombustionRev()
    electrics.values.engineThrottleFactor = 0
end

local function enableCombustionRev()
    electrics.values.engineThrottleFactor = 1
end

local function setElectricDir(num)
    for _, e in pairs (eMotors) do
        e.motorDirection = num
    end
end

local function init(jbeamData)
    ceDisabled = false
    eDisabled = false
    gear = ""
    evMode = false
    throttle = 0
    brake = 0


    defaultRegen = jbeamData.defaultRegen or 0.2
    brakeRegenCoef = jbeamData.brakeRegenCoef or 0.3
    throttleThreshold = jbeamData.throttleThreshold or 0.7
    engineKickIn = jbeamData.engineKickIn or 8.3

    electrics.values.currentbatteryChargeHybrid = 0
    eMotors = powertrain.getDevicesByType("electricMotor")
    for _, v in pairs(eMotors) do
      for _, j in pairs(v.registeredEnergyStorages) do
        batteriesUsed[j] = true
      end
    end

    for k, _ in pairs(batteriesUsed) do
      local storage = energyStorage.getStorage(k)
      maxBatteryCapacity = maxBatteryCapacity + storage.energyCapacity
    end

    motors = {}
    local motorNames = jbeamData.motorNames or {"mainMotor"}
    motorNames = type(motorNames) ~= "table" and {motorNames} or motorNames
    for _, v in ipairs(motorNames) do
      local motor = powertrain.getDevice(v)
      if motor then
        M.maxRPM = max(M.maxRPM, motor.maxAV * constants.avToRPM)
        table.insert(motors, motor)
      end
    end
end

local function reset()
    transfercase = powertrain.getDevice("transfercase")
    ceDisabled = false
    eDisabled = false
    gear = ""
    evMode = false
    throttle = 0
    brake = 0
end

local function updateGFX(dt)
    local energyLeft = 0
    for k, _ in pairs(batteriesUsed) do
      local storage = energyStorage.getStorage(k)
      energyLeft = energyLeft + storage.storedEnergy
    end
    local energyLeftPercent = math.floor(energyLeft / maxBatteryCapacity * 100)
    electrics.values.currentbatteryChargeHybrid = energyLeft / maxBatteryCapacity
    if electrics.values.ignitionLevel ~= lastIgnition then
        for _, motor in ipairs(eMotors) do
            motor:setIgnition((electrics.values.ignitionLevel == 2) and 1 or 0)
        end
    end
    lastIgnition = electrics.values.ignitionLevel

    gear = electrics.values.gear
    throttle = electrics.values.throttle
    brake = electrics.values.brake

    local regenThrottle = throttle <= 0 and math.min(defaultRegen + brake * brakeRegenCoef, 1) or 0
    local emergencyBrakeCoef = brake >= 1 and 0.5 or 1
    local escCoef = electrics.values.escActive and 0 or 1
    local steeringCoef = math.abs(sensors.gx2) > 5 and 0 or 1
    currentRegenThrottle = regenThrottle * escCoef * steeringCoef * emergencyBrakeCoef
    local smoothedRegenThrottle = regenThrottleSmoother:get(currentRegenThrottle)
    if smoothedRegenThrottle < 0.1 then
        electrics.values.regenThrottle = 0
    else
        electrics.values.regenThrottle = regenThrottleSmoother:get(currentRegenThrottle)
    end

    starterTick = starterTick + dt
    if starterTick >= 2 then
        if ceDisabled == false and electrics.values.rpm < 50 then
            toggleCombustionStarter(true)
        elseif ceDisabled == true and electrics.values.rpm > 50 then
            toggleCombustionStarter(false)
        end
        starterTick = 0
    end
    if energyLeftPercent <= 2 then
        guihooks.message("Hybrid battery low charge.", 4, "vehicle.bohhuHybrid.evMode", "explicit")
    end
    if not evMode and energyLeftPercent >= 10 and not engineFullTakeover then
        fullEngineMessageSent = false
        if gear == "N" or gear == "P" then
            setElectricDir(0)
        elseif gear == "R" then
            setElectricDir(-1)
        elseif gear == "D" or gear == "S" then
            setElectricDir(1)
        end
        
        if gear == "R" then 
            ceDisabled = true
            
        elseif gear == "P" then
            ceDisabled = true
        else
            if ceDisabled == true then
                toggleCombustionStarter(true)
            end
        end
    elseif evMode then -- logic for ev mode
        fullEngineMessageSent = false
        ceDisabled = true
        if gear == "N" or gear == "P" then
            setElectricDir(0)
        elseif gear == "R" then
            setElectricDir(-1)
        elseif gear == "D" or gear == "S" then
            setElectricDir(1)
        end
    end
end

M.reset = reset
M.init = init
M.updateGFX = updateGFX

return M