
angular.module('gaugesScreen', [])
  .controller('GaugesScreenController', function ($scope, $element, $window) {
    "use strict";
    var vm = this;

    var svg;
    var navContainer = $element[0].children[0];
    var navDimensions = [];

    var speedoDisplay = { gears: {}, gearsBOX: {} };
    var navDisplay = {};
	var text = {  };
    var infoDisplay = {};
	var gMeterPage = {};
	var DatePage = {};
	var TempPage = {};
	var TirePresPage = {};
	var InfoPage = {};
    var consumGraph = {values:{current: 0,avg: 0}};
    var electrics = {lights:{} };
    var gForcesVisible = false;

    var backgroundGradient = {};
    var overlayGradient = {};
    var navMarkerGradient = {};
    // var backgroundClipGradient;

    var speedoInitialised = false;
    var currentGear = '';
    var prevRpmAng = 0;

    var ready = false;

    var unit = "metric";
	var units = {uiUnitTemperature: "c"};
    var unitspeedratio = 3.6/260*Math.PI*1.5;

    function setTheme(hue) {
      // speedo
      speedoDisplay.speedTicks.css({'stroke': `hsl(${hue}, 70%, 50%)`, 'stroke-width': '0.5px'});

      // info
      infoDisplay.infoOverlay.css({'stroke': `hsl(${hue}, 100%, 30%)`, 'stroke-width': '0.5px'});

      // info
      navDisplay.overlay.css({'stroke': `hsl(${hue}, 100%, 30%)`, 'stroke-width': '0.5px'});

      // gradients
      overlayGradient.stop1.css({stopColor: `hsl(${hue}, 100%, 20%)`})
      overlayGradient.stop2.css({stopColor: `hsl(${hue}, 100%, 10%)`})

      backgroundGradient.stop1.css({"stop-color": `hsl(${hue}, 100%, 0%)`})
      backgroundGradient.stop2.css({"stop-color": `hsl(${hue}, 100%, 0%)`})

      navMarkerGradient.stop1.css({"stop-color": `hsl(${hue}, 100%, 50%)`})
      navMarkerGradient.stop2.css({"stop-color": `hsl(${hue}, 100%, 30%)`})

      // background color
      $element[0].style.backgroundColor = "black";
      //$element[0].style.backgroundColor = `hsl(${hue}, 70%, 20%)`;
    }

    // Make sure SVG is loaded
    $scope.onSVGLoaded = function () {
      svg = $element[0].children[1].children[0];

      // speedometer
      speedoDisplay.root = hu('#speedometer', svg);
      speedoDisplay.speedometerText = hu('#speedometerText', speedoDisplay.root)
      speedoDisplay.speedValue = hu('#speedValue', speedoDisplay.speedometerText);
      speedoDisplay.speedUnit = hu('#speedUnit', speedoDisplay.speedometerText);
      speedoDisplay.speedTicks = hu('#speedTicks', speedoDisplay.speedometerText);
      speedoDisplay.speedTicksText  = hu('#speedTicksText', speedoDisplay.speedometerText);
	  //BOX Text
      speedoDisplay.gears.P = hu('#gearP', speedoDisplay.speedometerText);
      speedoDisplay.gears.R = hu('#gearR', speedoDisplay.speedometerText);
      speedoDisplay.gears.N = hu('#gearN', speedoDisplay.speedometerText);
      speedoDisplay.gears.D = hu('#gearD', speedoDisplay.speedometerText);
	  //BOX Gear
	  speedoDisplay.gearsBOX.P = hu('#BOXgearP', speedoDisplay.speedometerText);
      speedoDisplay.gearsBOX.R = hu('#BOXgearR', speedoDisplay.speedometerText);
      speedoDisplay.gearsBOX.N = hu('#BOXgearN', speedoDisplay.speedometerText);
      speedoDisplay.gearsBOX.D = hu('#BOXgearD', speedoDisplay.speedometerText);
	  
	  TirePresPage.root = hu('#TirePresPage', svg);
	  TirePresPage.tires_pressure = {
        FR: hu('#tpres_FR', TirePresPage.root), // Переднее правое
        FL: hu('#tpres_FL', TirePresPage.root), // Переднее левое
        RR: hu('#tpres_RR', TirePresPage.root), // Заднее правое
        RL: hu('#tpres_RL', TirePresPage.root)  // Заднее левое
	  };
	  TirePresPage.tires_pressurePSI = {
        FR: hu('#tpresPSI_FR', TirePresPage.root), // Переднее правое
        FL: hu('#tpresPSI_FL', TirePresPage.root), // Переднее левое
        RR: hu('#tpresPSI_RR', TirePresPage.root), // Заднее правое
        RL: hu('#tpresPSI_RL', TirePresPage.root)  // Заднее левое
	  };
	  
	  speedoDisplay.ModeBOX = hu('#ModeBOX', speedoDisplay.speedometerText);
	  speedoDisplay.ModeText = hu('#ModeText', speedoDisplay.speedometerText);
	  speedoDisplay.GearValue = hu('#GearValue', speedoDisplay.speedometerText);
	  speedoDisplay.timeValue = hu('#timeValue', speedoDisplay.speedometerText);
	  speedoDisplay.outside_temp = hu('#outside_temp', speedoDisplay.speedometerText);
	  speedoDisplay.temp_unit = hu('#temp_unit', speedoDisplay.speedometerText);
	  
	  DatePage.root = hu('#DatePage', svg);
	  DatePage.dateValues = hu('#dateValues', DatePage.root);
	  DatePage.weekdayText = hu('#weekdayText', DatePage.root);
	  
	  TempPage.root = hu('#TempPage', svg);
	  TempPage.waterTempValue = hu('#waterTempValue', TempPage.root);
	  TempPage.tempWater_unit = hu('#tempWater_unit', TempPage.root);
	  TempPage.oilTempValue = hu('#oilTempValue', TempPage.root);
	  TempPage.tempOil_unit = hu('#tempOil_unit', TempPage.root);
	  
	  InfoPage.root = hu('#InfoPage', svg);
	  
      speedoDisplay.needle = hu('#needle', speedoDisplay.root);
      //speedoDisplay.needle.css({transformOrigin: '68px 33px', transform: 'rotate(227deg)'}).attr({class: "fade-in"});
      speedoDisplay.needle.attr({class: "fade-in"}).css({stroke: "#ff0000"});
      speedoDisplay.needle_bar = hu('#needle_bar', speedoDisplay.root);
      speedoDisplay.needle_bar.attr({class: "fade-in"});
      speedoDisplay.needle_gradients = [];
      speedoDisplay.needle_gradients.push(hu('#radialGradient965', svg));

      // info
      infoDisplay.root = hu('#information', svg);
      infoDisplay.infoOverlay = hu('#infoOverlay', infoDisplay.root);
      infoDisplay.infoValues = hu('#infoValues', infoDisplay.root);
      // var ivbox = infoDisplay.root.n.getBBox()
      // console.log("infovalu", ((ivbox.y+ivbox.width/2)/svg.getBBox().width)*100,((ivbox.x+ivbox.height/2)/svg.getBBox().height)*100)

      infoDisplay.accelerometer = hu('#accelerometer', infoDisplay.root);
	  
	  gMeterPage.root = hu('#gMeterPage', svg);
      gMeterPage.accelerometerMarker = hu('#accelerometerMarker', gMeterPage.root);
      gMeterPage.gXNegative = hu('#gXNegative', gMeterPage.root);
      gMeterPage.gXPositive = hu('#gXPositive', gMeterPage.root);
      gMeterPage.gYNegative = hu('#gYNegative', gMeterPage.root);
      gMeterPage.gYPositive = hu('#gYPositive', gMeterPage.root);

      consumGraph.root = hu('#consum_graph_layer', svg);
      // var cbox = consumGraph.root.n.getBBox()
      // console.log("consum_graph_layer", ((cbox.y+cbox.width/2)/svg.getBBox().width)*100,((cbox.x+cbox.height/2)/svg.getBBox().height)*100)
      /*consumGraph.graph_canvas = document.getElementById('consum_graph_canvas');
      consumGraph.graph_canvas_ctx = consumGraph.graph_canvas.getContext("2d");
      consumGraph.graph_canvas_gradiant_o = consumGraph.graph_canvas_ctx.createLinearGradient(0,0,0,consumGraph.graph_canvas.height);
      consumGraph.graph_canvas_gradiant_o.addColorStop(0, 'rgba(0,204,153,0.5)');
      consumGraph.graph_canvas_gradiant_o.addColorStop(0.6, 'rgba(0,204,153,0)');
      consumGraph.graph_canvas_gradiant_o.addColorStop(1, 'rgba(0,204,153,0)');
      consumGraph.graph_canvas_gradiant_g = consumGraph.graph_canvas_ctx.createLinearGradient(0,0,0,consumGraph.graph_canvas.height);
      consumGraph.graph_canvas_gradiant_g.addColorStop(0, 'rgba(51,51,255,0)');
      consumGraph.graph_canvas_gradiant_g.addColorStop(0.75, 'rgba(51,51,255,0)');
      consumGraph.graph_canvas_gradiant_g.addColorStop(1, 'rgba(51,51,255,0.5)');*/

      infoDisplay.accelerometer.css({opacity: 0})
      infoDisplay.infoValues.css({opacity: 0})
      infoDisplay.infoValuesTxt = { range: hu('#rangeTxt', infoDisplay.infoValues),
        now: hu('#nowTxt', infoDisplay.infoValues),
        avg: hu('#avgTxt', infoDisplay.infoValues),
        odo: hu('#odoTxt', infoDisplay.infoValues),
      };

      // nav
      navDisplay.root = hu('#navigation', svg);
      navDisplay.overlay = hu('#MapOverlay', navDisplay.root);

      // animations
      speedoDisplay.root.attr({class: "fade-in"}).on('webkitAnimationEnd', function (){
        //speedoDisplay.needle.attr({class: "rotate"});
      });
      speedoInitialised = true;
      speedoDisplay.needle.on('webkitAnimationEnd', function (){
        speedoInitialised = true;
      });

      speedoDisplay.speedometerText.attr({class: "grow"})
      infoDisplay.root.attr({class: "slide-right"});
      navDisplay.root.attr({class: "slide-left"});
      var background = hu('#background', svg);
      background.attr({class: 'map-fade'})

      // gradients
      overlayGradient.stop1 = hu('#overlayStop1', svg);
      overlayGradient.stop2 = hu('#overlayStop2', svg);
      backgroundGradient.stop1 = hu('#bgStop1', svg);
      backgroundGradient.stop2 = hu('#bgStop2', svg);
      navMarkerGradient.stop1 = hu('#navStop1', svg);
      navMarkerGradient.stop2 = hu('#navStop2', svg);

      electrics.root = hu('#lights_layer', svg);
      electrics.lights.signal_L = hu("#light_signal_L", electrics.root);
      electrics.lights.signal_R = hu("#light_signal_R", electrics.root);
      electrics.lights.lights = hu("#light_lights", electrics.root);
      electrics.lights.highbeam = hu("#light_highbeam", electrics.root);
      electrics.lights.fog = hu("#light_fog", electrics.root);
      electrics.lights.lowpressure = hu("#light_lowpressure", electrics.root);
      electrics.esc = hu("#light_escActive", electrics.root);
      electrics.lights.parkingbrake = hu("#light_parkingbrake", electrics.root);
      electrics.lights.checkengine = hu("#light_checkengine", electrics.root);
      electrics.lights.lowfuel = hu("#light_battery", electrics.root);
      electrics.fuelTxt = hu("#fuel_pc", infoDisplay.root);
      electrics.fuelStops = [hu("#stop_fuel1", svg), hu("#stop_fuel2", svg)];
	  electrics.turboBoostStops = [hu("#stop_boostBar1", svg), hu("#stop_boostBar2", svg)];
	  electrics.turboBoostStokeStops = [hu("#stop_boostBarStroke1", svg), hu("#stop_boostBarStroke2", svg)];
	  electrics.oilStops = [hu("#stop_oilTempBar1", svg), hu("#stop_oilTempBar2", svg)];
	  electrics.oilStokeStops = [hu("#stop_oilTempBarStoke1", svg), hu("#stop_oilTempBarStoke2", svg)];
	  electrics.waterStops = [hu("#stop_waterTempBar1", svg), hu("#stop_waterTempBar2", svg)];
	  electrics.waterStokeStops = [hu("#stop_waterTempBarStoke1", svg), hu("#stop_waterTempBarStoke2", svg)];

	  EnginePowerPage.root = hu('#EnginePowerPage', svg);
	  EnginePowerPage.HpPowerValue = hu('#HpPowerValue', EnginePowerPage.root);
	  EnginePowerPage.NmPowerValue = hu('#NmPowerValue', EnginePowerPage.root);
	  electrics.currentPowerStops = [hu("#stop_currentPower1", svg), hu("#stop_currentPower2", svg)];
	  electrics.currentTorqueStops = [hu("#stop_currentTorque1", svg), hu("#stop_currentTorque2", svg)];
	  electrics.currentPowerStokeStops = [hu("#stop_currentPowerStoke1", svg), hu("#stop_currentPowerStoke2", svg)];
	  electrics.currentTorqueStokeStops = [hu("#stop_currentTorqueStoke1", svg), hu("#stop_currentTorqueStoke2", svg)];

      if(new Date().getDate() ==1 && new Date().getMonth() == 3){
        var ellogo = hu('#imageLogo', svg);
        if(ellogo)ellogo.attr({href: "/core/art/missingTexture.png"});
      }
      setTheme(200);

      //default `Comfort` display graph and conso
      infoDisplay.accelerometer.css({opacity: 0});
      consumGraph.root.css({opacity: 1});
      consumGraph.graph_canvas.style.display = "inline";
      infoDisplay.infoValues.css({opacity: 1});
    }
	
	function updateGearIndicator(data) {
      // only update when gear is changed
      if (currentGear !== data.electrics.gear) {
        currentGear = data.electrics.gear;
		
		if (data.electrics.gear === "P") {
		speedoDisplay.GearValue.text(data.electrics.gear).css({ opacity: 0 });
		}
		else {
            speedoDisplay.GearValue.text(data.electrics.gear).css({ opacity: 1 });
          }
		  
        for (var key in speedoDisplay.gears) {
          if (key === data.electrics.gear || (data.electrics.gear > "S" && key === "D")) {
            speedoDisplay.gears[key].css({ fill: '#FFFFFF' });
			speedoDisplay.gearsBOX[key].css({ stroke: '#FFFFFF', opacity: 1 });
          }
          else if (data.electrics.gear === "P" || data.electrics.gear === "R" || data.electrics.gear === "N") {
                speedoDisplay.gears["D"].css({ fill: '#616161' });
                speedoDisplay.gearsBOX["D"].css({ opacity: 0 });
				speedoDisplay.gears[key].css({ fill: '#616161' });
			speedoDisplay.gearsBOX[key].css({ stroke: '#616161', opacity: 0 });
          }
		  else {
            speedoDisplay.gears[key].css({ fill: '#616161' });
			speedoDisplay.gearsBOX[key].css({ stroke: '#616161', opacity: 0 });
          }
        }
      }
    }
	
	function updateSpeedDisplays(data) {
      if (speedoInitialised) {
        speedoDisplay.speedValue.text((data.electrics.wheelspeed * (unit=="metric"?3.6:2.23694) ).toFixed(0));
      }
    }
	
	function updateDateTimeDisplays(data) {
		DatePage.dateValues.text(data.customModules.MERSenvironmentData.date)
		DatePage.weekdayText.text(data.customModules.MERSenvironmentData.weekday)
		speedoDisplay.timeValue.text(data.customModules.MERSenvironmentData.time)
		if(units.uiUnitTemperature == "c" || units.uiUnitTemperature == "k"){
        let envTemp = data.customModules.MERSenvironmentData.temperatureEnv
		speedoDisplay.outside_temp.text( envTemp.toFixed(0) );
        speedoDisplay.temp_unit.text( "°C" );
      }else{
        let envTemp = (data.customModules.MERSenvironmentData.temperatureEnv * 9/5) + 32
		speedoDisplay.outside_temp.text( envTemp.toFixed(0) );
        speedoDisplay.temp_unit.text( "°F" );
      }
    }
	
	function updateTachoDisplays(data) {
    if (speedoInitialised) {
        var startAngle = -201 * Math.PI / 180;
        var rpmRad = (data.electrics.rpmTacho * 0.00052) + startAngle;
        var maxRad = (211.5 * Math.PI / 180) + startAngle;
        rpmRad = Math.min(rpmRad, maxRad);

        if (Math.abs(rpmRad - prevRpmAng) < 0.01) { 
            return; 
        }

        var centerX = 67.7, centerY = 36.8, radiusInt = 22.6, radiusExt = 22.2, largeArcFlag= ((rpmRad-startAngle)>Math.PI)? 1 : 0;
        var sx2 = (centerX) + Math.cos(startAngle) * radiusInt;
        var sy2 = (centerY) + Math.sin(startAngle) * radiusInt;

        var sx1 = (centerX) + Math.cos(startAngle) * radiusExt;
        var sy1 = (centerY) + Math.sin(startAngle) * radiusExt;

        var ex2 = (centerX) + Math.cos(rpmRad) * radiusExt;
        var ey2 = (centerY) + Math.sin(rpmRad) * radiusExt;

        var ex1 = (centerX) + Math.cos(rpmRad) * radiusInt;
        var ey1 = (centerY) + Math.sin(rpmRad) * radiusInt;

        var mx1 = (centerX) + Math.cos(rpmRad) * 11;
        var my1 = (centerY) + Math.sin(rpmRad) * 11;

        speedoDisplay.needle_bar.attr({d: "M " + sx1 + "," + sy1 +
          " A" + radiusExt  + "," + radiusExt  + " 0 "+largeArcFlag+",1 " + ex2 + "," + ey2 +
          " L " + ex1 + "," + ey1 +
          " A" + radiusInt + "," + radiusInt + " 0 "+largeArcFlag+",0 " + sx2 + "," + sy2});
        speedoDisplay.needle.attr({d: "M " + ex1 + "," + ey1 + " " +mx1+","+my1});
		
		for(var E in speedoDisplay.needle_gradients){
          speedoDisplay.needle_gradients[E].attr({cx:ex1,cy:ey1,fx:ex1,fy:ey1});
        }
		
        prevRpmAng = rpmRad;
    }
}

    function limitVal(min, val,max){
        return Math.min(Math.max(min,val), max);
    }

    function updateAccelerometer(data) {
      gMeterPage.root.css({opacity: 1})
      gMeterPage.accelerometerMarker.css({transformOrigin: '50% 50%', transform: `translate(${limitVal(-10,data.customModules.accelerationData.xSmooth,10)/1.4}px, ${-limitVal(-10,data.customModules.accelerationData.ySmooth,10)/1.4}px`})
      var roundedGX2 = (data.customModules.accelerationData.xSmooth / 10).toFixed(1);
      var roundedGY2 = (-data.customModules.accelerationData.ySmooth / 10).toFixed(1);
      gMeterPage.gXPositive.text(roundedGX2 > 0 ? roundedGX2  : 0)
      gMeterPage.gXNegative.text(roundedGX2 < 0 ? -roundedGX2 : 0)
      gMeterPage.gYNegative.text(roundedGY2 > 0 ? roundedGY2  : 0)
      gMeterPage.gYPositive.text(roundedGY2 < 0 ? -roundedGY2 : 0)
    }

    $window.redrawSpeedoTicks = (lim,bigSep,smallSep) => {
      var startAngle=-227*Math.PI/180;
      var centerX=67.4, centerY=33, radiusInt=17, radiusExt=19, radiusIntBig=16;
      var tickD = "";
      for(var ib = 0; ib<= (lim/bigSep) ; ib++){
        for(var is = 0; is<= (bigSep/smallSep); is++){
          var curAng = (ib*270/(lim/bigSep)+270*(1/(lim/bigSep))*(is/(bigSep/smallSep))) *Math.PI/180;
          if(curAng > (1.5*Math.PI)){break;}
          //console.log( (ib*270/(lim/bigSep)+270*(1/(lim/bigSep))*(is/(bigSep/smallSep))) , curAng);
          //console.log( "b=", ib*270/(lim/bigSep) , "s=", 270*(1/(lim/bigSep))*(is/(bigSep/smallSep)))
          var sx2 = (centerX) + Math.cos(startAngle+curAng) * (is===0?radiusIntBig:radiusInt);
          var sy2 = (centerY) + Math.sin(startAngle+curAng) * (is===0?radiusIntBig:radiusInt);

          var sx1 = (centerX) + Math.cos(startAngle+curAng) * radiusExt;
          var sy1 = (centerY) + Math.sin(startAngle+curAng) * radiusExt;
          tickD += "M "+(sx1)+","+(sy1)+" "+(sx2)+","+(sy2)+" ";
        }
      }
      speedoDisplay.speedTicks.attr({d: tickD});
      var testStyle = {"font-style":"normal","font-weight":"bold","font-stretch":"normal","font-family":"Arial","fill":"#ffffff","fill-opacity":1,"stroke-width":0.04861574,"text-align":"center","text-anchor":"middle"};
      speedoDisplay.speedTicksText.empty();
      for(var ib = 0; ib<=(lim/bigSep) ; ib++){
        var curAng = (ib*270/(lim/bigSep)) *Math.PI/180;
        var sx = (centerX) + Math.cos(startAngle+curAng) * 14;
        var sy = (centerY + 0.90) + Math.sin(startAngle+curAng) * 14;
        var ts = hu('<tspan>', speedoDisplay.speedTicksText)
        .attr({x: sx,y: sy})
        .text((ib*bigSep))
        .css(testStyle);
      }
    }

    // overwriting plain javascript function so we can access from within the controller
    $window.setup = (data) => {
      //console.log("setUnits", data.unit);
      unit = data.uiUnitLength;
      if( unit == "metric"){
        redrawSpeedoTicks(data.maxKPH,data.speedoMetricSepBig,data.speedoMetricSepSmall);
        unitspeedratio = 3.6/data.maxKPH*Math.PI*1.5;
        speedoDisplay.speedUnit.text("km/h");
      }
      else{
        redrawSpeedoTicks(data.maxMPH,data.speedoImperialSepBig,data.speedoImperialSepSmall);
        unitspeedratio = 2.23694/data.maxMPH*Math.PI*1.5;
        speedoDisplay.speedUnit.text("mph");
      }
    }


    $window.initMap = (data) => {
      navDimensions = data.viewParams = [
        data.terrainOffset[0],
        data.terrainOffset[1],
        data.terrainSize[0],
        data.terrainSize[1]
      ];

      $scope.$apply(() => {
        vm.mapData = data;
      });

      navContainer.style.width = data.terrainSize[0] + "px";
      navContainer.style.height = data.terrainSize[1] + "px";
    }

    $window.updateMap = (data) => {
      var focusX = -data.x;
      var focusY = data.y;
      var origin = `${((navDimensions[0] * -1)) - focusX}px ${((navDimensions[1] * -1)) - focusY}px`;
      navContainer.style.transformOrigin = origin;
      var translateX = ((((navDimensions[0])) + 512) + focusX);
      var translateY = ((((navDimensions[1])) + 256) + focusY);
      navContainer.style.transform = `translate3d(${translateX}px,${translateY}px, 0px) rotateX(${55}deg) rotateZ(${180 + (data.rotation + 360)}deg) scale(1)`;
    }

    var hue = 0;

    function updateConsumption(data) {
      infoDisplay.infoValuesTxt.now.text( (data.customModules.combustionEngineData.currentPower).toFixed(0) + " kW" ); //PS

      if(data.customModules.combustionEngineData.averagePower == undefined || data.customModules.combustionEngineData.remainingRange == undefined){return;}
      infoDisplay.infoValuesTxt.avg.text( (data.customModules.combustionEngineData.averagePower).toFixed(0) + " kW" ); //PS
      infoDisplay.infoValuesTxt.range.text( (data.customModules.combustionEngineData.remainingRange).toFixed(0) + (unit==="metric"?" km":" mi") );
	  
	  const maxPowerPs = 639;
	  const maxPowerNm = 708;
	  
	  // Целевое значение для шкалы
	  const OffsetcurrentPower = Math.min(Math.max(data.customModules.combustionEngineData.currentPower / maxPowerPs, 0), 1); //PS
	  EnginePowerPage.HpPowerValue.text( (data.customModules.combustionEngineData.currentPower).toFixed(0)); //PS
	  
	  const OffsetcurrentTorque = Math.min(Math.max(data.customModules.combustionEngineData.currentTorque / maxPowerNm, 0), 1); //Nm
	  EnginePowerPage.NmPowerValue.text( (data.customModules.combustionEngineData.currentTorque).toFixed(0)); //Nm
	  
	  // Шкала combustionEngineData
	  if (electrics.currentPowerStops[0] && electrics.currentPowerStops[1]) { 
	      electrics.currentPowerStops[0].attr({ offset: OffsetcurrentPower });
	      electrics.currentPowerStops[1].attr({ offset: OffsetcurrentPower + 0.001 });
	  }
	  if (electrics.currentPowerStokeStops[0] && electrics.currentPowerStokeStops[1]) { 
	      electrics.currentPowerStokeStops[0].attr({ offset: OffsetcurrentPower });
	      electrics.currentPowerStokeStops[1].attr({ offset: OffsetcurrentPower + 0.001 });
	  }
	  if (electrics.currentTorqueStops[0] && electrics.currentTorqueStops[1]) {
	      electrics.currentTorqueStops[0].attr({ offset: OffsetcurrentTorque });
	      electrics.currentTorqueStops[1].attr({ offset: OffsetcurrentTorque + 0.001 });
	  }
	  if (electrics.currentTorqueStokeStops[0] && electrics.currentTorqueStokeStops[1]) {
	      electrics.currentTorqueStokeStops[0].attr({ offset: OffsetcurrentTorque });
	      electrics.currentTorqueStokeStops[1].attr({ offset: OffsetcurrentTorque + 0.001 });
	  }
    }


    function setElec(val, state, key){
      if( val === undefined || val === null){/*console.error("setElec: svg element not found", key);*/ return;}
      if( state === undefined || state === null){/*console.error("setElec: state not found", key);*/ return;}
      var cssState = (state===true || state>0.1)?"inline":"none";
      val.n.style.display = cssState;
    }

    $window.updateElectrics = (data) => {
      for(var k in electrics.lights){
        setElec(electrics.lights[k], data.electrics[k], k);
      }

      electrics.fuelTxt.text("🗲"+(data.electrics.fuel*100.0).toFixed(0) + "%")
      electrics.fuelStops[0].attr({offset: data.electrics.fuel})
      electrics.fuelStops[1].attr({offset: data.electrics.fuel+0.001})
	  
	  const turboBoostPSI = data.electrics.turboBoost || 0;
	  const turboBoostBAR = turboBoostPSI * 0.0689476; // Конвертация в бар

	  electrics.turboBoostStops[0].attr({ offset: turboBoostBAR });
	  electrics.turboBoostStops[1].attr({ offset: turboBoostBAR + 0.001 });
	  electrics.turboBoostStokeStops[0].attr({ offset: turboBoostBAR });
	  electrics.turboBoostStokeStops[1].attr({ offset: turboBoostBAR + 0.001 });
	  
	  if(units.uiUnitTemperature == "c" || units.uiUnitTemperature == "k"){
		
		// температура воды
		let envTempWater = data.electrics.watertemp
		TempPage.waterTempValue.text( envTempWater.toFixed(0) );
		
		// температура масла
		let envTempOil = data.electrics.oiltemp
		TempPage.oilTempValue.text( envTempOil.toFixed(0) );
		
        TempPage.tempWater_unit.text( "°C" );
		TempPage.tempOil_unit.text( "°C" );
      }
	  else{
		
		// температура воды
		let envTempWater = (data.electrics.watertemp * 9/5) + 32
		TempPage.waterTempValue.text( envTempWater.toFixed(0) );
		
		// температура масла
		let envTempOil = (data.electrics.oiltemp * 9/5) + 32
		TempPage.oilTempValue.text( envTempOil.toFixed(0) );
		
        TempPage.tempWater_unit.text( "°F" );
		TempPage.tempOil_unit.text( "°F" );
      }
	  
	  // Переменная для текущего значения температуры воды (начинаем с 0)
    let currentWaterTemp = 0;

    // Скорость изменения (0.1 = медленно, 0.5 = быстрее)
    const changeSpeed = 0.978;
	
    // Функция для масштабирования
    const scaleToOffset = (value, min, max) => {
        return Math.min(Math.max((value - min) / (max - min), 0), 1);
    };
	
	// Целевое значение температуры воды
    const targetWaterTemp = scaleToOffset(data.electrics.watertemp || 0, 50, 130);
	
	// Целевое значение температуры масла
    const oilTempOffset = scaleToOffset(data.electrics.oiltemp || 0, 30, 185);
	
	// Интерполяция для плавного изменения температуры воды
    currentWaterTemp += (targetWaterTemp - currentWaterTemp) * changeSpeed; 
	  
	// Обновляем градиент
    if (electrics.waterStops[0] && electrics.waterStops[1]) {
        electrics.waterStops[0].attr({ offset: currentWaterTemp });
        electrics.waterStops[1].attr({ offset: currentWaterTemp + 0.001 });
    }
	if (electrics.waterStokeStops[0] && electrics.waterStokeStops[1]) {
        electrics.waterStokeStops[0].attr({ offset: currentWaterTemp });
        electrics.waterStokeStops[1].attr({ offset: currentWaterTemp + 0.001 });
    }
	
	if (electrics.oilStops[0] && electrics.oilStops[1]) {
        electrics.oilStops[0].attr({ offset: oilTempOffset });
        electrics.oilStops[1].attr({ offset: oilTempOffset + 0.001 });
    }
	if (electrics.oilStokeStops[0] && electrics.oilStokeStops[1]) {
        electrics.oilStokeStops[0].attr({ offset: oilTempOffset });
        electrics.oilStokeStops[1].attr({ offset: oilTempOffset + 0.001 });
    }

      electrics.esc.n.style.display = (data.electrics["escActive"] || data.electrics["esc"]==1 || data.electrics["tcsActive"] || data.electrics["tcs"]==1 ) ?"inline":"none";
      if( electrics.esc.n.classList.contains("blink") !== (data.electrics["escActive"] || data.electrics["tcsActive"])){
        electrics.esc.n.classList.toggle("blink", (data.electrics["escActive"] || data.electrics["tcsActive"]));
      }
      if(data.electrics.odometer){
        let val = data.electrics.odometer
        val *= (unit=="metric")?0.001:0.0006215;
        val = Math.min(val,999999)
        infoDisplay.infoValuesTxt.odo.text( val.toFixed(0) + (unit==="metric"?" km":" mi") );
      }
    }

    $window.updateData = (data) => {
      if (data) {
        if(!ready){console.log("not ready");return;}
        // console.log(data);
        //hue = (hue+.5) % 360;
        //setTheme(hue);

        // Update PRNDS display
        updateGearIndicator(data);
        // Update Speed displays
        updateTachoDisplays(data);
		updateSpeedDisplays(data);
		updateDateTimeDisplays(data);

        updateConsumption(data);
        //updateConsumption( Math.sin( hue*8*Math.PI/45)*600+300 );

        updateElectrics(data);
		$window.setTirePressure(data.customModules.tireData.pressures);

        if (gForcesVisible === true) {
          updateAccelerometer(data);
        }
      }
    }
	
	$window.setTirePressure = (data) => {
    if (!data) return;

    const scaleFactor = 6.5; // Коэффициент масштабирования данных (для нормализации)
    const psiToBar = 0.0689476; // Коэффициент преобразования PSI → Bar

    // Обновляем отображение давления
    for (let tire in data) {
        let rawPressureValue = data[tire]; // Давление из данных (например, 195)
        
        // Нормализуем данные: делим на коэффициент масштабирования
        const normalizedPressure = rawPressureValue / scaleFactor;

        // Преобразуем PSI в Bar
        const pressureInBar = normalizedPressure * psiToBar;

        // Устанавливаем значение давления с одной десятичной цифрой
        TirePresPage.tires_pressure[tire].text(pressureInBar.toFixed(1));
		TirePresPage.tires_pressurePSI[tire].text(normalizedPressure.toFixed(1));
    }
	};

    //https://stackoverflow.com/a/56266358
    function isColor(strColor){
      var s = new Option().style;
      s.color = strColor;
      return s.color !== "";
    }

    function parseColor(strColor){
      var s = new Option().style;
      s.color = strColor;
      return s.color;
    }

    function getHue(rgb){
      let sep = rgb.indexOf(",") > -1 ? "," : " ";
      rgb = rgb.substr(4).split(")")[0].split(sep);

      for (let R in rgb) {
        let r = rgb[R];
        if (r.indexOf("%") > -1)
          rgb[R] = Math.round(r.substr(0,r.length - 1) / 100 * 255);
      }

      // Make r, g, and b fractions of 1
      let r = rgb[0] / 255,
          g = rgb[1] / 255,
          b = rgb[2] / 255;


      // Find greatest and smallest channel values
      let cmin = Math.min(r,g,b),
          cmax = Math.max(r,g,b),
          delta = cmax - cmin,
          h = 0,
          s = 0,
          l = 0;

      // Calculate hue
      // No difference
      if (delta == 0)
        h = 0;
      // Red is max
      else if (cmax == r)
        h = ((g - b) / delta) % 6;
      // Green is max
      else if (cmax == g)
        h = (b - r) / delta + 2;
      // Blue is max
      else
        h = (r - g) / delta + 4;

      h = Math.round(h * 60);

      // Make negative hues positive behind 360°
      if (h < 0)
          h += 360;
      return h;
    }

    $window.updateMode = (data) => {
      if(!ready){
        console.log("calling updateMode while svg not fully loaded");
        setTimeout(function(){ $window.updateMode(data) }, 100);
        return;
      }
      if(data === null
      || data === undefined
      || data.modeName === null
      || data.modeName === undefined
      || typeof data.modeName !== "string"
      || data.modeColor === null
      || data.modeColor === undefined
      || typeof data.modeColor !== "string"){
        console.error("updateMode receive wrong arguments :", data);
        document.getElementById("layer_wip").style.display = "inline";
        document.getElementById("tspan995").innerHTML = "MODE";
        return;
      }
      if(!isColor(data.modeColor)){
        console.error("This mode color is not in html format :",data.modeColor)
        return;
      }
      //console.log(data.modeColor);
      let h = getHue(parseColor(data.modeColor));
      setTheme(h);

      gForcesVisible = data.modeName != "Comfort";

      const modeSettings = {
      Comfort: {
          text: "C",
          display: { DatePage: "inline", TempPage: "inline", gMeterPage: "none", InfoPage: "none", TirePresPage: "none", EnginePowerPage: "none" },
          transforms: { DatePage: "translate(-0.0px, 0px)", TempPage: "translate(-0.0px, 0px)", InfoPage: "translate(-40.9px, 0px)", gMeterPage: "translate(120.9px, -4.89px)", EnginePowerPage: "translate(-50.9px, 0px)" },
          animations: { gMeterPage: "fadeout 0.5s forwards"},
          delayedHide: ["gMeterPage", "TirePresPage", "InfoPage"] // delayedHide тут прописывается что должно в данной стабилизации отключится после прошлой стабилизации
      },
      Sport: {
          text: "S",
          display: { gMeterPage: "inline", EnginePowerPage: "inline", TirePresPage: "none" },
          transforms: { DatePage: "translate(40.9px, 0px)", gMeterPage: "translate(80.9px, -4.89px)", TempPage: "translate(-50.9px, 0px)", TirePresPage: "translate(120.9px, -4.89px)", EnginePowerPage: "translate(0px, 0px)" },
          animations: { DatePage: "fadeout 0.5s forwards", gMeterPage: "fadein 2s forwards", TempPage: "fadeout 0.5s forwards", EnginePowerPage: "fadein 2s forwards"},
          delayedHide: ["DatePage", "TempPage"]
      },
      "Sport+": {
          text: "S+",
          display: { TirePresPage: "inline", InfoPage: "inline"},
          transforms: { gMeterPage: "translate(120.9px, -4.89px)", TirePresPage: "translate(-0.0px, 0px)", InfoPage: "translate(0px, 0px)", EnginePowerPage: "translate(-50.9px, 0px)"},
          animations: { gMeterPage: "fadeout 0.5s forwards", TirePresPage: "fadein 2s forwards", InfoPage: "fadein 2s forwards", EnginePowerPage: "fadeout 0.5s forwards"},
          delayedHide: ["gMeterPage", "TempPage"]
      },
      Off: {
          text: "Off",
          display: { DatePage: "inline", TempPage: "inline"},
          transforms: { DatePage: "translate(-0.0px, 0px)", TempPage: "translate(-0.0px, 0px)", TirePresPage: "translate(120.9px, -4.89px)", InfoPage: "translate(-40.9px, 0px)" },
          animations: { DatePage: "fadein 2s forwards", TempPage: "fadein 2s forwards", TirePresPage: "fadeout 0.5s forwards", InfoPage: "fadeout 0.5s forwards" },
		  delayedHide: ["TirePresPage", "InfoPage"]
      }
  };

      if (modeSettings[data.modeName]) {
          const settings = modeSettings[data.modeName];

          speedoDisplay.ModeText.text(settings.text).css({ fill: "#FFFFFF" });
          speedoDisplay.ModeBOX.css({ stroke: data.modeColor });

          // Устанавливаем display, но не скрываем сразу те, что в delayedHide
          ["DatePage", "gMeterPage", "TirePresPage", "InfoPage", "TempPage", "EnginePowerPage"].forEach((page) => {
              if (settings.display.hasOwnProperty(page)) {
                  eval(page).root.n.style.display = settings.display[page];
              }
          });

          Object.entries(settings.transforms || {}).forEach(([key, value]) => {
              eval(key).root.css({ transform: value });
          });

          Object.entries(settings.animations || {}).forEach(([key, value]) => {
              eval(key).root.css({ animation: value });
          });

          if (settings.delayedHide) {
              setTimeout(() => {
                  settings.delayedHide.forEach((page) => {
                      eval(page).root.n.style.display = "none";
                  });
              }, 700);
          }
      };
	  
	  if (gForcesVisible === true) {
        consumGraph.root.css({opacity: 0});
        infoDisplay.infoValues.css({opacity: 0});
        consumGraph.graph_canvas.style.display = "none";
      }
      else {
        infoDisplay.accelerometer.css({opacity: 0});
        consumGraph.root.css({opacity: 1});
        consumGraph.graph_canvas.style.display = "inline";
        infoDisplay.infoValues.css({opacity: 1});
      }

    }
    ready = true;
    //$window.updateConsumption({current:0, average:0, range:0});
  });