-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

local tag = 'door_latch_r'

local prev_kashiradoorr = 0

local function onInit()
    electrics.values.kashiradoorr = 0
    prev_kashiradoorr = 1  -- opposite to the current value will cause the state switch code to trigger once
end

local function updateGFX(dt)
    if electrics.values.kashiradoorr ~= prev_kashiradoorr then
      if electrics.values.kashiradoorr == 0 then
        beamstate.attachCouplers(tag)
      else
          beamstate.detachCouplers(tag)
      end
      prev_kashiradoorr = electrics.values.kashiradoorr
    end
end

local function onCouplerAttached(nodeId, obj2id, obj2nodeId)
end

local function onCouplerDetached(nodeId, obj2id, obj2nodeId)
end 



-- public interface
M.onCouplerAttached = onCouplerAttached
M.onCouplerDetached = onCouplerDetached

M.onInit      = onInit
M.onReset     = onInit
M.updateGFX = updateGFX

return M
