-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt
local M = {}
M.type = "auxilliary"
M.relevantDevice = nil


local function onInit()
    electrics.values['4ws'] = 0
end

local function updateGFX(dt)
    if not electrics.values['steering_input'] then return end
    local speed = electrics.values["wheelspeed"]
    local steer = -electrics.values['steering_input']
    local absSteer = math.abs(steer)
    local rws = 0
    local multiplier = ((speed ^2)- 500) * 0.002
    if multiplier >= 1 then
        rws = absSteer * 0.8
        rws = rws * fsign(steer)
    elseif multiplier <= -1 then
        rws = absSteer * -1
        rws = rws * fsign(steer)
	else
        rws = absSteer * multiplier 
        rws = rws * fsign(steer)
	end
        electrics.values['4ws'] = rws
        
end

-- public interface
M.onInit      = onInit
M.onReset     = onInit
M.updateGFX = updateGFX

return M