angular.module('gaugesScreen', [])
.controller('GaugesScreenController', function($scope, $window) {

	  const rpmMax = 7000;
  const speedMax = 330;
  const tempMax = 130;
  const fuelMax = 100;
  const oilTempMax = 150;
  
  
  var units = {uiUnitConsumptionRate: "metric",
  uiUnitDate: "ger",
  uiUnitEnergy: "metric",
  uiUnitLength: "metric",
  uiUnitPower: "hp",
  uiUnitPressure: "bar",
  uiUnitTemperature: "c",
  uiUnitTorque: "metric",
  uiUnitVolume: "l",
  uiUnitWeight: "kg"};
  
  $scope.data = {};

  let lastRpm = 0, targetRpm = 0;
  let lastSpeed = 0, targetSpeed = 0;
  let lastTemp = 0, targetTemp = 0;
  let lastFuel = 0, targetFuel = 0;
  let lastOil = 0, targetOil = 0;
  let lastFuelCons = 0, targetFuelCons = 0;


  function animateNeedles() {
    lastRpm += (targetRpm - lastRpm) * 0.2;
    lastSpeed += (targetSpeed - lastSpeed) * 0.2;
    lastTemp += (targetTemp - lastTemp) * 0.2;
    lastFuel += (targetFuel - lastFuel) * 0.2;
    lastOil += (targetOil - lastOil) * 0.2;

    const rpmNeedle = document.querySelector('.needle-rpm');
    if (rpmNeedle) {
      const angle = -0.8 + (lastRpm / rpmMax) * 235;

  rpmNeedle.style.transform = `rotate(${angle}deg)`;
    }

    const speedNeedle = document.querySelector('.needle-speed');
    if (speedNeedle) {
		const isMetric = units.uiUnitLength === "metric";
const currentSpeedMax = isMetric ? 330 : 200;
const angle = -0.8 + (lastSpeed / currentSpeedMax) * 293;
speedNeedle.style.transform = `rotate(${angle}deg)`;

    }

const tempNeedle = document.querySelector('.needle-temp');
if (tempNeedle) {
  const minTemp = 30;
  const maxTemp = 130;
  const minAngle = 28.8; // начальное положение стрелки при 60°C
  const maxAngle = -28.8;  // конечное положение стрелки при 130°C

  const clampedTemp = Math.max(minTemp, Math.min(lastTemp, maxTemp));
  const angle = minAngle + ((clampedTemp - minTemp) / (maxTemp - minTemp)) * (maxAngle - minAngle);

  tempNeedle.style.transform = `rotate(${angle}deg)`;
}

    const fuelNeedle = document.querySelector('.needle-fuel');
    if (fuelNeedle) {
      const angle = 28.8 + (lastFuel / fuelMax) * -57.4;
      fuelNeedle.style.transform = `rotate(${angle}deg)`;
    }

    const oilNeedle = document.querySelector('.needle-oil');
    if (oilNeedle) {
      const angle = -150 + (lastOil / oilTempMax) * 130;
      oilNeedle.style.transform = `rotate(${angle}deg)`;
    }

    requestAnimationFrame(animateNeedles);
  }

  animateNeedles();


  $window.setup = (setupData) => {
    for(let dk in setupData){
      if(typeof dk == "string" && dk.startsWith("uiUnit")){
        units[dk] = setupData[dk];
      }
    }
    vueEventBus.emit('SettingsChanged', {values:units})

    $scope.data.speedUnit = units.uiUnitLength=="metric"?"km/h":"mph";
  };

  $window.updateData = (data) => {
    $scope.$evalAsync(() => {

      const rpm = data.electrics.rpm || 0;
      const speed = UiUnits.speed(data.electrics.wheelspeed).val.toFixed(0);
      const fuel = data.electrics.fuel || 0;
      const coolant = data.electrics.watertemp || 0; 
      const odometer = data.electrics.odometer || 0;
      const oiltemp = data.electrics.oiltemp || 0;
      const time = data.customModules?.environmentData?.time || "--:--";
      const currentFuelConsumption = data.customModules?.combustionEngineData?.currentFuelConsumption || 0;

      targetRpm = rpm;
      targetSpeed = speed;
      targetFuel = fuel * 100;
      targetTemp = coolant;
      targetOil = oiltemp;
      targetFuelCons = currentFuelConsumption;


      $scope.data.engineRpm = Math.round(rpm);

	 
      $scope.data.speedUnit = (units.uiUnitLength === "metric") ? "km/h" : "mph";
      $scope.data.engineRpm = Math.round(rpm);
      $scope.data.fuel = Math.round(fuel * 100);
      $scope.data.speedVal = Math.round(speed);
      $scope.data.time = time;
	  
	 
	
if (data.electrics.odometer) {
  let val = data.electrics.odometer;
  val *= (units.uiUnitLength === "metric") ? 0.001 : 0.0006215;
  val = Math.min(999999, val);

  let intPart = Math.floor(val).toString().padStart(6, "0");

  $scope.data.odo = `${intPart}${units.uiUnitLength === "metric" ? "km" : "mi"}`;
} else {
  $scope.data.odo = "";
}

      $scope.data.fuelConsumption = (units.uiUnitLength === "metric")
        ? currentFuelConsumption.toFixed(1) + " l/100km"
        : (235.2 / currentFuelConsumption).toFixed(1) + " mpg";


let temperatureEnv = data.customModules?.environmentData?.temperatureEnv;
if (units.uiUnitTemperature === 'c') {
  $scope.data.temp = (temperatureEnv > 99.9 || temperatureEnv < -99.9)
    ? "---°C"
    : temperatureEnv.toFixed(0) + " °C";
} else {
  const fahrenheit = (temperatureEnv * 9 / 5) + 32;
  $scope.data.temp = (fahrenheit > 99.9 || fahrenheit < -99.9)
    ? "---°F"
    : fahrenheit.toFixed(0) + " °F";
}


let rawGear = data.electrics.gear;

if (rawGear === -1) {
  $scope.data.gear = "R";
} else if (rawGear === 0) {
  $scope.data.gear = "N";
} else if (typeof rawGear === "string") {
  if (rawGear.startsWith("S")) {
    $scope.data.gear = "S";
  } else if (rawGear.startsWith("M")) {
    $scope.data.gear = "M";
  } else if (rawGear.startsWith("D")) {
    $scope.data.gear = "D";
  } else {
    $scope.data.gear = rawGear;
  }
} else {
  $scope.data.gear = rawGear;
}


const fuelUsed = data.engine?.fuelUsed || 0;
const distanceKm = odometer / 1000;
let avgConsumption = 15;
if (distanceKm > 0.5 && fuelUsed > 0.01) {
  avgConsumption = (fuelUsed / distanceKm) * 100;
}
const fuelCapacity = data.engine?.fuelCapacity || 90;
const fuelLiters = fuel * fuelCapacity;
let range = (fuelLiters / avgConsumption) * 100;

if (units.uiUnitLength !== "metric") {
  range *= 0.621371; // km -> mi
}

$scope.data.range = Math.round(range) + (units.uiUnitLength === "metric" ? " km" : " mi");


    });
  };
});
