-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}
M.type = "auxilliary"
M.relevantDevice = nil
M.defaultOrder = 1100

M.fuelCoef = 1

local max = math.max
local min = math.min

local fuel = 0
local initialFuel = 0
local initialFuelCoef = 0
local lastJatoInput = 0

local thrusterCount = 0
local thrusterNodes = nil

local smokeTick = 0

local thrusterLoopName = nil
local thrusterLoops = nil

local function updateGFX(dt)
  local jatoInput = min(electrics.values.jatoInput or 0, 1)
  local throttleInput = input.throttle or 0
  local gearIndex = electrics.values.gearIndex or 0
  local running = electrics.values.running or 0
  local rpm = electrics.values.rpm or 0
  local airspeed = electrics.values.airspeed or 0
  
  
  fuel = max(fuel - jatoInput * dt * M.fuelCoef, 0)

  if fuel <= 0 then
    jatoInput = 0
  end

  if running == 0 then
    jatoInput = 0
  end

    for i = 1, thrusterCount, 1 do
      local thruster = thrusterNodes[i]
	  --START UP SMOKE
	  if throttleInput >= 0 and rpm >= 400 and rpm <= 950 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 7, 2001, 0.0001, 1)
	  --IDLE
	  elseif throttleInput >= 0 and rpm >= 950 and rpm <= 1600 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 18, 2001, 0.0001, 2)
	  elseif throttleInput >= 0 and rpm >= 1601 and rpm <= 1850 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 23, 2001, 0.0001, 3)
	  elseif throttleInput >= 0 and rpm >= 1851 and rpm <= 2450 then
      jatoInput = 1
	  --ON-HIGH-LOAD SMOKE
      obj:addParticleByNodes(thruster[1], thruster[2], 24, 2001, 0.0001, 5)
	  elseif airspeed <= 18 and throttleInput >= 0.15 and rpm >= 2451 and rpm <= 2900 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 25, 2001, 0.0001, 6)
	  elseif airspeed <= 18 and throttleInput >= 0.15 and rpm >= 2901 and rpm <= 3400 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 19, 2002, 0.0001, 6)
	  elseif airspeed <= 18 and throttleInput >= 0.15 and rpm >= 3401 and rpm <= 3900 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 23, 2002, 0.0001, 6)
	  elseif airspeed <= 18 and throttleInput >= 0.15 and rpm >= 3901 and rpm <= 4500 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 24, 2002, 0.0001, 6)
	  elseif airspeed <= 18 and throttleInput >= 0.15 and rpm >= 4501 and rpm <= 4890 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 26, 2002, 0.0001, 6)
	  elseif airspeed <= 18 and throttleInput >= 0.15 and rpm >= 4891 and rpm <= 5300 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 25, 2002, 0.0001, 6)
	  elseif airspeed <= 18 and throttleInput >= 0.15 and rpm >= 5301 and rpm <= 5975 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 26, 2002, 0.0001, 6)
	  elseif airspeed <= 18 and throttleInput >= 0.15 and rpm >= 5976 and rpm <= 6820 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 30, 2002, 0.0001, 6)
	  elseif airspeed <= 18 and throttleInput >= 0.15 and rpm >= 6821 and rpm <= 7460 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 33, 2002, 0.0001, 6)
	  elseif airspeed <= 18 and throttleInput >= 0.15 and rpm >= 7461 and rpm <= 8300 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 34, 2002, 0.0001, 6)
	  elseif airspeed <= 18 and throttleInput >= 0.15 and rpm >= 8301 and rpm <= 8900 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 26, 2003, 0.0001, 6)
	  elseif airspeed <= 18 and throttleInput >= 0.15 and rpm >= 8901 and rpm <= 9400 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 28, 2003, 0.0001, 6)
	  elseif airspeed <= 18 and throttleInput >= 0.15 and rpm >= 9401 and rpm <= 10000 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 30, 2003, 0.0001, 6)
	  elseif airspeed <= 18 and throttleInput >= 0.15 and rpm >= 10001 and rpm <= 10630 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 32, 2003, 0.0001, 6)
	  elseif throttleInput >= 0 and rpm >= 1851 and rpm <= 2450 then
      jatoInput = 1
	  --ON-HIGH-LOAD HIGHER AS SMOKE
      obj:addParticleByNodes(thruster[1], thruster[2], 24, 2001, 0.0001, 3)
	  elseif airspeed <= 27 and throttleInput >= 0.15 and rpm >= 2451 and rpm <= 2900 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 25, 2001, 0.0001, 4)
	  elseif airspeed <= 27 and throttleInput >= 0.15 and rpm >= 2901 and rpm <= 3400 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 19, 2002, 0.0001, 4)
	  elseif airspeed <= 27 and throttleInput >= 0.15 and rpm >= 3401 and rpm <= 3900 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 23, 2002, 0.0001, 4)
	  elseif airspeed <= 27 and throttleInput >= 0.15 and rpm >= 3901 and rpm <= 4500 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 24, 2002, 0.0001, 4)
	  elseif airspeed <= 27 and throttleInput >= 0.15 and rpm >= 4501 and rpm <= 4890 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 26, 2002, 0.0001, 4)
	  elseif airspeed <= 27 and throttleInput >= 0.15 and rpm >= 4891 and rpm <= 5300 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 25, 2002, 0.0001, 4)
	  elseif airspeed <= 27 and throttleInput >= 0.15 and rpm >= 5301 and rpm <= 5975 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 26, 2002, 0.0001, 4)
	  elseif airspeed <= 27 and throttleInput >= 0.15 and rpm >= 5976 and rpm <= 6820 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 30, 2002, 0.0001, 4)
	  elseif airspeed <= 27 and throttleInput >= 0.15 and rpm >= 6821 and rpm <= 7460 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 33, 2002, 0.0001, 4)
	  elseif airspeed <= 27 and throttleInput >= 0.15 and rpm >= 7461 and rpm <= 8300 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 34, 2002, 0.0001, 4)
	  elseif airspeed <= 27 and throttleInput >= 0.15 and rpm >= 8301 and rpm <= 8900 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 26, 2003, 0.0001, 4)
	  elseif airspeed <= 27 and throttleInput >= 0.15 and rpm >= 8901 and rpm <= 9400 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 28, 2003, 0.0001, 4)
	  elseif airspeed <= 27 and throttleInput >= 0.15 and rpm >= 9401 and rpm <= 10000 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 30, 2003, 0.0001, 4)
	  elseif airspeed <= 27 and throttleInput >= 0.15 and rpm >= 10001 and rpm <= 10630 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 32, 2003, 0.0001, 4)
	  --ON-LOW-LOAD SMOKE
      obj:addParticleByNodes(thruster[1], thruster[2], 20, 2001, 0.0001, 1)
	  elseif throttleInput >= 0.01 and rpm >= 2451 and rpm <= 2900 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 21, 2001, 0.0001, 1)
	  elseif throttleInput >= 0.01 and rpm >= 2901 and rpm <= 3400 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 15, 2002, 0.0001, 1)
	  elseif throttleInput >= 0.01 and rpm >= 3401 and rpm <= 3900 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 19, 2002, 0.0001, 1)
	  elseif throttleInput >= 0.01 and rpm >= 3901 and rpm <= 4500 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 20, 2002, 0.0001, 1)
	  elseif throttleInput >= 0.01 and rpm >= 4501 and rpm <= 4890 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 22, 2002, 0.0001, 1)
	  elseif throttleInput >= 0.01 and rpm >= 4891 and rpm <= 5300 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 22, 2002, 0.0001, 1)
	  elseif throttleInput >= 0.01 and rpm >= 5301 and rpm <= 5975 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 23, 2002, 0.0001, 1)
	  elseif throttleInput >= 0.01 and rpm >= 5976 and rpm <= 6820 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 26, 2002, 0.0001, 1)
	  elseif throttleInput >= 0.01 and rpm >= 6821 and rpm <= 7460 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 29, 2002, 0.0001, 1)
	  elseif throttleInput >= 0.01 and rpm >= 7461 and rpm <= 8300 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 30, 2002, 0.0001, 1)
	  elseif throttleInput >= 0.01 and rpm >= 8301 and rpm <= 8900 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 22, 2003, 0.0001, 1)
	  elseif throttleInput >= 0.01 and rpm >= 8901 and rpm <= 9400 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 24, 2003, 0.0001, 1)
	  elseif throttleInput >= 0.01 and rpm >= 9401 and rpm <= 10000 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 26, 2003, 0.0001, 1)
	  elseif throttleInput >= 0.01 and rpm >= 10001 and rpm <= 10630 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 28, 2003, 0.0001, 1)
	  --OFF-LOAD SMOKE
	  elseif throttleInput >= 0 and rpm >= 2451 and rpm <= 2900 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 9, 2001, 0.0001, 1)
	  elseif throttleInput >= 0 and rpm >= 2901 and rpm <= 3400 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 4, 2002, 0.0001, 1)
	  elseif throttleInput >= 0 and rpm >= 3401 and rpm <= 3900 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 5, 2002, 0.0001, 1)
	  elseif throttleInput >= 0 and rpm >= 3901 and rpm <= 4500 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 7, 2002, 0.0001, 1)
	  elseif throttleInput >= 0 and rpm >= 4501 and rpm <= 4890 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 9, 2002, 0.0001, 1)
	  elseif throttleInput >= 0 and rpm >= 4891 and rpm <= 5300 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 12, 2002, 0.0001, 1)
	  elseif throttleInput >= 0 and rpm >= 5301 and rpm <= 5975 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 11, 2002, 0.0001, 1)
	  elseif throttleInput >= 0 and rpm >= 5976 and rpm <= 6820 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 14, 2002, 0.0001, 1)
	  elseif throttleInput >= 0 and rpm >= 6821 and rpm <= 7460 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 18, 2002, 0.0001, 1)
	  elseif throttleInput >= 0 and rpm >= 7461 and rpm <= 8300 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 19, 2002, 0.0001, 1)
	  elseif throttleInput >= 0 and rpm >= 8301 and rpm <= 8900 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 10, 2003, 0.0001, 1)
	  elseif throttleInput >= 0 and rpm >= 8901 and rpm <= 9400 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 12, 2003, 0.0001, 1)
	  elseif throttleInput >= 0 and rpm >= 9401 and rpm <= 10000 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 14, 2003, 0.0001, 1)
	  elseif throttleInput >= 0 and rpm >= 10001 and rpm <= 10630 then
      jatoInput = 1
      obj:addParticleByNodes(thruster[1], thruster[2], 16, 2003, 0.0001, 1)
    end
    smokeTick = 0
  end

  if jatoInput > 0 and lastJatoInput <= 0 then
    for i = 1, thrusterCount, 1 do
      local loop = thrusterLoops[i]
      obj:setVolume(loop, jatoInput)
      obj:cutSFX(loop)
      obj:playSFX(loop)
    end
  end

  if jatoInput <= 0 and lastJatoInput > 0 then
    for i = 1, thrusterCount, 1 do
      local loop = thrusterLoops[i]
      obj:stopSFX(loop)
    end
  end

  electrics.values.funnytingssmoke = jatoInput
  electrics.values.jatofuel = fuel * initialFuelCoef
  lastJatoInput = jatoInput
end

local function reset()
  fuel = initialFuel

  smokeTick = 0

  for i = 1, thrusterCount, 1 do
    local loop = thrusterLoops[i]
    obj:stopSFX(loop)
  end

  electrics.values.jatoInput = 0
  electrics.values.funnytingssmoke = 0
end

local function init(jbeamData)
  fuel = jbeamData.fuel or 20
  initialFuel = fuel
  if initialFuel > 0 then
    initialFuelCoef = 1 / initialFuel
  end

  smokeTick = 0

  electrics.values.jatoInput = 0
  electrics.values.funnytingssmoke = 0

  thrusterNodes = {}
  if jbeamData.thrusterNodes_nodes then
    local nodeCount = #jbeamData.thrusterNodes_nodes
    if nodeCount % 2 == 0 then
      for i = 1, nodeCount, 2 do
        table.insert(thrusterNodes, {jbeamData.thrusterNodes_nodes[i], jbeamData.thrusterNodes_nodes[i + 1]})
      end
    else
      log("E", "funnytingssmoke.init", "Even number of thruster nodes are required!")
    end
  end

  thrusterCount = #thrusterNodes

  thrusterLoopName = jbeamData.thrusterLoopName or ""
end

local function initSounds()
  thrusterLoops = {}
  for i = 1, thrusterCount, 1 do
    local thruster = thrusterNodes[i]
    local loop = obj:createSFXSource2(thrusterLoopName, "AudioDefaultLoop3D", "", thruster[1], 0)
    table.insert(thrusterLoops, loop)
  end
end

M.init = init
M.initSounds = initSounds
M.reset = reset
M.updateGFX = updateGFX

return M
