local M = {}
local function init()
   electrics.values.bootscreen_loading = 0
   electrics.values.radio_anim = 0
end
local function reset()
   init()
end
local timer = 0
local function updateGFX(dt)
   if electrics.values.ignitionLevel > 0 then
      -- Gradually increase loading effect based on timer
      if timer < 5 then
         timer = timer + dt
         electrics.values.bootscreen_loading = timer / 5 -- Smooth loading progress
      else
         electrics.values.bootscreen_loading = 1 -- Full loading after 5 seconds
      end
      electrics.values.radio_anim = 1 - electrics.values.bootscreen_loading
   else
      -- Reset values more smoothly, keeping them at their current state for a while
      timer = 0
      electrics.values.bootscreen_loading = 0
      electrics.values.radio_anim = 0
   end
end
M.onInit = init
M.onReset = init
M.updateGFX = updateGFX
return M
