-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

local function onInit()
 electrics.values.dynamic_speedoLow = 0
 electrics.values.dynamic_speedoHigh = 0
 electrics.values.dynamic_speedo = 0
 electrics.values.dynamic_speedo_fl = 0
 electrics.values.dynamic_speedo_gli = 0
end

local function updateGFX(dt)
electrics.values.dynamic_speedoLow = electrics.values.wheelspeed
electrics.values.dynamic_speedoHigh = 9.2294 + (electrics.values.wheelspeed / 1.5)
electrics.values.dynamic_speedoflHigh = 8.3060 + (electrics.values.wheelspeed / 2)
electrics.values.dynamic_speedoflHigher = 12.56 + (electrics.values.dynamic_speedoflHigh / 1.5)
electrics.values.dynamic_speedogliHigh = 11 + (electrics.values.wheelspeed / 2)
 if electrics.values.wheelspeed < 16.66 then 
    electrics.values.dynamic_speedo_fl = electrics.values.dynamic_speedoLow 
 elseif electrics.values.wheelspeed >= 16.66 and electrics.values.wheelspeed < 61.11 then 
    electrics.values.dynamic_speedo_fl = electrics.values.dynamic_speedoflHigh
 else
    electrics.values.dynamic_speedo_fl = electrics.values.dynamic_speedoflHigher
 end
 if electrics.values.wheelspeed < 22.22 then 
    electrics.values.dynamic_speedo_gli = electrics.values.dynamic_speedoLow
 else
    electrics.values.dynamic_speedo_gli = electrics.values.dynamic_speedogliHigh
 end
 if electrics.values.wheelspeed < 27.77 then 
    electrics.values.dynamic_speedo = electrics.values.dynamic_speedoLow
 else
    electrics.values.dynamic_speedo = electrics.values.dynamic_speedoHigh
 end		
end

-- public interface

M.onInit      = onInit
M.onReset     = onInit
M.updateGFX = updateGFX

return M
