-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

local function onReset()
  
  electrics.values['sunvisor_l_input'] = 0
  electrics.values['sunvisor_l'] = 0
  electrics.values['sunvisor_l_t1'] = 0
  electrics.values['sunvisor_r_input'] = 0
  electrics.values['sunvisor_r'] = 0
  electrics.values['sunvisor_r_t1'] = 0

end

function timeToRadians(currentTime, mod, dt)
  return (currentTime + dt*math.pi*2) % (math.pi*mod)
end

function cosFunc(currentTime)
  return -(-math.cos(currentTime)*0.5+0.5)
end

function updateGeneral(input, currentTime, currentValue, dt)
  local t2 = timeToRadians(currentTime, 2, dt)
  if (currentTime < math.pi and t2 > math.pi) or (currentTime < math.pi*2 and t2 < currentTime) then
    input = 0
  else
    currentValue = cosFunc(currentTime)
  end
  currentTime = t2
  return input, currentTime, currentValue
end

local function updateGFX(dt)
  if electrics.values.sunvisor_l_input == 1 then 
    electrics.values.sunvisor_l_input, electrics.values.sunvisor_l_t1, electrics.values.sunvisor_l = updateGeneral(electrics.values.sunvisor_l_input, electrics.values.sunvisor_l_t1, electrics.values.sunvisor_l, 1*dt)
  end
  if electrics.values.sunvisor_r_input == 1 then 
    electrics.values.sunvisor_r_input, electrics.values.sunvisor_r_t1, electrics.values.sunvisor_r = updateGeneral(electrics.values.sunvisor_r_input, electrics.values.sunvisor_r_t1, electrics.values.sunvisor_r, 1*dt)
  end
end

local function sunvisor_l(value) electrics.values.sunvisor_l_input = 1 end
local function sunvisor_r(value) electrics.values.sunvisor_r_input = 1 end

-- public interface
M.onInit    = onReset
M.onReset   = onReset
M.updateGFX = updateGFX

M.sunvisor_l = sunvisor_l
M.sunvisor_r = sunvisor_r

return M