'use strict';
angular.module('beamng.apps')
.directive('jcSwitches8', ['$interval', '$timeout', function ($interval, $timeout) {
  return {
    template: '<object style="width:100%; height:100%;" type="image/svg+xml" data="/ui/modules/apps/JCftswitches8/JCftswitches8.svg"></object>',
    replace: true,
    restrict: 'EA',
    scope: true,
    link: function (scope, element, attrs) {
      var streamsList = ['electrics'];
      StreamsManager.add(streamsList);
      element.on('load', function () {
        var svg = element[0].contentDocument;
        var btnStartstop = svg.getElementById('btn-startstop');
        if (btnStartstop) {
          btnStartstop.style.cursor = 'pointer';
          btnStartstop.addEventListener('mousedown', function () {
            bngApi.activeObjectLua('electrics.toggleIgnitionLevelOnDown()');
          });
          btnStartstop.addEventListener('mouseup', function () {
            bngApi.activeObjectLua('electrics.toggleIgnitionLevelOnUp()');
          });
        }
        var btnbuttonnos = svg.getElementById('btn-buttonnos');
        if (btnbuttonnos) {
          btnbuttonnos.style.cursor = 'pointer';
          btnbuttonnos.addEventListener('mousedown', function () {
            bngApi.activeObjectLua('for _,v in pairs(controller.getControllersByType("nitrousOxideInjection")) do v.toggleActive() end');
          });
        }
        var btnTwoStep = svg.getElementById('btn-twostep');
        if (btnTwoStep) {
          btnTwoStep.style.cursor = 'pointer';
          btnTwoStep.addEventListener('mousedown', function () {
            bngApi.activeObjectLua('controller.getControllerSafe("twoStepLaunch").toggleTwoStep()');
          });
        }
        var btnLineLock = svg.getElementById('btn-linelock');
        if (btnLineLock) {
          btnLineLock.style.cursor = 'pointer';
          btnLineLock.addEventListener('mousedown', function () {
            bngApi.activeObjectLua("for _,v in pairs(controller.getControllersByType('lineLock')) do v.toggleLineLock() end");
          });
        }
        var btnTransbrake = svg.getElementById('btn-transbrake');
        if (btnTransbrake) {
          btnTransbrake.style.cursor = 'pointer';
          btnTransbrake.addEventListener('mousedown', function () {
            bngApi.activeObjectLua("for _,v in pairs(controller.getControllersByType('transbrake')) do v.toggleTransbrake() end");
          });
          btnTransbrake.addEventListener('contextmenu', function (e) {
            e.preventDefault();
          });
        }
        var btnLeftArrow = svg.getElementById('btn-left-arrow');
        if (btnLeftArrow) {
          btnLeftArrow.style.cursor = 'pointer';
          btnLeftArrow.addEventListener('mousedown', function (event) {
            event.preventDefault();
            if (event.button === 0) {
              bngApi.activeObjectLua('controller.getControllerSafe("twoStepLaunch").changeTwoStepRPM(-100)');
            } else if (event.button === 2) {
              bngApi.activeObjectLua('controller.getControllerSafe("twoStepLaunch").changeTwoStepRPM(-25)');
            }
            var leftArrowCircle = svg.getElementById('circle-left-arrow');
            var leftArrowRing = svg.getElementById('ring-left-arrow');
            if (leftArrowCircle) {
              leftArrowCircle.setAttribute('fill', "#e74c3c");
              leftArrowCircle.setAttribute('filter', "url(#glow)");
            }
            if (leftArrowRing) {
              leftArrowRing.setAttribute('stroke', "#e74c3c");
              leftArrowRing.setAttribute('filter', "url(#glow)");
            }
            setTimeout(function () {
              if (leftArrowCircle) {
                leftArrowCircle.setAttribute('fill', "#808080");
                leftArrowCircle.removeAttribute('filter');
              }
              if (leftArrowRing) {
                leftArrowRing.setAttribute('stroke', "#808080");
                leftArrowRing.removeAttribute('filter');
              }
            }, 300);
          });
          btnLeftArrow.addEventListener('contextmenu', function (e) {
            e.preventDefault();
          });
        }
        var btnRightArrow = svg.getElementById('btn-right-arrow');
        if (btnRightArrow) {
          btnRightArrow.style.cursor = 'pointer';
          btnRightArrow.addEventListener('mousedown', function (event) {
            event.preventDefault();
            if (event.button === 0) {
              bngApi.activeObjectLua('controller.getControllerSafe("twoStepLaunch").changeTwoStepRPM(100)');
            } else if (event.button === 2) {
              bngApi.activeObjectLua('controller.getControllerSafe("twoStepLaunch").changeTwoStepRPM(25)');
            }
            var rightArrowCircle = svg.getElementById('circle-right-arrow');
            var rightArrowRing = svg.getElementById('ring-right-arrow');
            if (rightArrowCircle) {
              rightArrowCircle.setAttribute('fill', "#0edd0e");
              rightArrowCircle.setAttribute('filter', "url(#glow)");
            }
            if (rightArrowRing) {
              rightArrowRing.setAttribute('stroke', "#0edd0e");
              rightArrowRing.setAttribute('filter', "url(#glow)");
            }
            setTimeout(function () {
              if (rightArrowCircle) {
                rightArrowCircle.setAttribute('fill', "#808080");
                rightArrowCircle.removeAttribute('filter');
              }
              if (rightArrowRing) {
                rightArrowRing.setAttribute('stroke', "#808080");
                rightArrowRing.removeAttribute('filter');
              }
            }, 300);
          });
          btnRightArrow.addEventListener('contextmenu', function (e) {
            e.preventDefault();
          });
        }
        var btnButtonPurge = svg.getElementById('btn-buttonpurge');
        if (btnButtonPurge) {
          btnButtonPurge.style.cursor = 'pointer';
          btnButtonPurge.addEventListener('mousedown', function () {
            bngApi.activeObjectLua("for _,v in pairs(controller.getControllersByType('nitrousOxideInjection')) do v.setOverride(true) end");
            var buttonPurgeCircle = svg.getElementById('circle-buttonpurge');
            var buttonPurgeRing = svg.getElementById('ring-buttonpurge');
            if (buttonPurgeCircle) {
              buttonPurgeCircle.setAttribute('fill', "#e74c3c");
              buttonPurgeCircle.setAttribute('filter', "url(#glow)");
            }
            if (buttonPurgeRing) {
              buttonPurgeRing.setAttribute('stroke', "#e74c3c");
              buttonPurgeRing.setAttribute('filter', "url(#glow)");
            }
          });
          btnButtonPurge.addEventListener('mouseup', function () {
            bngApi.activeObjectLua("for _,v in pairs(controller.getControllersByType('nitrousOxideInjection')) do v.setOverride(false) end");
            var buttonPurgeCircle = svg.getElementById('circle-buttonpurge');
            var buttonPurgeRing = svg.getElementById('ring-buttonpurge');
            if (buttonPurgeCircle) {
              buttonPurgeCircle.setAttribute('fill', "#808080");
              buttonPurgeCircle.removeAttribute('filter');
            }
            if (buttonPurgeRing) {
              buttonPurgeRing.setAttribute('stroke', "#808080");
              buttonPurgeRing.removeAttribute('filter');
            }
          });
          btnButtonPurge.addEventListener('contextmenu', function (e) {
            e.preventDefault();
          });
        }
        scope.$on('streamsUpdate', function (event, data) {
          if (!data.electrics) return;
          var electrics = data.electrics;
          var nitrousArmed = electrics.nitrousOxideArm;
          var nitrousActive = electrics.nitrousOxideActive;
          var buttonnosCircle = svg.getElementById('circle-buttonnos');
          var buttonnosRing = svg.getElementById('ring-buttonnos');
          if (buttonnosCircle && buttonnosRing) {
            if (nitrousActive) {
              buttonnosCircle.setAttribute('fill', "#f39c12");
              buttonnosRing.setAttribute('stroke', "#f39c12");
              buttonnosCircle.setAttribute('filter', "url(#glow)");
              buttonnosRing.setAttribute('filter', "url(#glow)");
            } else if (nitrousArmed) {
              buttonnosCircle.setAttribute('fill', "#0047AB");
              buttonnosRing.setAttribute('stroke', "#0047AB");
              buttonnosCircle.setAttribute('filter', "url(#glow)");
              buttonnosRing.setAttribute('filter', "url(#glow)");
            } else {
              buttonnosCircle.setAttribute('fill', "#808080");
              buttonnosRing.setAttribute('stroke', "#808080");
              buttonnosCircle.removeAttribute('filter');
              buttonnosRing.removeAttribute('filter');
            }
          }
          var twoStepCircle = svg.getElementById('circle-twostep');
          var twoStepRing = svg.getElementById('ring-twostep');
          if (twoStepCircle && twoStepRing) {
            if (electrics.twoStep) {
              twoStepCircle.setAttribute('fill', "#BF00FF");
              twoStepRing.setAttribute('stroke', "#BF00FF");
              twoStepCircle.setAttribute('filter', "url(#glow)");
              twoStepRing.setAttribute('filter', "url(#glow)");
            } else {
              twoStepCircle.setAttribute('fill', "#808080");
              twoStepRing.setAttribute('stroke', "#808080");
              twoStepCircle.removeAttribute('filter');
              twoStepRing.removeAttribute('filter');
            }
          }
          var lineLockCircle = svg.getElementById('circle-linelock');
          var lineLockRing = svg.getElementById('ring-linelock');
          if (lineLockCircle && lineLockRing) {
            if (electrics.linelock) {
              lineLockCircle.setAttribute('fill', "#FF4500");
              lineLockRing.setAttribute('stroke', "#FF4500");
              lineLockCircle.setAttribute('filter', "url(#glow)");
              lineLockRing.setAttribute('filter', "url(#glow)");
            } else {
              lineLockCircle.setAttribute('fill', "#808080");
              lineLockRing.setAttribute('stroke', "#808080");
              lineLockCircle.removeAttribute('filter');
              lineLockRing.removeAttribute('filter');
            }
          }
          var transbrakeCircle = svg.getElementById('circle-transbrake');
          var transbrakeRing = svg.getElementById('ring-transbrake');
          if (transbrakeCircle && transbrakeRing) {
            const transbrakeActive = electrics.transbrake;
            if (transbrakeActive) {
              transbrakeCircle.setAttribute('fill', "#f1c40f");
              transbrakeRing.setAttribute('stroke', "#f1c40f");
              transbrakeCircle.setAttribute('filter', "url(#glow)");
              transbrakeRing.setAttribute('filter', "url(#glow)");
            } else {
              transbrakeCircle.setAttribute('fill', "#808080");
              transbrakeRing.setAttribute('stroke', "#808080");
              transbrakeCircle.removeAttribute('filter');
              transbrakeRing.removeAttribute('filter');
            }
          }
          var startStopCircle = svg.getElementById('circle-startstop');
          var startStopRing = svg.getElementById('ring-startstop');
          if (startStopCircle && startStopRing) {
            if (electrics.ignitionLevel === 1) {
              startStopCircle.setAttribute('fill', "#3498db");
              startStopRing.setAttribute('stroke', "#3498db");
              startStopCircle.setAttribute('filter', "url(#glow)");
              startStopRing.setAttribute('filter', "url(#glow)");
            } else if (electrics.ignitionLevel === 2 || electrics.ignitionLevel === 3) {
              startStopCircle.setAttribute('fill', "#0edd0e");
              startStopRing.setAttribute('stroke', "#0edd0e");
              startStopCircle.setAttribute('filter', "url(#glow)");
              startStopRing.setAttribute('filter', "url(#glow)");
            } else {
              startStopCircle.setAttribute('fill', "#808080");
              startStopRing.setAttribute('stroke', "#808080");
              startStopCircle.removeAttribute('filter');
              startStopRing.removeAttribute('filter');
            }
          }
        });
      });
      scope.$on('$destroy', function () {
        StreamsManager.remove(streamsList);
      });
    }
  };
}]);
