'use strict';
angular.module('beamng.apps')
.directive('jcSwitches5', ['$interval', '$timeout', function ($interval, $timeout) {
  return {
    template: '<object style="width:100%; height:100%;" type="image/svg+xml" data="/ui/modules/apps/JCftswitches5/JCftswitches5.svg"></object>',
    replace: true,
    restrict: 'EA',
    scope: true,
    link: function (scope, element, attrs) {
      var streamsList = ['electrics'];
      StreamsManager.add(streamsList);

      element.on('load', function () {
        var svg = element[0].contentDocument;

        // --- Start/Stop Button ---
        var btnStartstop = svg.getElementById('btn-startstop');
        if (btnStartstop) {
          btnStartstop.style.cursor = 'pointer';
          btnStartstop.addEventListener('mousedown', function () {
            bngApi.activeObjectLua('electrics.toggleIgnitionLevelOnDown()');
          });
          btnStartstop.addEventListener('mouseup', function () {
            bngApi.activeObjectLua('electrics.toggleIgnitionLevelOnUp()');
          });
        }

        // --- Left Blinker Button ---
        var btnLeftArrow = svg.getElementById('btn-left-arrow');
        if (btnLeftArrow) {
          btnLeftArrow.style.cursor = 'pointer';
          btnLeftArrow.addEventListener('mousedown', function () {
            bngApi.activeObjectLua('electrics.toggle_left_signal()');
          });
        }

        // --- Right Blinker Button ---
        var btnRightArrow = svg.getElementById('btn-right-arrow');
        if (btnRightArrow) {
          btnRightArrow.style.cursor = 'pointer';
          btnRightArrow.addEventListener('mousedown', function () {
            bngApi.activeObjectLua('electrics.toggle_right_signal()');
          });
        }

        // --- Headlight Button (High Beams) ---
        var btnHeadlight = svg.getElementById('btn-highbeam');
        if (btnHeadlight) {
          btnHeadlight.style.cursor = 'pointer';
          btnHeadlight.addEventListener('mousedown', function () {
            bngApi.activeObjectLua('electrics.toggle_lights()');
          });
        }

        // --- Fog Light Button (Low Beams) ---
        var btnFoglight = svg.getElementById('btn-lowbeam');
        if (btnFoglight) {
          btnFoglight.style.cursor = 'pointer';
          btnFoglight.addEventListener('mousedown', function () {
            bngApi.activeObjectLua('electrics.toggle_fog_lights()');
          });
        }

        // --- Stream Update for Lighting Effects ---
        scope.$on('streamsUpdate', function (event, data) {
          if (!data.electrics) return;
          var electrics = data.electrics;

          // --- Start/Stop Glow ---
          var startStopCircle = svg.getElementById('circle-startstop');
          var startStopRing = svg.getElementById('ring-startstop');
          if (startStopCircle && startStopRing) {
            if (electrics.ignitionLevel === 1) {
              startStopCircle.setAttribute('fill', "#3498db");
              startStopRing.setAttribute('stroke', "#3498db");
              startStopCircle.setAttribute('filter', "url(#glow)");
              startStopRing.setAttribute('filter', "url(#glow)");
            } else if (electrics.ignitionLevel === 2 || electrics.ignitionLevel === 3) {
              startStopCircle.setAttribute('fill', "#0edd0e");
              startStopRing.setAttribute('stroke', "#0edd0e");
              startStopCircle.setAttribute('filter', "url(#glow)");
              startStopRing.setAttribute('filter', "url(#glow)");
            } else {
              startStopCircle.setAttribute('fill', "#808080");
              startStopRing.setAttribute('stroke', "#808080");
              startStopCircle.removeAttribute('filter');
              startStopRing.removeAttribute('filter');
            }
          }

          // --- Left Blinker Glow ---
          var leftCircle = svg.getElementById('circle-left-arrow');
          var leftRing = svg.getElementById('ring-left-arrow');
          if (leftCircle && leftRing) {
            if (electrics.signal_L === 1) {
              leftCircle.setAttribute('fill', "#FFA500"); // Orange
              leftRing.setAttribute('stroke', "#FFA500");
              leftCircle.setAttribute('filter', "url(#glow)");
              leftRing.setAttribute('filter', "url(#glow)");
            } else {
              leftCircle.setAttribute('fill', "#808080");
              leftRing.setAttribute('stroke', "#808080");
              leftCircle.removeAttribute('filter');
              leftRing.removeAttribute('filter');
            }
          }

          // --- Right Blinker Glow ---
          var rightCircle = svg.getElementById('circle-right-arrow');
          var rightRing = svg.getElementById('ring-right-arrow');
          if (rightCircle && rightRing) {
            if (electrics.signal_R === 1) {
              rightCircle.setAttribute('fill', "#FFA500"); // Orange
              rightRing.setAttribute('stroke', "#FFA500");
              rightCircle.setAttribute('filter', "url(#glow)");
              rightRing.setAttribute('filter', "url(#glow)");
            } else {
              rightCircle.setAttribute('fill', "#808080");
              rightRing.setAttribute('stroke', "#808080");
              rightCircle.removeAttribute('filter');
              rightRing.removeAttribute('filter');
            }
          }

          // --- Headlight Glow (based on lights_state) ---
          var headlightCircle = svg.getElementById('circle-highbeam');
          var headlightRing = svg.getElementById('ring-highbeam');
          if (headlightCircle && headlightRing) {
            switch (electrics.lights_state) {
              case 1: // Low beams
                headlightCircle.setAttribute('fill', "#0edd0e"); // Green
                headlightRing.setAttribute('stroke', "#0edd0e");
                headlightCircle.setAttribute('filter', "url(#glow)");
                headlightRing.setAttribute('filter', "url(#glow)");
                break;
              case 2: // High beams
                headlightCircle.setAttribute('fill', "#00BFFF"); // Blue
                headlightRing.setAttribute('stroke', "#00BFFF");
                headlightCircle.setAttribute('filter', "url(#glow)");
                headlightRing.setAttribute('filter', "url(#glow)");
                break;
              default:
                headlightCircle.setAttribute('fill', "#808080");
                headlightRing.setAttribute('stroke', "#808080");
                headlightCircle.removeAttribute('filter');
                headlightRing.removeAttribute('filter');
                break;
            }
          }

          // --- Fog Light Glow ---
          var fogCircle = svg.getElementById('circle-lowbeam');
          var fogRing = svg.getElementById('ring-lowbeam');
          if (fogCircle && fogRing) {
            if (electrics.fog === 1) {
              fogCircle.setAttribute('fill', "#00BFFF"); // Blue
              fogRing.setAttribute('stroke', "#00BFFF");
              fogCircle.setAttribute('filter', "url(#glow)");
              fogRing.setAttribute('filter', "url(#glow)");
            } else {
              fogCircle.setAttribute('fill', "#808080");
              fogRing.setAttribute('stroke', "#808080");
              fogCircle.removeAttribute('filter');
              fogRing.removeAttribute('filter');
            }
          }
        });
      });

      scope.$on('$destroy', function () {
        StreamsManager.remove(streamsList);
      });
    }
  };
}]);
