'use strict';
angular.module('beamng.apps')
.directive('jcSwitches4', ['$interval', '$timeout', function ($interval, $timeout) {
  return {
    template: '<object style="width:100%; height:100%;" type="image/svg+xml" data="/ui/modules/apps/JCftswitches4/JCftswitches4.svg"></object>',
    replace: true,
    restrict: 'EA',
    scope: true,
    link: function (scope, element, attrs) {
      var streamsList = ['electrics'];
      StreamsManager.add(streamsList);

      element.on('load', function () {
        var svg = element[0].contentDocument;

        var btnbuttonnos = svg.getElementById('btn-buttonnos');
        if (btnbuttonnos) {
          btnbuttonnos.style.cursor = 'pointer';
          btnbuttonnos.addEventListener('mousedown', function () {
            bngApi.activeObjectLua('for _,v in pairs(controller.getControllersByType("nitrousOxideInjection")) do v.toggleActive() end');
          });
        }

        var btnTwoStep = svg.getElementById('btn-twostep');
        if (btnTwoStep) {
          btnTwoStep.style.cursor = 'pointer';
          btnTwoStep.addEventListener('mousedown', function () {
            bngApi.activeObjectLua('controller.getControllerSafe("twoStepLaunch").toggleTwoStep()');
          });
        }

        var btnLeftArrow = svg.getElementById('btn-left-arrow');
        if (btnLeftArrow) {
          btnLeftArrow.style.cursor = 'pointer';
          btnLeftArrow.addEventListener('mousedown', function (event) {
            event.preventDefault();
            if (event.button === 0) {
              bngApi.activeObjectLua('controller.getControllerSafe("twoStepLaunch").changeTwoStepRPM(-100)');
            } else if (event.button === 2) {
              bngApi.activeObjectLua('controller.getControllerSafe("twoStepLaunch").changeTwoStepRPM(-25)');
            }
            var leftArrowCircle = svg.getElementById('circle-left-arrow');
            var leftArrowRing = svg.getElementById('ring-left-arrow');
            if (leftArrowCircle) {
              leftArrowCircle.setAttribute('fill', "#e74c3c");
              leftArrowCircle.setAttribute('filter', "url(#glow)");
            }
            if (leftArrowRing) {
              leftArrowRing.setAttribute('stroke', "#e74c3c");
              leftArrowRing.setAttribute('filter', "url(#glow)");
            }
            setTimeout(function () {
              if (leftArrowCircle) {
                leftArrowCircle.setAttribute('fill', "#808080");
                leftArrowCircle.removeAttribute('filter');
              }
              if (leftArrowRing) {
                leftArrowRing.setAttribute('stroke', "#808080");
                leftArrowRing.removeAttribute('filter');
              }
            }, 300);
          });
          btnLeftArrow.addEventListener('contextmenu', function (e) {
            e.preventDefault();
          });
        }

        var btnRightArrow = svg.getElementById('btn-right-arrow');
        if (btnRightArrow) {
          btnRightArrow.style.cursor = 'pointer';
          btnRightArrow.addEventListener('mousedown', function (event) {
            event.preventDefault();
            if (event.button === 0) {
              bngApi.activeObjectLua('controller.getControllerSafe("twoStepLaunch").changeTwoStepRPM(100)');
            } else if (event.button === 2) {
              bngApi.activeObjectLua('controller.getControllerSafe("twoStepLaunch").changeTwoStepRPM(25)');
            }
            var rightArrowCircle = svg.getElementById('circle-right-arrow');
            var rightArrowRing = svg.getElementById('ring-right-arrow');
            if (rightArrowCircle) {
              rightArrowCircle.setAttribute('fill', "#0edd0e");
              rightArrowCircle.setAttribute('filter', "url(#glow)");
            }
            if (rightArrowRing) {
              rightArrowRing.setAttribute('stroke', "#0edd0e");
              rightArrowRing.setAttribute('filter', "url(#glow)");
            }
            setTimeout(function () {
              if (rightArrowCircle) {
                rightArrowCircle.setAttribute('fill', "#808080");
                rightArrowCircle.removeAttribute('filter');
              }
              if (rightArrowRing) {
                rightArrowRing.setAttribute('stroke', "#808080");
                rightArrowRing.removeAttribute('filter');
              }
            }, 300);
          });
          btnRightArrow.addEventListener('contextmenu', function (e) {
            e.preventDefault();
          });
        }

        scope.$on('streamsUpdate', function (event, data) {
          if (!data.electrics) {
            return;
          }
          var electrics = data.electrics;

          // Update nitrous button visual
          const nitrousActive = electrics.nitrousOxideArm;
          var buttonnosCircle = svg.getElementById('circle-buttonnos');
          var buttonnosRing = svg.getElementById('ring-buttonnos');
          if (buttonnosCircle && buttonnosRing) {
            if (nitrousActive) {
              buttonnosCircle.setAttribute('fill', "#0047AB"); // Dark Blue
              buttonnosRing.setAttribute('stroke', "#0047AB");
              buttonnosCircle.setAttribute('filter', "url(#glow)");
              buttonnosRing.setAttribute('filter', "url(#glow)");
            } else {
              buttonnosCircle.setAttribute('fill', "#808080");
              buttonnosRing.setAttribute('stroke', "#808080");
              buttonnosCircle.removeAttribute('filter');
              buttonnosRing.removeAttribute('filter');
            }
          }

          // Update twostep button visual
          var twoStepCircle = svg.getElementById('circle-twostep');
          var twoStepRing = svg.getElementById('ring-twostep');
          if (twoStepCircle && twoStepRing) {
            if (electrics.twoStep) {
              twoStepCircle.setAttribute('fill', "#BF00FF");
              twoStepRing.setAttribute('stroke', "#BF00FF");
              twoStepCircle.setAttribute('filter', "url(#glow)");
              twoStepRing.setAttribute('filter', "url(#glow)");
            } else {
              twoStepCircle.setAttribute('fill', "#808080");
              twoStepRing.setAttribute('stroke', "#808080");
              twoStepCircle.removeAttribute('filter');
              twoStepRing.removeAttribute('filter');
            }
          }
        });
      });

      scope.$on('$destroy', function () {
        StreamsManager.remove(streamsList);
      });
    }
  };
}]);
