local M = {}

local lastIgnitionLevel = 0
local soundVolume = 0
local soundNode = v.data.refNodes[0].ref
local soundObj = nil
local playOutside = false

local camPos
local vehPos
local camDistToCar
local isInCar

local function checkCamInside()
    camPos = obj:getCameraPosition()

    if camPos and vehPos then
        camDistToCar = camPos:distance(vehPos)
        isInCar = camDistToCar <= 0.6
        obj:setVolume(soundObj, isInCar and soundVolume or 0)
    end

    vehPos = obj:getPosition() + obj:getNodePosition(beamstate.nodeNameMap["driver"])
end

local function updateGFX(dt)
    local ignitionLevel = electrics.values.ignitionLevel

    if not playOutside then checkCamInside() end
    if ignitionLevel == 2 and lastIgnitionLevel == 1 then
        obj:playSFX(soundObj)
    elseif ignitionLevel == 2 and lastIgnitionLevel == 3 then
        obj:stopSFX(soundObj)
        obj:cutSFX(soundObj)
    end

    lastIgnitionLevel = electrics.values.ignitionLevel
end

local function initSounds(jbeamData)
    soundObj = obj:createSFXSource2(jbeamData.sound, "AudioDefaultLoop3D", "", soundNode, 0)
    if playOutside then
        obj:setVolume(soundObj, soundVolume)
    end
end

local function init(jbeamData)
    soundNode = jbeamData.soundNode or soundNode
    soundVolume = jbeamData.soundVolume or soundVolume
    playOutside = jbeamData.playOutside or false
end

M.updateGFX = updateGFX
M.initSounds = initSounds
M.init = init

return M