local M = {}

local timer = 0
-- 0: forward, 1: reverse
local wiperDirection = 0
local nextWiperSwing = false
local wiperValue = 0
-- 0, otherwise known as off
local currentState = 0
local stages = {
    { offsetTime = 3, maxSpeed = 0.02, soundSpeed = 0.78 },
    { offsetTime = 0, maxSpeed = 0.02, soundSpeed = 0.78 },
    { offsetTime = 0, maxSpeed = 0.04, soundSpeed = 1.56 },
}
local soundVolume = 0.75

local function updateGFX(dt)
    if not nextWiperSwing and currentState > 0 then
        timer = timer + dt
        if timer > stages[math.max(currentState, 1)].offsetTime then
            obj:playSFXOnce("wiper", 0, soundVolume, stages[math.max(currentState, 1)].soundSpeed)
            nextWiperSwing = true
            timer = 0
        end
    end

    if nextWiperSwing then
        local speed = stages[math.max(currentState, 1)].maxSpeed * dt * 50

        if wiperDirection == 0 then
            wiperValue = math.min(wiperValue + speed, 1)
            if wiperValue >= 0.95 then
                wiperDirection = 1
            end
        else
            wiperValue = math.max(wiperValue - speed, 0)
            if wiperValue <= 0.05 then
                wiperDirection = 0
                nextWiperSwing = false
            end
        end
    end

    electrics.values.wiper = wiperValue
    electrics.values.wiperEnabled = currentState > 0 and 1 or 0
end

local function increaseFreq()
    currentState = math.min(currentState + 1, #stages)
    timer = stages[currentState].offsetTime
end

local function decreaseFreq()
    currentState = math.max(currentState - 1, 0)
    timer = stages[currentState] and stages[currentState].offsetTime or 0
end

local function initSounds(jbeamData)
    obj:createSFXSource(jbeamData.sound or "", "AudioClosest3D", "wiper", 0)
end

local function init(jbeamData)
    electrics.values.wiper = 0
    electrics.values.wiperEnabled = 0

    stages = tableFromHeaderTable(jbeamData.stages) or stages
    soundVolume = jbeamData.soundVolume or soundVolume
end

local function reset()
    currentState = 0
    wiperValue = 0
end

M.increaseFreq = increaseFreq
M.decreaseFreq = decreaseFreq
M.updateGFX = updateGFX
M.init = init
M.reset = reset
M.initSounds = initSounds

return M