local M = {}

local timer = 0
-- 0: forward, 1: reverse
local wiperrearDirection = 0
local nextWiperrearSwing = false
local wiperrearValue = 0
-- 0, otherwise known as off
local currentState = 0
local stages = {
    { offsetTime = 3, maxSpeed = 0.02, soundSpeed = 0.78 },
    { offsetTime = 0, maxSpeed = 0.02, soundSpeed = 0.78 },
    { offsetTime = 0, maxSpeed = 0.04, soundSpeed = 1.56 },
}
local soundVolume = 0.75

local function updateGFX(dt)
    if not nextWiperrearSwing and currentState > 0 then
        timer = timer + dt
        if timer > stages[math.max(currentState, 1)].offsetTime then
            obj:playSFXOnce("wiperrear", 0, soundVolume, stages[math.max(currentState, 1)].soundSpeed)
            nextWiperrearSwing = true
            timer = 0
        end
    end

    if nextWiperrearSwing then
        local speed = stages[math.max(currentState, 1)].maxSpeed * dt * 50

        if wiperrearDirection == 0 then
            wiperrearValue = math.min(wiperrearValue + speed, 1)
            if wiperrearValue >= 0.95 then
                wiperrearDirection = 1
            end
        else
            wiperrearValue = math.max(wiperrearValue - speed, 0)
            if wiperrearValue <= 0.05 then
                wiperrearDirection = 0
                nextWiperrearSwing = false
            end
        end
    end

    electrics.values.wiperrear = wiperrearValue
    electrics.values.wiperrearEnabled = currentState > 0 and 1 or 0
end

local function increaseFreq()
    currentState = math.min(currentState + 1, #stages)
    timer = stages[currentState].offsetTime
end

local function decreaseFreq()
    currentState = math.max(currentState - 1, 0)
    timer = stages[currentState] and stages[currentState].offsetTime or 0
end

local function initSounds(jbeamData)
    obj:createSFXSource(jbeamData.sound or "", "AudioClosest3D", "wiperrear", 0)
end

local function init(jbeamData)
    electrics.values.wiperrear = 0
    electrics.values.wiperrearEnabled = 0

    stages = tableFromHeaderTable(jbeamData.stages) or stages
    soundVolume = jbeamData.soundVolume or soundVolume
end

local function reset()
    currentState = 0
    wiperrearValue = 0
end

M.increaseFreq = increaseFreq
M.decreaseFreq = decreaseFreq
M.updateGFX = updateGFX
M.init = init
M.reset = reset
M.initSounds = initSounds

return M