local M = {}
M.type = "auxiliary"
M.relevantDevice = nil

local htmlTexture = require("htmlTexture")

local gaugesScreenName = nil
local htmlPath = nil

local updateTimer = 0
local updateFPS = 30
local invFPS = 1 / updateFPS
local direction
local infotainment = false
local function updateGFX(dt)
  updateTimer = updateTimer + dt
  if updateTimer > invFPS then
    local data = {}
	
    data.radio = electrics.values["radio"]
    data.temp = obj:getEnvTemperature() - 273.15
    data.clock = os.date("%H") .. ":" .. os.date("%M")
	data.volume = electrics.values["radioVolume"]
	data.volumeChanged = electrics.values["volumeChanged"]
	
	if infotainment == false then
		data.inputText = "STEREO"
	else
		data.inputText = "DVD"
	end
	
	if electrics.values["radioAuthor"] == "Unknown" then
		data.radioAuthor = " "
	else
		data.radioAuthor = electrics.values["radioAuthor"]
	end



	data.ignitionLevel = electrics.values["ignitionLevel"]

    --dump(data)
    htmlTexture.call(gaugesScreenName, "update", data)
    updateTimer = 0
  end
end

local function init(jbeamData)
	infotainment = jbeamData.infotainment or false
	compassEnabled = jbeamData.compassEnabled or false
	gaugesScreenName = jbeamData.materialName
	htmlPath = jbeamData.htmlPath
	local width = jbeamData.textureWidth or 512
	local height = jbeamData.textureHeight or 256

    htmlTexture.create(gaugesScreenName, htmlPath, width, height, updateFPS, "automatic")
    htmlTexture.call(gaugesScreenName, "init")
end

M.init = init
M.updateGFX = updateGFX

return M
