angular.module('gaugesScreen', [])

  .controller('GaugesScreenController', function ($scope, $element, $window) {
    "use strict";
    var vm = this;

    var svg;
    var navContainer = $element[0].children[0];
    var navDimensions = [];

    var gauge = { gears: {} };
    var infoDisplay = {};
    var roots = {};
    var electrics = {lights:{} };
    var gagues = {fuel:{},temp:{}};
	



    var ready = false;

    var unit = "imperial";


    // Make sure SVG is loaded
    $scope.onSVGLoaded = function () {
        console.log("onSVGLoaded");
      svg = $element[0].children[0].children[0];



      infoDisplay.hour = hu('#clock_hour_txt', svg);
      infoDisplay.min = hu('#clock_min_txt', svg);


      ready = true;
    }


    function fixClock(v, fill="0"){
      return (v<10)? fill+v : v;
    }





    function limitVal(min, val,max){
        return Math.min(Math.max(min,val), max);
    }




    // overwriting plain javascript function so we can access from within the controller
    $window.setup = (data) => {
      if(!ready){
        console.log("calling setup while svg not fully loaded");
        setTimeout(function(){ $window.setup(data) }, 100);
        return;
      }

      //console.log("setup",data);

    }


    function setElec(val, state, key){
      if( val === undefined || val === null){console.error("setElec: svg element not found", key); return;}
      if( state === undefined || state === null){console.error("setElec: state not found", key);val.n.style.display = "none"; return;}
      var cssState = (state===true || state>0.1)?"inline":"none";
      val.n.style.display = cssState;
      //val.n.setAttribute("opacity", (state || state>0.1)?1.0:0.3)
    }

    $window.updateElectrics = (data) => {

      for(var k in electrics.lights){
        setElec(electrics.lights[k], data.electrics[k], k);
      }
	  




      const current_time = new Date(Date.now('en-US', { hour: 'numeric', hour12: true }));
      infoDisplay.hour.text(fixClock(current_time.getHours(), "{"));
      infoDisplay.min.text(fixClock(current_time.getMinutes()));

    }
	


    $window.updateData = (data) => {
      if (data) {
        if(!ready){console.log("not ready");return;}


        updateElectrics(data);
      }
    }
    //ready = true;
  });