--Created by Inn0centJok3r
--DO NOT USE WITHOUT PERMISSION! ASK ME AT https://www.beamng.com/members/inn0centjok3r.318168/
--Speed Limits depending on drive mode
local M = {}
M.type = "auxiliary"
M.relevantDevice = nil

local topSpeedLimitPID

local function init(jbeamData)
    topSpeedLimitPID = newPIDParallel(1, 0.5, 0, 0, 1)
	
	
  local hasGearbox = gearbox ~= nil
  local controlLogicName = "dummy"

  if hasGearbox then
    gearboxType = gearbox.type
    controlLogicName = gearboxType
  end

  if jbeamData.shiftLogicName then
    controlLogicName = jbeamData.shiftLogicName
  end

  local controlLogicModuleName = "controller/shiftLogic-" .. controlLogicName
  controlLogicModule = require(controlLogicModuleName)
end

local function updateGFX(dt)
--CODE RELIES ON electrics values FROM driveModeAutoToggle LUA!!
  local currentDriveMode = electrics.values["currentDriveMode"]

  M.throttle = controlLogicModule.throttle
  local gearName = controlLogicModule.getGearName()

  local vehicleSpeed = electrics.values.wheelspeed or 0
  local speedLimit = 105.6
  
  if vehicleSpeed > speedLimit and currentDriveMode == "sport" or currentDriveMode == "track" or currentDriveMode == "off" then
    local throttleCoef = 1 - topSpeedLimitPID:get(-vehicleSpeed, -speedLimit, dt)
    electrics.values.throttleOverride = input.throttle * throttleCoef
  else
	electrics.values.throttleOverride = nil	
  end

end

M.init = init
M.updateGFX = updateGFX

return M
