-- gearLight.lua
local M = {}

local outputNames = {
  "gearR", "gearN", "gear1", "gear2", "gear3", "gear4", "gear5", "gear6", "gear7", "gear8"
}

local deviceName = "gearbox"

local function init(jbeamData)
  if jbeamData.outputElectrics then
    outputNames = jbeamData.outputElectrics
  end

  if jbeamData.deviceName then
    deviceName = jbeamData.deviceName
  end

  for i = 1, #outputNames do
    electrics.values[outputNames[i]] = 0
  end
end

local function updateGFX(dt)
  local gearDevice = powertrain.getDevice(deviceName)
  if not gearDevice then
    log('E', 'gearLight', 'Gear device not found: ' .. tostring(deviceName))
    return
  end

  local gearIndex = gearDevice.gearIndex or 0
  log('I', 'gearLight', 'gearIndex = ' .. tostring(gearIndex))

  for i = 1, #outputNames do
    local expectedIndex = i - 2
    electrics.values[outputNames[i]] = (gearIndex == expectedIndex) and 1 or 0
  end
end

M.init = init
M.updateGFX = updateGFX

return M



