-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt
local M = {}
local dome_lights = 0
local park_lights = 0
local beams = 0

local function toggle_lowbeam()
    if beams == 1 or beams == 2 then
        beams = 0
    else
        beams = 1
    end
    electrics.setLightsState(beams)
end

local function toggle_highbeam()
    if beams == 2 then
        beams = 1
    elseif beams == 1 then
        beams = 2
    end
    electrics.setLightsState(beams)
end

local function toggle_park_lights()
    park_lights = 1 - park_lights
end

local function toggle_dome_lights()
    dome_lights = 1 - dome_lights
end

local function updateGFX(dt)
    electrics.values.park_lights = park_lights
    electrics.values.dome_lights = dome_lights
end

-- public interface
M.toggle_lowbeam = toggle_lowbeam
M.toggle_highbeam = toggle_highbeam
M.toggle_park_lights = toggle_park_lights
M.toggle_dome_lights = toggle_dome_lights
M.updateGFX = updateGFX

return M