local M = {}
M.type = "auxiliary"

local rideheight = 0.5
local digiunitConv = 1
local isunitmph = 1
local isunitkmh = 0
local airsus_active = nil

local function airsus_down()
  controller.getControllerSafe('airbags').setBeamMomentaryDecrease({'airsus'}, true)
  airsus_active = 'down'
end

local function airsus_up()
  controller.getControllerSafe('airbags').setBeamMomentaryIncrease({'airsus'}, true)
  airsus_active = 'up'
end

local function airsus_down_stop()
  controller.getControllerSafe('airbags').setBeamMomentaryDecrease({'airsus'}, false)
  airsus_active = nil
end

local function airsus_up_stop()
  controller.getControllerSafe('airbags').setBeamMomentaryIncrease({'airsus'}, false)
  airsus_active = nil
end

local function speedunit()
  if digiunitConv == 1 then
	isunitkmh = 1
	isunitmph = 0
    digiunitConv = 1.60934
  else
    digiunitConv = 1
	isunitkmh = 0
	isunitmph = 1
  end
end

local function updateGFX(dt)
  
  if airsus_active == 'up' then
    rideheight = rideheight + 0.02
    if rideheight > 1 then
      rideheight = 1
    end
  elseif airsus_active == 'down' then
    rideheight = rideheight - 0.02
    if rideheight < 0 then
      rideheight = 0
    end
  end
  
  electrics.values.isunitkmh = isunitkmh
  electrics.values.isunitmph = isunitmph
  
  electrics.values.digiunitConv = digiunitConv
  
  electrics.values.rideheight = rideheight
  
end

local function onReset()
	rideheight = 0.5
end

local function onInit()
	rideheight = 0.5
end

-- public interface
M.updateGFX = updateGFX
M.onReset = onReset
M.onInit = onInit

M.airsus_up = airsus_up
M.airsus_down = airsus_down
M.airsus_up_stop = airsus_up_stop
M.airsus_down_stop = airsus_down_stop
M.speedunit = speedunit

return M
