angular.module('gaugesScreen', [])

  .controller('GaugesScreenController', function ($scope, $element, $window) {
    "use strict";
    var vm = this;

    var svg;
    var navContainer = $element[0].children[0];
    var navDimensions = [];

    var gauge = { gears: {} };
    var tacho = {  };
    var infoDisplay = {};
    var roots = {};
    var electrics = {lights:{} };
    var gagues = {spring:{},fuel:{},temp:{},boost:{}};
	
    var speedoInitialised = true;
    var currentGear = '';

    var ready = false;

    var unit = "metric";
    var unitspeedConv = 2.23694;


    // Make sure SVG is loaded
    $scope.onSVGLoaded = function () {
        console.log("onSVGLoaded");
      svg = $element[0].children[0].children[0];


      gauge.speedValue = hu('#speedo_txt', svg);
      gauge.tachoValue = hu('#tacho_txt', svg);
      gauge.gear = hu('#gear_txt', svg);
	  
      roots.turbo_bar = hu('#turbo_bar', svg);
      roots.tacho_bar = hu('#tacho_bar', svg);
      roots.fuel_bar = hu('#fuel_bar', svg);
      roots.temp_bar = hu('#temp_bar', svg);
      roots.oil_bar = hu('#oil_bar', svg);
      roots.battery_bar = hu('#battery_bar', svg);
      roots.spring_bar = hu('#spring_bar', svg);
	  
      infoDisplay.dte = hu('#dte_txt', svg);
	  
      electrics.root = hu('#indicator_panel', svg);
      electrics.lights.hoodLatchCoupler_notAttached = hu("#hood_indicator", electrics.root);
      electrics.lights.doorRCoupler_notAttached = hu("#door_r_indicator", electrics.root);
      electrics.lights.doorLCoupler_notAttached = hu("#door_l_indicator", electrics.root);
      electrics.lights.tailgateCoupler_notAttached = hu("#tailgate_indicator", electrics.root);
      electrics.lights.transfercase_lock = hu("#wheel_f", electrics.root);
      electrics.lights.isunitmph = hu("#speedo_mph", electrics.root);
      electrics.lights.isunitkmh = hu("#speedo_kmh", electrics.root);
	  
      electrics.odometer_txt = hu("#odometer_txt", svg);
      electrics.trip_txt = hu("#trip_txt", svg);
	  

      ready = true;
    }

    function fixClock(v, fill="0"){
      return (v<10)? fill+v : v;
    }
	
    function updateSpeedDisplays(data) {
      let speed = (data.electrics.wheelspeed * unitspeedConv) * data.electrics.digiunitConv;
      speed = Math.min(999,speed);
      gauge.speedValue.text((speed ).toFixed(0));

    }
	
	function updateTachoDisplays(data) {
	  let rpm = Math.round(data["electrics"]["rpmTacho"]/10) * 10;
	  let displayedRpm = Math.floor(rpm / 100); // Divide by 100 to drop the tens and units digits
	  gauge.tachoValue.text(displayedRpm);

	let children = roots.tacho_bar.n.childNodes;
	for (let i = 0; i < children.length; i++) {
	  let index = parseInt(children[i].id.replace("tacho_bar_",""));
      children[i].style.display = (rpm > index*147.72) ? "inline" : "none";
      }
    }
	
    function updateTurboBoost(data) {
      let boost = data.electrics.turboBoost+9;
      let children = roots.turbo_bar.n.childNodes
      for (let i = 0; i < children.length; i++) {
        let index = parseInt(children[i].id.replace("turbo_bar_",""));
        children[i].style.display = (boost >= index*0.68)?"inline":"none";
      }
    }
	
    function updateSpring(data) {
      let spring = data.electrics.rideheight;
      let children = roots.spring_bar.n.childNodes
      for (let i = 0; i < children.length; i++) {
        let index = parseInt(children[i].id.replace("spring_bar_",""));
        children[i].style.display = (spring >= index*0.1)?"inline":"none";
      }
    }

    function limitVal(min, val,max){
        return Math.min(Math.max(min,val), max);
    }

    function updateGagueFuel(data) {
      let fuel = data.electrics.fuel;
      let children = roots.fuel_bar.n.childNodes
      for (let i = 0; i < children.length; i++) {
        let index = parseInt(children[i].id.replace("fuel_bar_",""));
        children[i].style.display = (fuel >= index*0.052 )?"inline":"none";
      }
      if(data.electrics.wheelspeed > 1.4){
		let consumption = (235.215/data.customModules.combustionEngineData.averageFuelConsumption);
        let fuelVolume = (data.electrics.fuelVolume / 3.78541);
        let txt = ((consumption * fuelVolume) * data.electrics.digiunitConv).toFixed(0);
        if(txt.length <= 4)
          infoDisplay.dte.text(txt);
        else
          infoDisplay.dte.text("Err");

      }
      else{
        infoDisplay.dte.text("---")
      }
    }

    function updateGagueTemp(data) {
      let temp = data.electrics.watertemp -40;
      //min 40C, max 120 C, useing metric cause lazy
      let children = roots.temp_bar.n.childNodes
      for (let i = 0; i < children.length; i++) {
        let index = parseInt(children[i].id.replace("temp_bar_",""));
        children[i].style.display = (temp >= index*8.88)?"inline":"none";
      }
    }

    function updateOilTemp(data) {
      let val = data.electrics.oiltemp -50;
      //min 50C, max 140 C, useing metric cause lazy
      let children = roots.oil_bar.n.childNodes
      for (let i = 0; i < children.length; i++) {
        let index = parseInt(children[i].id.replace("oil_bar_",""));
        children[i].style.display = (val >= index*10)?"inline":"none";
      }
    }

    function updateBattery(data) {
      let val = (data.electrics.engineRunning>0.5)? 14.5: 12.5;//fake voltage
      //min 8, max 16 V
      val-=8;
      let children = roots.battery_bar.n.childNodes
      for (let i = 0; i < children.length; i++) {
        let index = parseInt(children[i].id.replace("battery_bar_",""));
        children[i].style.display = (val >= index*0.888)?"inline":"none";
      }
    }

    // overwriting plain javascript function so we can access from within the controller
    $window.setup = (data) => {
      if(!ready){
        console.log("calling setup while svg not fully loaded");
        setTimeout(function(){ $window.setup(data) }, 100);
        return;
      }

      //console.log("setup",data);

    }

    function setElec(val, state, key){
      if( val === undefined || val === null){console.error("setElec: svg element not found", key); return;}
      if( state === undefined || state === null){console.error("setElec: state not found", key);val.n.style.display = "none"; return;}
      var cssState = (state===true || state>0.1)?"inline":"none";
      val.n.style.display = cssState;
      //val.n.setAttribute("opacity", (state || state>0.1)?1.0:0.3)
    }

    $window.updateElectrics = (data) => {

      for(var k in electrics.lights){
        setElec(electrics.lights[k], data.electrics[k], k);
      }
	  
      if(data.electrics.odometer){
        let t = ((data.electrics.odometer * 0.0006215) * data.electrics.digiunitConv).toFixed(0)
        t = Math.min(999999,t);
        electrics.odometer_txt.text(t)
        electrics.trip_txt.text(t)
      }
    }


    $window.updateData = (data) => {
      if (data) {
        if(!ready){console.log("not ready");return;}
        // console.log(data);

        // Update Gear display
        if(isNaN(data.electrics.gear) || data.electrics.gear >= 1)
          gauge.gear.text(data.electrics.gear)
        else{
          switch(data.electrics.gear){
            case -1:
              gauge.gear.text("R")
              break;
            case 0:
              gauge.gear.text("N")
              break;
            default:
              gauge.gear.text("???")
              break;
          }
        }
		
        // Update displays
        updateSpeedDisplays(data);
        updateTachoDisplays(data);

        updateElectrics(data);
        updateGagueFuel(data);
        updateGagueTemp(data);
        updateTurboBoost(data);
        updateSpring(data);
        updateOilTemp(data);
        updateBattery(data);

      }
    }
    //ready = true;
  });