local M = {}
local startFrontFricCo =1
local slideFrontFricCo = 	1
local startRearFricCo = 1
local slideRearFricCo = 	1
local isOverSpeed = false
local frontNodeTable = {}
local rearNodeTable = {}

local function init()
	print("high polly friction is active")
	isOverSpeed = false
	for a,b in pairs(v.data.wheels)do
		if b.name == "FR" or b.name == "FL" then
			startFrontFricCo = b.frictionCoef
			slideFrontFricCo = b.slidingFrictionCoef
			frontNodeTable = b.treadNodes
		end
		if b.name == "RR" or b.name == "RL" then
			startRearFricCo = b.frictionCoef
			slideRearFricCo = b.slidingFrictionCoef
			rearNodeTable = b.treadNodes
		end
	end
end

local function reset()
	if electrics.values.wheelspeed > 41 then
		print("deactivating high polly friction")
		for a,b in ipairs(frontNodeTable)do
			obj:setNodeFrictionSlidingCoefs(b, startFrontFricCo, slideFrontFricCo)
		end
		for a,b in ipairs(rearNodeTable)do
			obj:setNodeFrictionSlidingCoefs(b, startRearFricCo, slideRearFricCo)
		end
	end
	isOverSpeed = false
end

local function updateGFX()
	--[[ if electrics.values.wheelspeed > 41 and isOverSpeed == false then
		print("activating high polly friction")
		for a,b in ipairs(frontNodeTable)do
			obj:setNodeFrictionSlidingCoefs(b, 1, 2)
		end
		for a,b in ipairs(rearNodeTable)do
			obj:setNodeFrictionSlidingCoefs(b, 1, 2)
		end
		isOverSpeed = true
	end
	if electrics.values.wheelspeed < 41 and isOverSpeed == true then
		print("deactivating high polly friction")
		for a,b in ipairs(frontNodeTable)do
			obj:setNodeFrictionSlidingCoefs(b, startFrontFricCo, slideFrontFricCo)
		end
		for a,b in ipairs(rearNodeTable)do
			obj:setNodeFrictionSlidingCoefs(b, startRearFricCo, slideRearFricCo)
		end
		isOverSpeed = false
	end ]]
end

M.init = init
M.reset = reset
M.updateGFX = updateGFX
return M