-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt


local M = {}
local clamp = clamp
local Hgnwh3ID
local Hgnwh3
local Rgnwrrl
local winch_attach
local gnwrCid1
local gnwrCid2
local gnwrCid3
local gnwrCid4
local gnwrCid5
local spwrStress
local winchRelease
local gunnerwinch_sound
local gunnerwinch_sound_volume
local gunnerwinch_sound_stop
local gunnerwinch_playsound
local gunnerwinch_playsound2

local function init()
  electrics.values.gunnerwinch_hydro = 0
  electrics.values.gunnerwinch_input = 0
  electrics.values.gunnerwinch = 0
  electrics.values.gunnerwinch_attach = 0
  electrics.values.gunnerwinch_freespool = 0
  Hgnwh3ID = "Hgnwh3"
  RgnwrrlID = "Rgnwrrl"
  winch_attach = false
  spwrStress = 0
  winchRelease = 0
  gunnerwinch_sound_volume = 0
  gnwrCid1 = 0
  gnwrCid2 = 0
  gnwrCid3 = 0
  gnwrCid4 = 0
  gnwrCid5 = 0
  gunnerwinch_sound_stop = true
  gunnerwinch_playsound = false
  gunnerwinch_playsound2 = true
  for k, node in pairs (v.data.nodes) do
    if node.name == Hgnwh3ID then
      Hgnwh3 = node.cid

      end
    end
  for k, node in pairs (v.data.nodes) do
    if node.name == RgnwrrlID then
      Rgnwrrl = node.cid

      end
    end
  --gunnerwinch_sound = obj:createSFXSource2("event:>Engine>Bands>Real>electric_eng_05", "AudioDefaultLoop3D", "gunnerwinch_sound", Rgnwrrl, Rgnwrrl) --node, volume

  --obj:cutSFX(gunnerwinch_sound)
end

local function reset()
  electrics.values.gunnerwinch_hydro = 0
  electrics.values.gunnerwinch_input = 0
  electrics.values.gunnerwinch = 0
  electrics.values.gunnerwinch_attach = 0
  electrics.values.gunnerwinch_freespool = 0
  winch_attach = false
  spwrStress = 0
  winchRelease = 0
  gunnerwinch_sound_volume = 0
  gunnerwinch_sound_stop = true
  gunnerwinch_playsound = false
  gunnerwinch_playsound2 = true
end

local function initSounds()
  gunnerwinch_sound = obj:createSFXSource2("event:>Engine>Starter>v8flat_1986_eng", "AudioDefaultLoop3D", "gunnerwinch_sound", Rgnwrrl, 1) --node, volume
--"event:>Engine>Starter>v6diesel_2011_eng"
end

local function updateGFX(dt) -- ms

  for _, h in pairs(v.data.hydros) do
    if h.name == "gnwrr15" then
      gnwrCid1 = h.bcid
      if h.name == "gnwrr20" then
        gnwrCid2 = h.bcid
        if h.name == "gnwrr30" then
          gnwrCid3 = h.bcid
          if h.name == "gnwrr40" then
            gnwrCid4 = h.bcid
            if h.name == "gnwrr48" then
              gnwrCid5 = h.bcid
    end
  end
end
end
end
end



if electrics.values.gunnerwinch_attach > 0 then
  obj:setNodeMass(Hgnwh3, 230)
  guihooks.message("Hook attached!", 0.4, "GNNR_Winch2")
  winch_attach = true
  
else
  obj:setNodeMass(Hgnwh3, 1.0)
  if winch_attach == true then
    guihooks.message("Hook detached!", 0.4, "GNNR_Winch2")
  winch_attach = false
end
end

spwrStress = math.max(obj:getBeamStress(gnwrCid1), obj:getBeamStress(gnwrCid2), obj:getBeamStress(gnwrCid3), obj:getBeamStress(gnwrCid4), obj:getBeamStress(gnwrCid5))
if electrics.values.gunnerwinch_freespool == 1 then
  guihooks.message("Free spool active!", 0.01, "GNNR_Winch3")
if spwrStress > 1200 then
  winchRelease = 60
else
  winchRelease = 0
end
else
  winchRelease = 0
end

if electrics.values.gunnerwinch_freespool == 1 then
if electrics.values.gunnerwinch_hydro < 0.001 then
  electrics.values.gunnerwinch_hydro = 0.01
end
end

if electrics.values.gunnerwinch > 0 then
  electrics.values.gunnerwinch_freespool = 0
  guihooks.message("Winch length: " .. (math.ceil(electrics.values.gunnerwinch_hydro*100)) .. "%", 0.4, "GNNR_Winch1")
else if electrics.values.gunnerwinch < 0 then
  electrics.values.gunnerwinch_freespool = 0
  guihooks.message("Winch length: " .. (math.ceil(electrics.values.gunnerwinch_hydro*100)) .. "%", 0.4, "GNNR_Winch1")
else if winchRelease > 0 then
  guihooks.message("Winch length: " .. (math.ceil(electrics.values.gunnerwinch_hydro*100)) .. "%", 0.4, "GNNR_Winch1")
end
end
end



if electrics.values.gunnerwinch < 0 then
  if spwrStress > 1000 then
    if spwrStress <= 8000 then
    electrics.values.gunnerwinch = -2
    electrics.values.gunnerwinch_hydro = clamp(electrics.values.gunnerwinch_hydro + winchRelease * dt * 0.01 + electrics.values.gunnerwinch * dt * 0.005 , 0, 1)
    end
  end
if spwrStress > 8000 then
  electrics.values.gunnerwinch = -1
  electrics.values.gunnerwinch_hydro = clamp(electrics.values.gunnerwinch_hydro + winchRelease * dt * 0.01 + electrics.values.gunnerwinch * dt * 0.005 , 0, 1)
end
if spwrStress > 24000 then
  electrics.values.gunnerwinch = 0
  guihooks.message("Winch overloaded!", 0.4, "GNNR_Winch1")
  electrics.values.gunnerwinch_hydro = clamp(electrics.values.gunnerwinch_hydro + winchRelease * dt * 0.01 + electrics.values.gunnerwinch * dt * 0.005 , 0, 1)
else 
electrics.values.gunnerwinch_hydro = clamp(electrics.values.gunnerwinch_hydro + winchRelease * dt * 0.01 + electrics.values.gunnerwinch * dt * 0.005 , 0, 1)
end
else 
  electrics.values.gunnerwinch_hydro = clamp(electrics.values.gunnerwinch_hydro + winchRelease * dt * 0.01 + electrics.values.gunnerwinch * dt * 0.005 , 0, 1)
end



-- SOUND
if gunnerwinch_sound_volume <= 0 then
  obj:cutSFX(gunnerwinch_sound)
  gunnerwinch_sound_stop = true
  gunnerwinch_sound_volume = 0
  --obj:cutSFX(gunnerwinch_sound)
end
if electrics.values.gunnerwinch ~= 0 then
  if electrics.values.gunnerwinch_hydro > 0 then
    if electrics.values.gunnerwinch_hydro < 1 then

      if gunnerwinch_sound_volume < 0.7 then
        gunnerwinch_sound_volume = gunnerwinch_sound_volume + 0.1
      end
      --obj:playSFX(gunnerwinch_sound)
      gunnerwinch_playsound = true
      gunnerwinch_sound_stop = false
else
  gunnerwinch_playsound = false
  if gunnerwinch_sound_stop ~= true then
    gunnerwinch_sound_volume = gunnerwinch_sound_volume - 0.01
    gunnerwinch_playsound2 = true
  end
end
else
  gunnerwinch_playsound = false
  if gunnerwinch_sound_stop ~= true then
    gunnerwinch_sound_volume = gunnerwinch_sound_volume - 0.01
    gunnerwinch_playsound2 = true
  end
end
else
  gunnerwinch_playsound = false
  if gunnerwinch_sound_stop ~= true then
    gunnerwinch_sound_volume = gunnerwinch_sound_volume - 0.01
    gunnerwinch_playsound2 = true
  end
end
obj:setVolumePitch(gunnerwinch_sound, (gunnerwinch_sound_volume), 0.4)
--obj:setVolumePitch(gunnerwinch_sound, 1, 0.4)

if gunnerwinch_playsound == true then
  if gunnerwinch_playsound2 == true then
    obj:playSFX(gunnerwinch_sound)
    gunnerwinch_playsound2 = false
  end
end

end






-- public interface
M.init    = reset
M.reset   = reset
M.updateGFX = updateGFX
M.init = init
M.initSounds = initSounds
M.resetSounds = resetSounds

return M
